<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try {
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
    $bdd->exec("SET CHARACTER SET utf8");
    // ---------------------------
    // --- Début du traitement ---
    // ---------------------------   
    // --------------------------------------------------------------
    // Cette page peut être appelée de plusieurs manières différentes
    // --------------------------------------------------------------
    if (!empty($_POST['valeur_modification_personne']))
    {
      // ===================================================
      // cas où les données des champs ont été saisies
      // on traite ces données et on modifie la personne
      // ===================================================
      // --- on récupère le numéro de la personne à modifier ---
      $numero_modification=$_SESSION['numero_modification'];
      // --- on récupère le tableau des personnes trouvées ---
      $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
      // --- on récupère la personne à modifier ---
      $une_personne=$tab_personnes_trouvees[$numero_modification];
      // --- on mémorise la personne avant la modification ---
      $tab_a_Modifier[$numero_modification]=$une_personne;
      // --- on récupère les informations avant la modification ---      
      $ID     = $une_personne['ID']     ;
      $Nom    = $une_personne['Nom']    ;
      $Prenom = $une_personne['Prenom'] ;
      $Age    = $une_personne['Age']    ;
      // --- pas de modification pour l'ID ---      
      $NouvID = $ID                     ;
      // --- on récupère les valeurs saisies ---
      if (isset($_POST['NouvNom'])) $NouvNom = $_POST['NouvNom'] ;
      else $NouvNom     = ''     ;
      if (isset($_POST['NouvPrenom'])) $NouvPrenom = $_POST['NouvPrenom'] ;
      else $NouvPrenom     = ''  ;
      if (isset($_POST['NouvAge'])) $NouvAge = $_POST['NouvAge'] ;
      else $NouvAge     = ''     ;
      // --- Protection de l'injection HTML ---
      $NouvNom    = strip_tags($NouvNom)   ;
      $NouvPrenom = strip_tags($NouvPrenom);
      $NouvAge    = strip_tags($NouvAge)   ;
      // --- on initialise les différents éléments de la requete SQL UPDATE ---
      $MAJ_Nom    ='';
      $MAJ_Prenom ='';
      $MAJ_Age    ='';
      // -----------------------------------------------
      // on vérifie qu'il y a au moins un champ non vide
      // -----------------------------------------------
      if (!empty($NouvNom) || !empty($NouvPrenom) || !empty($NouvAge))
      {
        // ---------------------------------------
        // on vérifie la validité des chaque champ
        // ---------------------------------------
        $retourValidationID     = true;
        $retourValidationAge    = true;
        $retourValidationNom    = true;
        $retourValidationPrenom = true;
        if ((!empty($NouvAge)) && ($Age!=normalisation_numerique($NouvAge)))
        {
         $NouvAge=normalisation_numerique($NouvAge);
         $retourValidationAge=validation_Age($NouvAge);
         if ($retourValidationAge)
         {
          $Age     = intval($NouvAge);
          $MAJ_Age =',Age='.$Age     ;
         }
        }
        if ( (!empty($NouvNom)) && ($Nom!=normalisation_nom($NouvNom)))
        {
         $NouvNom=normalisation_nom($NouvNom);
         $retourValidationNom=!empty($NouvNom);
         if ($retourValidationNom)
         {
          $Nom     = $NouvNom          ;
          $MAJ_Nom =',Nom=\''.$Nom.'\'';
         }
        }
        if ( (!empty($NouvPrenom)) && ($Prenom!=normalisation_nom($NouvPrenom)))
        {
         $NouvPrenom=normalisation_nom($NouvPrenom);
         $retourValidationPrenom=!empty($NouvPrenom);
         if ($retourValidationPrenom)
         {
          $Prenom     = $NouvPrenom             ;
          $MAJ_Prenom =',Prenom=\''.$Prenom.'\'';
         }
        }
        // ----------------------------------------------------
        // vérification du résultat de la validation des champs
        // ----------------------------------------------------
        if ((!$retourValidationID) || (!$retourValidationAge) || (!$retourValidationNom) || (!$retourValidationPrenom) )
        {
          // -------------------------------
          // si un des champs est invalide
          // -------------------------------
          redirection_delai("modification","MySQL_PDO_modification_personnes_web.php",15);
        }
        else
        {
          // --------------------------------------
          // si tous les champs sont valides
          // on met à jour la table MySQL personnes
          // --------------------------------------
          // --- exécution de la requête ---
          $requete='UPDATE personnes SET '.$MAJ_Nom.$MAJ_Prenom.$MAJ_Age.' WHERE ID='.$ID;
          // --- on supprime les espaces multiples ---
          $requete= preg_replace('/\s{2,}/',' ',$requete);
          // --- on supprime le caractere apostrophe juste apres SET ---
          $requete= str_replace('SET ,','SET ',$requete);
          $reponse = $bdd->exec($requete);
          if (!$reponse) {
            throw new Exception('Probl&egrave;me de requ&ecirc;te sur la table.'.PHP_EOL);
          }
          // --- affichage du résulé de la modification ---
          // on affiche la personne avant sa modification
          affichage_tab_personnes("La personne suivante",$tab_a_Modifier);
          echo WEB_EOL;
          // on affiche la personne après sa modification
          $une_personne=compact('ID','Nom','Prenom','Age');
          $tab_Modifiee[$numero_modification]=$une_personne;
          affichage_tab_personnes("est modifi&eacute;e en",$tab_Modifiee);
        }
      }
      else
      {
       ?>
       <fieldset>
       <legend>Aucune modification :</legend><br/>
       <b>Pas de modification : tous les champs sont vides ! </b><br />
       </fieldset>
       <?php
      }
    }
    elseif (!empty($_POST['choix_modification_personne']))
    {
     // ===================================================
     // cas où la personne à modifier a été sélectionnée
     // on demande la confirmation de la modification
     // ===================================================
     // --- on récupère le tableau des personnes trouvées ---
     $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
     // --- on récupère le numéro de la personne à modifier ---
     $numero_modification=$_POST['NumModif']                       ;
     // --- Protection de l'injection HTML ---
     $numero_modification = intval(strip_tags($numero_modification));
     $_SESSION['numero_modification']=$numero_modification ;     
     if ( (empty($numero_modification)) || (!array_key_exists($numero_modification,$tab_personnes_trouvees)) )
     {
      ?>
      <fieldset>
      <legend>Aucune s&eacute;lection :</legend><br/>
      <b>Aucune s&eacute;lection ! </b><br />
      </fieldset>
      <?php
     }
     else
     {
      unset($tab_une_personne);
      $une_personne=$tab_personnes_trouvees[$numero_modification];
      $tab_une_personne[]=$une_personne;
      affichage_liste_personnes("Personne &agrave; modifier",$tab_une_personne);
      $Nom=$une_personne['Nom'];
      $Prenom=$une_personne['Prenom'];
      $Age=$une_personne['Age'];
      ?>
      <br/>
      <form action="MySQL_PDO_modification_personnes_web.php" method="post">
       <fieldset>
       <legend>Saisissez les nouvelles valeurs :</legend><br/>
       <b>ATTENTION</b> : un champ non renseign&eacute; (vide) laisse la valeur inchang&eacute;e !
       <table summary="Tableau de modification">
        <caption>&nbsp;</caption>
        <thead>
         <tr>
          <!-- entête du tableau -->
          <th>Nouveau Nom</th>
          <th>Nouveau Pr&eacute;nom</th>
          <th>Nouvel Age</th>
         </tr>
        </thead>
        <tr>
         <td><input type="text" name="NouvNom" size="20" maxlength="20" placeholder="<?php echo $Nom; ?>" autofocus/></td>
         <td><input type="text" name="NouvPrenom" size="40" maxlength="40" placeholder="<?php echo $Prenom; ?>"/></td>
         <td><input type="text" name="NouvAge" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="<?php echo $Age; ?>" /></td>
        </tr>
       </table>
       <br/><br/>
       <input type="submit" name="valeur_modification_personne" value="Modifier cette personne" />
       <input type="reset" value="Effacer le formulaire" />
       </fieldset>
      </form>
      <?php
     }
    }
    elseif (!empty($_POST['rechercher_critere']))
    {
     // =================================================================
     // cas où le formulaire de saisie a été validé et on appelle
     // une nouvelle fois ce programme avec les données du formulaire
     // on affiche un formulaire pour sélectionner la personne à modifier
     // parmi la liste des personnes affichées
     // =================================================================
     $crit_recherche = $_POST['CritRech'];
     $val_recherche  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $crit_recherche = strip_tags($crit_recherche);
     $val_recherche  = strip_tags($val_recherche) ;
     // --- Recherche ---
     $tab_personnes_trouvees=Recherche_sur_critere($bdd,'personnes',$crit_recherche,$val_recherche);
     if (count($tab_personnes_trouvees) == 0)
     {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La recherche pour <?php echo "$crit_recherche=$val_recherche";?> n'a trouv&eacute; aucune personne ! </b><br />
       </fieldset>
       <?php
     }
     else
     {
       // --- on conserve dans une variable de session le tableau des personnes trouvées ---
       $_SESSION['tab_personnes_trouvees']=$tab_personnes_trouvees ;
       // --- affichage de la liste de personnes trouvées ---
       affichage_liste_personnes("Liste des personnes trouv&eacute;es",$tab_personnes_trouvees);
       // affichage du formulaire de saisie de la personne à modifier
       ?>
       <br/>
       <form action="MySQL_PDO_modification_personnes_web.php" method="post">
        <fieldset>
        <legend>Saisissez le Num&eacute;ro (ID) de la personne &agrave; modifier :</legend><br/>
        Entrez le <b>Num&eacute;ro</b> de la personne &agrave; modifier : <input type="text" name="NumModif" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_modification_personne" value="Modifier" />
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
     }
    }
    else
    {
     // ===============================================
     // cas où on doit afficher le formulaire de saisie
     // pour rechercher la personne à modifier
     // ===============================================
     ?>
     <br/>
     <form action="MySQL_PDO_modification_personnes_web.php" method="post">
     <fieldset>
     <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
     S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
     Identifiant <input type="radio" name="CritRech" value="ID"> 
     Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
     Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
     Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
     Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="rechercher_critere" value="Rechercher" />
     <input type="reset" value="Effacer le formulaire" />
     </fieldset>
     </form>
     <?php
    }
   }
   catch(Exception $e) {
    echo "<fieldset>";
    echo "<legend>Erreur :</legend><br/>";
    echo $e->getMessage();
    echo "</fieldset>";
   }
   ?>
 </body>
</html>
