<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try {
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
    $bdd->exec("SET CHARACTER SET utf8");     
    // --- cas du bouton terminer qui a été sélectionné ---
    if (!empty($_POST['terminer']))
    {
     // ----------------------------------
     // --- cas de la fin de la saisie ---
     // ----------------------------------
     // --- Tri du tableau ---
     $_SESSION['tab_personnes']=tri_tab_personnes($_SESSION['tab_personnes']);
     // --- affichage du résumé de la saisie ---
     $tab_personnes=$_SESSION['tab_personnes'];
     affichage_tab_personnes("Liste des personnes saisies",$tab_personnes);  
    }
    // -----------------------------------------------------------------------
    // sinon on affiche le formulaire et les informations complémentaires 
    // -----------------------------------------------------------------------
    else   
    {
     ?>
     <!--
     --------------------------------
     --- on affiche le formulaire ---
     --------------------------------
     -->
     <form action="MySQL_PDO_insertion_personnes_web.php" method="post">
      <fieldset>
      <legend>Saisissez les donn&eacute;es d'une nouvelle personne :</legend><br/>
      Entrez un nom : <input type="text" name="Nom" size="20" maxlength="20" placeholder="Dupont de Nemours" autofocus/><br/><br/>
      Entrez un pr&eacute;nom : <input type="text" name="Prenom" size="40" maxlength="40" placeholder="Jean Charles"/><br/><br/>
      Entrez un &acirc;ge : <input type="text" name="Age" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28"/><br/><br/>
      <input type="submit" name="valider" value="Valider cette personne" />
      <input type="reset" value="Effacer le formulaire" />
      <!-- on ajoute le bouton terminer pour terminer la saisie  -->
      <input type="submit" name="terminer" value="Terminer la Saisie" />
      </fieldset>
     </form>
     <?php
     // -----------------------------------------------------------------
     // on affiche sous le formulaire le résultat du traitement précédent
     // - soit le rangement dans le tableau tab_personnes
     // - soit un message d'erreur (sauf pour le premier affichage) 
     // -----------------------------------------------------------------
     // --- on récupère les valeurs saisies ---
     if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ;
     else $Nom     = ''     ;
     if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ;
     else $Prenom     = ''  ;
     if (isset($_POST['Age'])) $Age = $_POST['Age'] ;
     else $Age     = ''     ;
     // --- Protection de l'injection HTML ---
     $Nom    = strip_tags($Nom)    ;
     $Prenom = strip_tags($Prenom) ;
     $Age    = strip_tags($Age)    ;    
     // --- On conserve les valeurs initiales ---
     $InitNom    = $Nom    ;
     $InitPrenom = $Prenom ;
     $InitAge    = $Age    ;
     // si ce n'est pas la première saisie
     if (!empty($_SESSION['Afficher_Messages_Champs']))
     {
      // ---------------------------------------
      // on vérifie qu'il n'y a aucun champ vide
      // ---------------------------------------
      if ((!empty($InitNom)) && (!empty($InitPrenom)) && (!empty($InitAge)))
      {
       // ---------------------------------------
       // on vérifie la validité des chaque champ
       // ---------------------------------------
       $retourValidationAge    = true ;
       $retourValidationNom    = true ;
       $retourValidationPrenom = true ;
       if (!empty($InitAge))
       {
        $InitAge=normalisation_numerique($InitAge)   ;
        $retourValidationAge=validation_Age($InitAge);
        if ($retourValidationAge)
        {
         $Age  = intval($InitAge) ;
        }
       }
       if (!empty($InitNom))
       {
        $InitNom=normalisation_nom($InitNom) ;
        $retourValidationNom=!empty($InitNom);
        if ($retourValidationNom)
        {
         $Nom  = $InitNom ;
        }
       }
       if (!empty($InitPrenom))
       {
        $InitPrenom=normalisation_nom($InitPrenom) ;
        $retourValidationPrenom=!empty($InitPrenom);
        if ($retourValidationPrenom)
        {
         $Prenom  = $InitPrenom ;
        }
       }
       // -------------------------------
       // si tous les champs sont valides
       // -------------------------------
       if (($retourValidationAge) && ($retourValidationNom) && ($retourValidationPrenom) )
       {
        // -----------------------------------------
        // --- insertion de la nouvelle personne ---
        // -----------------------------------------
        // --- exécution de la requête ---
        // --- ici il n'y a pas de protection contre l'injection SQL ---
        // --- Pour cela il faut utiliser le méthode prepare ---
        $requete="INSERT INTO personnes (Nom, Prenom, Age) VALUES ('$Nom','$Prenom',$Age)";
        $reponse = $bdd->exec($requete);
        if (!$reponse)
        {
         throw new Exception('Problème de requête sur la table : '.$requete.WEB_EOL);
        }
        // ------------------------------------------------------------
        // --- récupération des informations de la personne insérée ---
        // ------------------------------------------------------------
        // --- exécution de la requête ---
        $requete="SELECT ID,Nom,Prenom,Age FROM personnes ORDER BY ID DESC  LIMIT 1";
        $reponse = $bdd->query($requete);
        if (!$reponse)
        {
         throw new Exception('Problème de requête sur la table : '.$requete.WEB_EOL);
        }
        unset($une_personne);
        $une_personne = $reponse->fetch()      ;
        // --- fermeture de la requête ---
        // --- pour permettre d'autres requêtes ---
        $reponse->closeCursor();
        // -------------------------------------------------------------
        // --- rangement dans le tableau tab_personnes de la session ---
        // -------------------------------------------------------------
        $_SESSION['tab_personnes'][]=$une_personne ;
        // --- affichage de la personne qui vient d'être insérerée dans la table des personnes ---
        affichage_une_personne("Derni&egrave;re personne saisie",$une_personne)  ;
       }
      }
      // -----------------------------------------------------------------
      // on affiche les éventuels messages d'erreur en cas de champs vides
      // -----------------------------------------------------------------
      else
      {
       echo "<fieldset>";
       echo "<legend>Valeurs &agrave; renseigner :</legend><br/>";
       if (empty($InitNom))    echo "Le champ Nom est vide".WEB_EOL;
       if (empty($InitPrenom)) echo "Le champ Pr&eacute;nom est vide".WEB_EOL;
       if (empty($InitAge))    echo "Le champ Age est vide".WEB_EOL;
       if ($InitAge == 0)      echo "Le champ Age est invalide".WEB_EOL;
       echo "</fieldset>";
      }
     }
     // ------------------------------------------------------------------
     // ce n'est pas la première saisie : la variable indiquant d'afficher
     // les éventuels messages d'erreur est positionnée
     // ------------------------------------------------------------------
     else
     {
      $_SESSION['Afficher_Messages_Champs']=true;
     }
    }
   }
   catch(Exception $e) {
    echo "<fieldset>";
    echo "<legend>Erreur :</legend><br/>";
    echo $e->getMessage();
    echo "</fieldset>";
   }
   ?>
 </body>
</html>
