<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table clients</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   //define("WEB_EOL","<br/>");
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   try {
    // ----------------------------------------------------
    // --- affichage de la liste complète des clients ---
    // ----------------------------------------------------
    if (empty($_POST['valider']))
    {
     // === connexion de la base de données ===
     // $bdd = new PDO('mysql:host=localhost;dbname=CoursPHP', 'root', 'mot_de_passe',
     //       array(PDO::ATTR_PERSISTENT => true));
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT * FROM clients');
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque client --- 
     $tab_clients=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Liste des clients",$tab_clients);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
     ?>
     <!--
     ---------------------------------------------------
     --- formulaire de saisie du critère de filtrage ---
     ---------------------------------------------------
     -->
     <form action="MySQL_PDO_query_fetch_round_sum_group_by_having_clients_web.php" method="post">
      <fieldset>
      <legend>Tranches d'&acirc;ges dont le solde total d&eacute;passe :</legend><br/>
      Entrez le seuil du solde total au del&agrave; duquel le calcul est affich&eacute; (ex: 1000) : <input type="text" name="Solde" size="20" maxlength="20" pattern="[1-9][0-9,.]{1,}" /><br/><br/>
      <input type="submit" name="valider" value="Valider le filtrage" />
      <input type="reset" value="Effacer le formulaire" />
      </fieldset>
     </form>
     <?php
    }
    else
    {
     // -------------------------------------------------------------------------
     // --- affichage de la liste des clients selon le critère de sélection ---
     // -------------------------------------------------------------------------
     // --- récupération de la variable Solde ---
     $Solde=$_POST['Solde'];
     $Solde=str_replace(",",".",$Solde);
     $Solde=floatval($Solde);
     // === connexion de la base de données ===
     // $bdd = new PDO('mysql:host=localhost;dbname=CoursPHP', 'root', 'mot_de_passe',
     //       array(PDO::ATTR_PERSISTENT => true));
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT Age,ROUND(SUM(Solde),2) AS solde_total FROM clients GROUP BY Age HAVING solde_total>'.$Solde);
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque client --- 
     $tab_clients=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Solde total des comptes clients par &acirc;ge",$tab_clients);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
    }
   }
   catch(Exception $e) {
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>







