<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table clients</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   //define("WEB_EOL","<br/>");
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   try {
     // -------------------------------------------------------------------------
     // --- affichage de la liste des clients selon le critère de sélection ---
     // -------------------------------------------------------------------------
     // === connexion de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT cb.ID_Clt,cl.Nom,cl.Prenom,ROUND(SUM(cb.Solde),2) Solde_Total FROM comptes_bancaires cb INNER JOIN clients_bancaires cl ON cb.ID_Clt=cl.ID_Clt GROUP BY cb.ID_Clt');
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque client --- 
     $tab_clients=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Solde total par propri&eacute;taire",$tab_clients);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
   }
   catch(Exception $e) {
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>




