<?php
include '../../INCLUDE/MySQL_include_param_dbb.php';
include '../../INCLUDE/MySQL_include_sprog_commun_shell.php';
setlocale (LC_ALL, 'fr_FR.UTF-8');
try {
 // === connexion de la base de données ===
 $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
        array(PDO::ATTR_PERSISTENT => true));
 // --- définition du codage en UTF8 ---
 $bdd->exec("SET CHARACTER SET utf8");     
 // --- exécution de la requête ---
 $reponse = $bdd->query('SELECT ID,Nom,Prenom,DATE_FORMAT(Date_Naissance,\'%d/%m/%Y\') As Date_Naissance FROM clients');
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
     throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque client --- 
 $tab_clients=$reponse->fetchAll();
 // --- affichage des données retournées ---
 affichage_liste_personnes("Liste des clients",$tab_clients);
 // --- fermeture de la requête ---
 // --- pour permettre d'autres requêtes ---
 $reponse->closeCursor();
 // === Saisie du filtre ===
 echo PHP_EOL;
 echo "Afficher la liste des clients dont la date de naissance est supérieure à (ex: 01/01/1970) : ";
 $date_saisie=fgets(STDIN);
 $date_saisie=trim($date_saisie);
 $date_saisie = preg_replace('/\s{1,}/', '', $date_saisie) ;
 if (! ValidationDate($date_saisie, 'd/m/Y'))
     throw new Exception('Date invalide.');
 $date_format_SQL=ConversionDate($date_saisie,'d/m/Y','Y-m-d');
 // === Affichage filtré de la table clients ===
 // --- exécution de la requête ---
 $requete="SELECT ID,Nom,Prenom,DATE_FORMAT(Date_Naissance,'%d/%m/%Y') As Date_Naissance FROM clients WHERE Date_Naissance >= '".$date_format_SQL."'";
 $reponse = $bdd->query($requete);
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
    throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque client --- 
 $tab_clients=$reponse->fetchAll();
 // --- affichage des données retournées ---
 affichage_liste_personnes("Liste des clients ayant une date de naissance >= ".$date_saisie,$tab_clients);
 // --- fermeture de la requête ---
 // --- pour permettre d'autres requêtes ---
 $reponse->closeCursor();
 // === fermeture de la connexion à la base de données ===
 $bdd = NULL;
}
catch(Exception $e) {
 echo 'Erreur : '.$e->getMessage();
}
?>

