<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table clients</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   //define("WEB_EOL","<br/>");
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   try {
    // ----------------------------------------------------
    // --- affichage de la liste complète des clients ---
    // ----------------------------------------------------
    if (empty($_POST['valider']))
    {
     // === connexion de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT ID,Nom,Prenom,DATE_FORMAT(Date_Naissance,\'%d/%m/%Y\') As Date_Naissance FROM clients');
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque client --- 
     $tab_clients=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Liste des clients",$tab_clients);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
     ?>
     <!--
     ---------------------------------------------------
     --- formulaire de saisie du critère de filtrage ---
     ---------------------------------------------------
     -->
     <form action="MySQL_PDO_query_fetch_filtre_date_naissance_clients1b_web.php" method="post">
      <fieldset>
      <legend>Liste des clients dont la date de naissance est sup&eacute;rieure &agrave; :</legend><br/>
      Entrez la date de naissance à partir de laquelle les clients seront affichés à (ex: 01/01/1970) : <input type="date" name="DateNaissance" size="10" maxlength="10" /><br/><br/>
      <input type="submit" name="valider" value="Valider le filtrage" />
      <input type="reset" value="Effacer le formulaire" />
      </fieldset>
     </form>
     <?php
    }
    else
    {
     // -------------------------------------------------------------------------
     // --- affichage de la liste des clients selon le critère de sélection ---
     // -------------------------------------------------------------------------
     // --- récupération de la variable DateNaissance ---
     $date_saisie=$_POST['DateNaissance'];
     $date_saisie=trim($date_saisie);
     $date_saisie = preg_replace('/\s{1,}/', '', $date_saisie) ;
     if (! ValidationDate($date_saisie, 'd/m/Y'))
         throw new Exception('Date invalide.');
     $date_format_SQL=ConversionDate($date_saisie,'d/m/Y','Y-m-d');

     // === connexion de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $requete="SELECT ID,Nom,Prenom,DATE_FORMAT(Date_Naissance,'%d/%m/%Y') As Date_Naissance FROM clients WHERE Date_Naissance >= '".$date_format_SQL."'";
     $reponse = $bdd->query($requete);
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque client --- 
     $tab_clients=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Liste des clients ayant une date de naissance >= ".$date_saisie,$tab_clients);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
    }
   }
   catch(Exception $e) {
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>







