<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table personnes</title>
	<link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   define("WEB_EOL","<br/>");
   try {
    // === connexion de la base de données ===
    $bdd = new PDO('mysql:host=localhost;dbname=CoursPHP', 'root', 'mot_de_passe');
    // --- définition du codage en UTF8 ---
    $bdd->exec("SET CHARACTER SET utf8");
    // === on récupère la structure (nom des champs) de la table ===
    $struture_table = $bdd->query('DESCRIBE personnes');
    if (!$struture_table) throw new Exception('Problème de requête sur la table.');
    // --- par défaut, chaque récupération par fetch retourne un tableau associatif ---
    $struture_table->setFetchMode(PDO::FETCH_ASSOC); 
    // === on récupère les données de la table ===
    $reponse = $bdd->query('SELECT * FROM personnes');
    // --- traitement des erreurs de retour sur la requête ---
    if (!$reponse) throw new Exception('Problème de requête sur la table.');
    // === affichage des données sous la forme d'un tableau ===
    // --- entête du tableau ---
    echo '<table summary="Tableau des personnes">';
    echo '<caption>Tableau des personnes</caption>';
    echo '<thead>';
    echo "<tr>"; 
    // --- boucle d'affichage du nom des champs --- 
    while ($Liste_Champs = $struture_table->fetch()) {
     $NomChamp=$Liste_Champs['Field'];
     echo "<th>$NomChamp</th>";
    }
    echo "</tr>"; 
    echo '</thead>';
    // --- lignes du tableau ---
    // --- par défaut, chaque récupération par fetch retourne un tableau associatif ---
    $reponse->setFetchMode(PDO::FETCH_ASSOC); 
    // --- boucle de traitement de chaque personne --- 
    while ($une_personne = $reponse->fetch()) {
     echo "<tr>";
     foreach($une_personne as $NomChamp => $ContenuChamp) {
      echo "<td>".$une_personne[$NomChamp]."</td>";
     }
     echo "</tr>"; 
    }
    ?>
    </table>
    <?php
    // --- fermeture de la requête ---
    // --- pour permettre d'autres requêtes ---
    $struture_table->closeCursor();
    $reponse->closeCursor();
    // --- fermeture de la connexion à la base de données ---
    $bdd = NULL;
   }
   catch(Exception $e) {
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>
