<?php
try {
 // --- connexion de la base de données ---
 $bdd = new PDO('mysql:host=localhost;dbname=CoursPHP', 'root', 'mot_de_passe');
 // --- définition du codage en UTF8 ---
 $bdd->exec("SET CHARACTER SET utf8");
 // --- exécution de la requête ---
 $reponse = $bdd->query('SELECT * FROM personnes');
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
 {
   throw new Exception('Problème de requête sur la table.'.PHP_EOL);
 }
 // --- affichage des données retournées ---
 echo "--- contenu de la table personnes ---".PHP_EOL;
 // --- boucle de traitement de chaque personne ---
 // --- chaque récupération par fetch retourne un tableau associatif ---
 while ($une_personne = $reponse->fetch(PDO::FETCH_ASSOC))
 {
   foreach($une_personne as $NomChamp => $ContenuChamp)
   {
    echo "$une_personne[$NomChamp]"."\t";
   }
   echo PHP_EOL;
 }
 // --- fermeture de la requête ---
 // --- pour permettre d'autres requêtes ---
 $reponse->closeCursor();
 // --- fermeture de la connexion à la base de données ---
 $bdd = NULL;
}
catch(Exception $e) {
 echo 'Erreur : '.$e->getMessage();
}
?>

