<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table personnes</title>
	<link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   define("WEB_EOL","<br/>");
   try{
    // --- connexion de la base de données ---
    $bdd = new PDO('mysql:host=localhost;dbname=CoursPHP', 'root', 'mot_de_passe');
    // --- définition du codage en UTF8 ---       
    $bdd->exec("SET CHARACTER SET utf8");     
    // --- exécution de la requête ---
    $reponse = $bdd->query('SELECT * FROM personnes');
    // --- traitement des erreurs de retour sur la requête ---
    if (!$reponse)
    {
     throw new Exception('Problème de requête sur la table.');
    } 
    // --- affichage des données sous la forme d'un tableau ---
    ?>
    <table summary="Tableau des personnes">
    <caption>Tableau des personnes</caption>
    <thead>
    <tr>
    <!-- entête du tableau -->
        <th>ID</th>
        <th>Nom</th>
        <th>Pr&eacute;nom</th>
        <th>Age</th>
        </tr>
    </thead>
    <?php
    // --- boucle de traitement de chaque personne ---
    foreach ($reponse->fetchAll() as $etiquette => $une_personne)
    {
     echo "<tr>";
     echo "<td>".$une_personne['ID']."</td>";
     echo "<td>".$une_personne['Nom']."</td>";
     echo "<td>".$une_personne['Prenom']."</td>";
     echo "<td>".$une_personne['Age']."</td>";
     echo "</tr>"; 
    }
    ?>
    </table>
    <?php
    // --- fermeture de la requête ---
    // --- pour permettre d'autres requêtes ---
    $reponse->closeCursor();
    // --- fermeture de la connexion à la base de données ---
    $bdd = NULL;
   }
   catch(Exception $e){
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>
