(function (window, undefined){
	"use strict";
	
	var document = window.document;
	var validate = ($.fn.validate !== undefined);
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function SendURL() {
		if (!(this instanceof SendURL)) {
			return new SendURL();
		}
				
		this.init.call(this);
		
		return this;
	}
	
	SendURL.prototype = {
		
		init: function () {
			var self = this;
			var $container = $('#pjSendURLContainer');
			
			
			if($container.length > 0)
			{
				$container.on('click', '.pjTriggerDialog', function(){
					if($('.pjDbPopupAutoLoad').length > 0)
					{
						self.bindDialog();
					}else{
						self.loadDialog();
					}
				});
			};
			
			$(document).on("click", ".pjDbBtnClose", function (e) {
				$('.pjDbPopupAutoLoad').removeClass('pjDbPopupActive');
				var htmlElement = document.querySelector("html");
            	htmlElement.style.overflow = "";
			});
		},
		loadDialog: function(){
			var self = this;
			var htmlDialog = $('#pjDialogClone').html();
			var dialogDiv = document.createElement('div');
			dialogDiv.id = "pjDbPopup";
			dialogDiv.className = "pjDbPopup pjDbPopupAutoLoad";
			document.body.appendChild(dialogDiv);
			dialogDiv.innerHTML = htmlDialog;
			self.bindDialog();
		},
		bindDialog: function(){
			
			var $currentPopup = $('.pjDbPopupAutoLoad');
			var $form = $('#pjDbPopup').find('form');
			var $message = $('#pjDbPopup').find('#pjSendMessage');
			if ($currentPopup.length > 0) 
			{
				
				var $currentPopupContent = $('.pjDbPopupContent');
				var $currentPopupContentInner = $('.pjDbPopupContentInner');
				if($currentPopupContent.length > 0 && $currentPopupContentInner.length > 0)
				{
					if(!$currentPopup.hasClass('pjDbPopupActive'))
					{
						var htmlElement = document.querySelector("html");
						var w = window,
					    	d = document,
					    	e = d.documentElement,
					    	g = d.getElementsByTagName('body')[0],
					    	win_width = w.innerWidth || e.clientWidth || g.clientWidth,
					    	win_heigth = w.innerHeight|| e.clientHeight|| g.clientHeight;
						
						htmlElement.style.overflow = "hidden";
						$currentPopup.css('width', win_width + 'px');
						$currentPopup.css('height', win_heigth + 'px');
						if($form.length > 0)
						{
							$form.find('input').val("");
						}
						$currentPopup.addClass('pjDbPopupActive');
					}else{
						$currentPopup.addClass('pjDbPopupActive')
					}
					$currentPopup.find('input[name="url"]').val(window.location.href);
				}
			}
			if($form.length > 0 && validate)
			{
				$form.validate({
					errorPlacement: function (error, element) {
						error.insertAfter(element);
					},
					onkeyup: false,
					errorClass: "err",
					wrapper: "em",
					submitHandler: function(form){
						$form.find('button').prop('disabled', true);
						
						$message.html("URL has been sending...").parent().show();
						$.post("send.php", $form.serialize()).done(function (data) {
							
							$form.find('input').val("");
							$form.find('button').prop('disabled', false);
							
							$message.html(data).parent().show();
							
							setTimeout(function(){ 
								$('.pjDbPopupAutoLoad').removeClass('pjDbPopupActive');
								var htmlElement = document.querySelector("html");
				            	htmlElement.style.overflow = "";
							}, 3000);
							
						}).fail(function () {
							$form.find('button').prop('disabled', false);
						});
						
						return false;
					}
				});
			}
		}
		
	};
	
	window.SendURL = SendURL;	
})(window);

window.onload = function() {
	SendURL = SendURL();
}