<?

////////////////////////////////////////////////////////////
//
// spiderCount v1.2 - a simple image-based hit counter
//
////////////////////////////////////////////////////////////
//
// This file outputs the current hit count (without
// incrementing it) as a PNG image.
//
// See readme.txt for more information.
//
// Author: Jon Thomas <http://www.fromthedesk.com/code>
// Last Modified: 2006-10-30
//
// You may freely use, modify, and distribute this script.
//
////////////////////////////////////////////////////////////

//
// SET VARIABLES
//

// filename of hit count
$count_filename = "counter.txt";

// minimum number of digits to display
$min_digits = 6; // set to 0 to display hits count as is

// location of digit images
$digits_location = "images/fancy/";

// dimensions of digit images in pixels
$digit_width = 39;
$digit_height = 39;


//
// OUTPUT HIT COUNT AS A PNG IMAGE
//

// open count file for reading only
$count_file = fopen($count_filename, "r");

// get current hit count
$hit_count = fgets($count_file, filesize($count_filename) + 1);

// close count file
fclose($count_file);

// get number of digits in hit count
$no_digits = strlen($hit_count);

// use a minimum number of digits to display hit count
if ($no_digits < $min_digits) {
	// get number of zeroes to append to hit count
	$no_zeroes = $min_digits - $no_digits;

	// append zeroes to hit count
	for ($i = 0; $i < $no_zeroes; $i++) {
		$hit_count = "0" . $hit_count;
	}

	// get new number of digits in hit count
	$no_digits = $min_digits;
}

// send headers for PNG image
header("Content-type: image/png");

// create hit count image
$count_image = imagecreate($digit_width * $no_digits, $digit_height);

// add digit images to hit count image
for ($i = 0; $i < $no_digits; $i++) {
	// get digit in this part of hit count
	$digit = substr($hit_count, $i, 1);

	// get image for this digit
	$digit_image = imagecreatefrompng($digits_location . $digit . ".png");

	// get x-coordinate for placing this digit in count image
	$x = $digit_width * $i;

	// place digit image within count image
	imagecopymerge($count_image, $digit_image, $x, 0, 0, 0, $digit_width, $digit_height, 100);
}

// output hit count image
imagepng($count_image);

// clear memory
imagedestroy($count_image);

?>