<?php
//moteur de recherche de l'annuaire

include("data_bd_annuaire.php"); //variables de l'annuaire
include("functions.php"); //fonctions de l'annuaire

$mots = isset($_REQUEST['mots']) ? $_REQUEST['mots'] : '';
$mots = trim($mots);
$page = isset($_GET['page']) ? (int)$_GET['page'] : 0;
if($page < 0)
	exit;

$booleen = isset($_REQUEST['booleen']) ? $_REQUEST['booleen'] : '';
if(empty($booleen) or $booleen != "OR")
	$booleen = "AND";

$nb_results2show = isset($_REQUEST['nb_results2show']) ? (int)$_REQUEST['nb_results2show'] : 0;
if($nb_results2show <= 0)
	$nb_results2show = 10;

?>
<html>
<head>
<title>Recherche dans l'annuaire</title>
<script language="JavaScript" src="js_annuaire.js"></script>
<link type="text/css" href="myphpannuaire.css" rel="stylesheet">
<?php
//fichier qui contient vos meta-tags et tout ce qui doit venir dans la partie HEAD de vos pages
include("meta.php");
?>
</head>
<body>
<?php
//fichier qui contient tout ce qui doit venir avant le code de l'annuaire (menu de gauche....)
include("before.php");

include ("haut.php"); //lien divers de l'annuaire (top clics, top votes, ajout,...)

//moteur de recherche de l'annuaire

//calcul du temps de debut de recherche
$time_deb = microtime();
$time_deb = explode(" ",$time_deb);
$time_deb = $time_deb[0] + $time_deb[1];

//on verifie la taille du mot recherche pour voir si on n'a pas entrer qu'une ou deux lettres
if ($mots == "Votre recherche :")
	$mots = "";
$trop_court = false;

if (strlen(stripslashes($mots)) < 3)
//la taille du mot est trop court....
	$trop_court = true;

if (!get_magic_quotes_gpc())
//on rajoute des slash pour les magic_quote en OFF
	$mots = addslashes($mots);

if (!empty($page)) //si on n'est pas sur la premiere page des resultats
	$mots = rawurldecode($mots);

//on separe chaque mot dans un element de tableau
$mots_cherches = explode(" ",$mots);
//liste des mots a rejetter : vous pouvez en rajouter (ils doivent faire au moins 3 caracteres !!!)
$bad_words[] = "";
$bad_words[] = "des";
$bad_words[] = "une";
$bad_words[] = "les";

//on enleve les petits mots inutiles
$ln_tab = sizeof($mots_cherches);
for ($i=0;$i<$ln_tab;$i++) 
//on compare chaque mot a ceux non voulu
{
	if (!is_in_array(trim($mots_cherches[$i]),$bad_words) && strlen($mots_cherches[$i]) > 2) 
		$mots_reels_recherches[] = $mots_cherches[$i];
}
$nb_mots = sizeof($mots_reels_recherches);

if ($nb_mots > 0 && !$trop_court)
//si on a au moins un mot pour la recherche
{	
	if (empty($page))
	//premiere page
		$page = 1;
	//debut pour la clause LIMIT de la requete des sites
	$debut = ($page - 1) * $nb_results2show;

	//on peut effectuer la requete pour trouver les mots reellement recherches dans les sites et dans les catgories
	//requete pour effectuer la recherche dans les sites
	$sql_sites = "SELECT s.*, cat_name, TO_DAYS(CURRENT_DATE) - TO_DAYS(date_validation) AS dif_days FROM $T_sites AS s, $T_categories AS c WHERE s.id_cat = c.id AND s.activation = 1 AND c.activation = 1 AND (";

	$cond_sites = "";
	//requete pour les sites
	for ($i=0;$i<$nb_mots;$i++)
	{
		$cond_sites .= " (titre LIKE '%$mots_reels_recherches[$i]%' OR description LIKE '%$mots_reels_recherches[$i]%' OR url LIKE '%$mots_reels_recherches[$i]%') ";
		if ($i != ($nb_mots - 1)) //si on n'est pas sur le dernier mot
			$cond_sites .= $booleen;
	}
	$sql_sites .= $cond_sites;
	$sql_sites .= ") ORDER BY niveau ASC,titre ASC LIMIT $debut,$nb_results2show ";
	// echo 'sel : '.$sql_sites;
	if ($page == 1)
	//construction des requetes pour le nombre de resultats et la recherche dans les categories
	{
		//requete pour effectuer la recherche dans les categories
		$sql_cats = "SELECT * FROM $T_categories WHERE activation = 1	AND (";
		//requete pour trouver le nombre total de sites dans le resultat
		$sql_nb_sites = "SELECT count(s.id) AS count FROM $T_sites AS s, $T_categories AS c	WHERE s.id_cat = c.id AND s.activation = 1 AND c.activation = 1 AND (";

		//requete pour les categories
		for ($i=0;$i<$nb_mots;$i++)
		{
			$sql_cats .= " (cat_name LIKE '%$mots_reels_recherches[$i]%' OR texte LIKE '%$mots_reels_recherches[$i]%') ";
			if ($i != ($nb_mots - 1)) //si on n'est pas sur le dernier mot
				$sql_cats .= $booleen;
		}
		$sql_nb_sites .= $cond_sites;
		$sql_nb_sites .= ") ";
		$sql_cats .= ") ORDER BY cat_name ASC ";
	}
	//creation de la requete pour aller chercher le nombre de jours pour etre nouveau
	$sql_admin = "SELECT nb_days2benew FROM $T_infos ";
	//connexion a la BD
	$lk = connection_BD();
	//envoi des requetes
	$res_admin = send_sql($sql_admin,"trouver le nombre de jour pour etre considere comme nouveau (moteur de recherche)");
	$nb_days2benew = mysql_result($res_admin,0,"nb_days2benew");
	$res_sites = send_sql($sql_sites,"trouver des rsultats pour les sites (moteur de recherche)");
	if ($page == 1)
	{
		$res_nb_sites = send_sql($sql_nb_sites,"trouver le nombre de sites faisant partie du rsultat de la recherche");
		$res_cats = send_sql($sql_cats,"trouver des rsultats pour les catgories (moteur de recherche)");	
		//on traite les resultats trouves
		$nb_cats_trouvees = mysql_num_rows($res_cats);
		$nb_sites_trouves = mysql_result($res_nb_sites,0,'count');
	}
	else
	{
		$nb_sites_trouves = isset($_GET['nb_sites_trouves']) ? (int)$_GET['nb_sites_trouves'] : 0;
		$nb_cats_trouvees = 0; // on affiche les categories trouvees que sur la premiere page de resultats
	}
	//calcul du nombre de pages
	$nb_pages = ceil($nb_sites_trouves / $nb_results2show);
	
	//TIMER
	//on calcule le temps de la recherche
	$time_fin = microtime();
	$time_fin = explode(" ",$time_fin);
	$time_fin = $time_fin[0] + $time_fin[1];

	$time_search = $time_fin - $time_deb; 		
	if ($page == 1)
	{
		?>
		<center>
		<span class="timer_search_annuaire">
		<?php printf ("%d catgorie(s) et %d site(s) trouv(s) pour \"%s\" en %.3f s\n",$nb_cats_trouvees,$nb_sites_trouves,stripslashes(htmlspecialchars($mots)),$time_search); ?>
		</span>
		</center>
		<br><br>
		<?php
	}

	if ($page == 1 && $nb_cats_trouvees)
	//si on a trouve des categories
	{
		?>
		<table width="90%" border=0 align="center">
		<span class="res_search_cat_site_annuaire">
		Catgorie(s) trouve(s) :
		</span>
		<br><br>
		<?php
		while ($resultat = mysql_fetch_array($res_cats,MYSQL_ASSOC))
		{ 
			?>
			<tr>
			<td width="100%">
			<?php
			$arbo = show_arbo_en_ligne($resultat["id"], "index.php", " : ");
			//on met les mots cles en gras
			for ($i = 0; $i < $nb_mots; $i++)
				$arbo = keyword_in_bold($mots_reels_recherches[$i], $arbo);
			echo $arbo;
		}
		?>
		</table>
		<br><br>
		<?php
	}
	if ($nb_sites_trouves)
	//on a trouve des sites
	{
		?>
		<table width="90%" border=0 align="center">
		<span class="res_search_cat_site_annuaire">				
		Site(s) trouv(s) :
		<?php
		$fin = $page*$nb_results2show;
		if ($fin > $nb_sites_trouves)
			$fin = $nb_sites_trouves;
		echo ($debut+1)."  ".$fin;
		if ($page != 1)
			echo " (au total : ".$nb_sites_trouves." sites trouvs)\n";
		?>
		</span>
		<br><br>
		<?php
		while ($resultat = mysql_fetch_array($res_sites,MYSQL_ASSOC))
		{
			//on met en gras les mots cle
			for ($i = 0; $i < $nb_mots; $i++)
			{
				$resultat["titre"] = keyword_in_bold($mots_reels_recherches[$i], $resultat["titre"]);
				$resultat["description"] = keyword_in_bold($mots_reels_recherches[$i], $resultat["description"]);
			}
			affiche_site($resultat,"search");
		}
		echo "</table>\n";
		//affichage du lien vers les pages suivantes si il y a beaucoup de resultats
		if ($nb_sites_trouves > $nb_results2show)
		{
			?>
			<center>
			<span class="link_numpage_annuaire">
			<?php
			for ($i=1;$i<$nb_pages;$i++)
			{
				if ($i != $page)
					echo "<a href=\"search.php?mots=".rawurlencode(htmlspecialchars($mots))."&page=".$i."&nb_results2show=".$nb_results2show."&booleen=".$booleen."&nb_sites_trouves=".$nb_sites_trouves."\">".$i."</a>\n";
				else
				{ echo "$i"; }
				echo " - ";
			}
			//on affiche le dernier numero de page (sans tiret apres)
			if ($i == $page)
				echo $i;
			else
			{ echo "<a href=\"search.php?mots=".rawurlencode(htmlspecialchars($mots))."&page=".$i."&nb_results2show=".$nb_results2show."&booleen=".$booleen."&nb_sites_trouves=".$nb_sites_trouves."\">".$i."</a>\n"; }
			?>
			</span>
			</center>
			<br><br>
			<?php
		}	
	}

	if (!($nb_cats_trouvees + $nb_sites_trouves)) //on a pas trouve de resultat
	{
		?>
		<center>
		<span class="no_res_search_annuaire">
		<?php
		echo "Aucun rsultat pour la recherche \"";
		if ($nb_mots > 1)
			$recherche = implode("+",$mots_reels_recherches);
		else
		{ $recherche = $mots; }
		echo stripslashes(htmlspecialchars($recherche))."\"\n";
		?>
		<br><br>
		Essayez peut tre une recherche plus gnral...
		</span>
		</center>
		<?php
	}
	//fin de la connexion
	mysql_close($lk);	
}//if ($nb_mots > 0)
else //pas de mot demande
{
	?>
	<center>
	<span class="no_res_search_annuaire">
	Il faut saisir au moins un mot UTILE pour faire une recherche !
	</span>
	</center>
	<?php
}

include ("bas.php"); //pied de la page

//fichier qui contient tout ce qui doit venir avant le code de l'annuaire (menu de droite....)
include("after.php");

?>
</body>
</html>