<?php
//formulaire pour modifier les parametres de l'annuaire
include("../data_bd_annuaire.php"); //variables de l'annuaire
include("../functions.php"); //fonctions de l'annuaire
include("secure.php"); //verification de la session + connexion a la BD

// si on a pas quitte dans secure.php, on peut continuer...

$submit = isset($_POST['submit']) ? $_POST['submit'] : '';

if ($submit)
//le formulaire a ete envoye il faut mettre a jour la BD
{
	// recuperation des donnees
	$titre_site = isset($_POST['titre_site']) ? $_POST['titre_site'] : '';
	$url_site = isset($_POST['url_site']) ? $_POST['url_site'] : '';
	$url_rep = isset($_POST['url_rep']) ? $_POST['url_rep'] : '';
	$nom_master = isset($_POST['nom_master']) ? $_POST['nom_master'] : '';
	$email_master = isset($_POST['email_master']) ? $_POST['email_master'] : '';
	$nb_sites_in_topclics = isset($_POST['nb_sites_in_topclics']) ? (int)$_POST['nb_sites_in_topclics'] : 0;
	$nb_sites_in_topvotes = isset($_POST['nb_sites_in_topvotes']) ? (int)$_POST['nb_sites_in_topvotes'] : 0;
	$nb_days2benew = isset($_POST['nb_days2benew']) ? (int)$_POST['nb_days2benew'] : 0;
	$nb_scats_on_index = isset($_POST['nb_scats_on_index']) ? (int)$_POST['nb_scats_on_index'] : 0;
	$max_presence = isset($_POST['max_presence']) ? (int)$_POST['max_presence'] : 0;
	$nb_sites_on_page = isset($_POST['nb_sites_on_page']) ? (int)$_POST['nb_sites_on_page'] : 0;
	$func_mail = isset($_POST['func_mail']) ? (int)$_POST['func_mail'] : 0;
	$use_newsletter = isset($_POST['$use_newsletter']) ? (int)$_POST['$use_newsletter'] : 0;
	$auto_validate = isset($_POST['auto_validate']) ? (int)$_POST['auto_validate'] : 0;
	
	//verification des donnes
	est_vide($titre_site,"Veuillez entrer le titre de nom de votre site !");
	url_valide($url_site);
	url_valide($url_rep);
	email_valide($email_master);
	est_vide($nom_master,"Veuillez entrer le nom du webmaster !");
	
	//transformation des donnees a transformer
	if (!get_magic_quotes_gpc())
	//on rajoute des slash pour les magic_quote en OFF
	{
		$nom_master = addslashes($nom_master);
		$titre_site = addslashes($titre_site);
	}

	$nb_sites_in_topclics = place_dans_intervalle($nb_sites_in_topclics,1,255,"int");
	$nb_sites_in_topvotes = place_dans_intervalle($nb_sites_in_topvotes,1,255,"int");
	$nb_days2benew = place_dans_intervalle($nb_days2benew,1,255,"int");		
	$nb_scats_on_index = place_dans_intervalle($nb_scats_on_index,0,255,"int"); //0 car on peut tres bien n'afficher que les categories principales....
	$max_presence = place_dans_intervalle($max_presence,1,255,"int");
	$nb_sites_on_page = place_dans_intervalle($nb_sites_on_page,1,255,"int");
	
	//creation de la requete
	$sql = "UPDATE $T_infos SET nb_sites_in_topclics = '$nb_sites_in_topclics', nb_sites_in_topvotes = '$nb_sites_in_topvotes', nb_days2benew = '$nb_days2benew', nb_scats_on_index ='$nb_scats_on_index', max_presence = '$max_presence', nb_sites_on_page = '$nb_sites_on_page', auto_validate = '$auto_validate', func_mail = '$func_mail', titre_site = '$titre_site', url_site = '$url_site', url_rep = '$url_rep', nom_master = '$nom_master', email_master = '$email_master', use_newsletter = '$use_newsletter' ";
	//connexion a la BD
	//on est deja connecte
	//envoi de la requete
	send_sql($sql,"mettre  jour les paramtres de l'annuaire");
	//fin de la connexion
	
	//retour a l'administration
	header("Location: ".addsess2url("admin.php",$session_id));
	exit;
}

?>
<html>
<head>
<title>Modification des paramtres de l'annuaire</title>
</head>
<body bgcolor="#ffffcc">
<a href="<?php echo addsess2url("admin.php",$session_id); ?>">Retour  l'accueil de l'administration</a>
<br>
<center><h2>Paramtres de l'annuaire</h2></center>
<br><br>
<?php
//formulaire contenant toutes les infos modifiables

$sql = "SELECT * FROM $T_infos ";
//connexion a la BD
//on est deja connecte
//envoi de la requete
$res = send_sql($sql,"trouver les paramtres de l'annuaire");
//fin de la connexion

//affichage des infos
$resultat = mysql_fetch_array($res,MYSQL_ASSOC);

?>
<form action="<?php echo addsess2url("param_annuaire.php",$session_id); ?>" method="post">
<font size="+1">Infos sur l'administration :</font>
<br><br>
Nombre de sites dans le Top clics :
<input type="text" name="nb_sites_in_topclics" size=5 value=<?php echo $resultat["nb_sites_in_topclics"]; ?>>
<br><br>
Nombre de sites dans le Top votes :
<input type="text" name="nb_sites_in_topvotes" size=5 value=<?php echo $resultat["nb_sites_in_topvotes"]; ?>>
<br><br>
Un site sera considr comme nouveau pendant
<input type="text" name="nb_days2benew" size=4 value=<?php echo $resultat["nb_days2benew"]; ?>> jour(s).
<br><br>
Nombre de sous-catgories  afficher en page d'accueil sous les catgories principales :
<input type="text" name="nb_scats_on_index" size=4 value=<?php echo $resultat["nb_scats_on_index"]; ?>>
<br><br>
Un site pourra se trouver au maximum dans
<input type="text" name="max_presence" size=4 value=<?php echo $resultat["max_presence"]; ?>> catgorie(s).
<br><br>
Nombre de sites affichs par page dans les catgories :
<input type="text" name="nb_sites_on_page" size=5 value=<?php echo $resultat["nb_sites_on_page"]; ?>>
<br><br>
Les sites sont automatiquement valids : 
oui <input type="radio" name="auto_validate" value=1<?php if($resultat["auto_validate"] == 1) echo " checked"; ?>> &nbsp;&nbsp;|&nbsp;&nbsp; non <input type="radio" name="auto_validate" value=0<?php if($resultat["auto_validate"] != 1) echo " checked"; ?>>
<br><br>
Pouvez-vous utilisez la fonction mail() de PHP ?
oui <input type="radio" name="func_mail" value=1<?php if($resultat["func_mail"] == 1) echo " checked"; ?>> &nbsp;&nbsp;|&nbsp;&nbsp; non <input type="radio" name="func_mail" value=0<?php if($resultat["func_mail"] != 1) echo " checked"; ?>>
<br><br><br>
<font size="+1">Infos sur le site :</font>
<br><br>
Titre de votre site :
<input type="text" name="titre_site" size=30 maxlength=60 value="<?php echo htmlspecialchars($resultat["titre_site"]); ?>">
<br><br>
URL de votre site :
<input type="text" name="url_site" size=40 maxlength=120 value="<?php echo $resultat["url_site"]; ?>">
<br><br>
URL du rpertoire dans lequel est install MyPHPAnnuaire : 
<input type="text" name="url_rep" size=40 maxlength=150 value="<?php echo $resultat["url_rep"]; ?>">
<br><br>
Nom du webmaster :
<input type="text" name="nom_master" size=30 maxlength=50 value="<?php echo htmlspecialchars($resultat["nom_master"]); ?>">
<br><br>
Email du webmaster :
<input type="text" name="email_master" size=35 maxlength=75 value="<?php echo $resultat["email_master"]; ?>">
<br><br>
Votre site dispose-t-il d'une Newsletter ?
oui <input type="radio" name="use_newsletter" value=1<?php if($resultat["use_newsletter"] == 1) echo " checked"; ?>> &nbsp&nbsp;|&nbsp;&nbsp; non <input type="radio" name="use_newsletter" value=0<?php if($resultat["use_newsletter"] != 1) echo " checked"; ?>>
<br><br>
<center>
<input type="submit" value="Modifier les paramtres" onclick="this.value='Modification en cours...';" name="submit">
</center>
</form>
</body>
</html>