<?php
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 * Le dévéloppement à été commencé par Gari (plnStatistiques)
 * et a été repris par Jormun (SimpleStat).
 **/
if (!defined('PLX_ROOT')) exit;

##############################################################################################
# Fork de plnStatistiques 0.5 au 28/07/2015
#
# Ce plugin permet de gérer/afficher les statistiques de visites du site en back office.
#
# Les visites sont stockées dans un fichier log par jour.
# Les fichiers logs sont conservés dans un répertoire simplestat du dossier data/configuration/plugins
#
# Un fichier de statistique consolidé est créé par année. Une fois une année completement
# calculée, il est possible de supprimer les fichiers quotidiens correspondants
# il ne seront plus utilisés sauf en cas de recalcul forcé
#
# Les fichiers log sont de type CSV et contiennent les informations suivantes :
# Première ligne : le numéro de version du plugin à l'origine de la génération du fichier
#                  (permet de gérer les futures montées de version du plugin)
# Seconde ligne : nom des colonnes
# Lignes suivantes : chaque ligne contient 1 entrée de la forme :
#                    <DATE>;<HOUR>;<IP>;<QUERY_STRING>;<HTTP_USER_AGENT>;<HTTP_REFERER>
# 
##############################################################################################	

include(dirname(__FILE__).'/lib/class.plx.simplestat.php');

class plxSimpleStat extends plxPlugin 
{
    // Class constants - not modified anywhere. Change value directly here only if you know what you do  
    public $MaxTopUrl = 30; // Nb lines kept in url table in filtered view
    public $OnlineTime = 900; // nb second max since last page display to be considered "online"
    public $Fileprefix = 'logv1_';
    public $SPAMDelay = 3; // Nb of second under comment is considered as done by bot. Synchronized with ModerationList if installed
    
    // Class variables - modified in pluxml plugin setting interface
    public $RegexRobot="bot|fetcher|netvibes|rss|yahoo|spider|grub|slurp|openfind|nutch|crawl|search|scooter|fluffy|archiver|google|msn|aol|ask|fast|yandex|picsearch|rambler|accoona|seek|synapse|feed|flipboard";
    public $RegexSpamRef="";
	public $SpamRef="";
    public $BlacklistIP = array();
    public $DroitAcces=PROFIL_ADMIN;
    public $autoBlacklistLevel=0;
    
    // Class variables - Filled by constructor
    public $TimeStamp;  # "AAAA-MM-JJ HH:MM:SS"
	public $StartTime;
    public $Date;
    public $Hour;
    public $pathname;
    public $FileprefixLength;

	/**
	 * Constructeur de la classe
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 * @author	Stephane F
	 **/
	public function __construct($default_lang) {

		# Appel du constructeur de la classe plxPlugin (obligatoire)
		parent::__construct($default_lang);

		# droits pour accéder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);
		
		# Personnalisation du menu admin
		$this->setAdminMenu($this->getlang('L_SS_ADMIN_TITLE_ADMIN'),'',$this->getlang('L_SS_ADMIN_INFOBULLE'));		

		# Initialisation SimpleStat
		$this->init_SimpleStat();	

	} //public function __construct

	/**
	 * Méthode appelée à l'activation du plugin pour créer le répertoire simplestat
	 *
	 * @author	Stephane F
	 **/
	public function onActivate() {
		# Vérification de l'existence du dossier /plugins/simplestat
		if(!is_dir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat')) {
			@mkdir(PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat',0755,true);

			# Protection du répertoire simplestat
			plxUtils::write('', PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat/index.html');
			if (!file_exists(PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat/.htaccess')){
				file_put_contents(PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat/.htaccess',"<Files *>
	Order allow,deny
	Deny from all
</Files>      
      ");
    }			
		}
	}	
	
	public function init_SimpleStat() {
		
		$this->simplestat = new simplestat();
		
		$this->pathname = PLX_ROOT.PLX_CONFIG_PATH.'plugins/simplestat/'; # emplacement des fichiers statistiques
		$this->FileprefixLength = strlen($this->Fileprefix);
		$this->SpamRef = $this->getParam('SpamRef');
		
		// Today date. To be defined only once to avoid bug at around midnight
		$this->TimeStamp = date('Y-m-d H:i:s');
		list($this->Date,$this->Hour) = explode(" ",$this->TimeStamp);
		$this->StartTime = mktime( substr($this->Hour,0,2), substr($this->Hour,3,2), substr($this->Hour,6,2), substr($this->Date,5,2), substr($this->Date,8,2), substr($this->Date,0,4));

		$filename = $this->pathname . $this->Fileprefix . $this->Date . '.csv';
		$value = $this->getParam("autoBlacklistLevel");
		if (!empty($value)) $this->autoBlacklistLevel=$value;

		// When a visitor come, just log it
		if(!defined('PLX_ADMIN') OR !file_exists($filename)) {
			if (!empty($this->autoBlacklistLevel) && isset($_SESSION["profil"]) && $_SESSION["profil"] < $this->autoBlacklistLevel){	
				$value = $this->getParam("BlacklistIP");
				if (!empty($value)) $this->BlacklistIP=explode("\n",str_replace(array("\r\n","\r"),"\n",$value));
				if (!in_array(plxUtils::getIp() , $this->BlacklistIP)){
					include_once(PLX_CORE.'lib/class.plx.msg.php');
					$this->BlacklistIP[] = plxUtils::getIp();
					$this->setParam('BlacklistIP', implode("\n",$this->BlacklistIP),  'cdata');
					$this->saveParams();
				}
			return;
			}

		// log visitor only if file is writable
		if (is_dir($this->pathname)) {
		$handle = fopen($filename,'a');
		if ($handle!==false){
			fputcsv($handle,
                array(  $this->Date,
                           $this->Hour,
                           plxUtils::getIp(),
                           htmlspecialchars((isset($_SERVER['QUERY_STRING'])) ? $_SERVER['QUERY_STRING'] : '',ENT_IGNORE) . ((!empty($_POST["name"]) && !empty($_POST["content"]) && !empty($_POST["site"]))?'#com':''),
                           htmlspecialchars((isset($_SERVER['HTTP_USER_AGENT'])) ? $_SERVER['HTTP_USER_AGENT'] : '',ENT_IGNORE),
                           htmlspecialchars((isset($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : '',ENT_IGNORE)
                        ),
                ';','"');
			fclose($handle);
		} //if ($handle!==false)
        }
		} else { 
			// Update class variables used in admin section
			$this->FileprefixLength = strlen($this->Fileprefix);
      
			$value = $this->getParam("RegexRobot");
			if (!empty($value)) $this->RegexRobot=$value;
      
			$value = $this->getParam("RegexSpamRef");
			if (!empty($value)) $this->RegexSpamRef=$value;
      
			$value = $this->getParam("BlacklistIP");
			if (!empty($value)) $this->BlacklistIP=explode("\n",str_replace(array("\r\n","\r"),"\n",$value));
			// Cleanup blacklist IP array
			foreach($this->BlacklistIP as $k=>$v) if (empty($v)) unset($this->BlacklistIP[$k]);

			$value = $this->getParam("DroitAcces");
			if (!empty($value)) $this->DroitAcces=$value;
    
			// Access right definition
			switch($this->DroitAcces) {
				case 0 : $this->setAdminProfil(0);break; 
				case 1 : $this->setAdminProfil(0,1);break; 
				case 2 : $this->setAdminProfil(0,1,2);break; 
				case 3 : $this->setAdminProfil(0,1,2,3);break; 
				case 4 : $this->setAdminProfil(0,1,2,3,4);break; 
			}		

		}

	}
}
