<?php if (!defined('PLX_ROOT')) exit; 
/**
 * Plugin for Pluxml
 * @author	DPFPIC
 * Site : http://monblog.dpfpic.com/
 * Licence GNU_GPL
 * Le dévéloppement à été commencé par Gari (plnStatistiques)
 * et a été repris par Jormun (SimpleStat).
 **/
//error_reporting(E_ALL); //for debugging
// TODO : config : Ajouter les "core/admin" du mois et du mois précédent aux ignore IP 
// Calculate stat for a whole year

// fix action bar (pluxml 5.4)
ob_end_clean();
ob_start();

// send json stat file
if(isset($_POST['getdata'])){
  $file = (int) $_POST['getdata'];
  $period = (int) $_POST['period'];
  $year = substr( (string) $period , 0,4);
  echo "{type:$file,period:$period,data:";
  if ($file==1 || $file==7 || $file==8){
    if (!file_exists($plxPlugin->pathname . $year . "-daystat.json") || !readfile($plxPlugin->pathname . $year . "-daystat.json")) echo "{}";
  }elseif ($file==2){
    if (!file_exists($plxPlugin->pathname . $year . "-hourstat.json") || !readfile($plxPlugin->pathname . $year . "-hourstat.json")) echo "{}";
  }elseif ($file==3){
    if (!file_exists($plxPlugin->pathname . $year . "-navstat.json") || !readfile($plxPlugin->pathname . $year . "-navstat.json")) echo "{}";
  }elseif ($file==4){
    if (!file_exists($plxPlugin->pathname . $year . "-urlstat.json") || !readfile($plxPlugin->pathname . $year . "-urlstat.json")) echo "{}";
  }elseif ($file==5){ //online table
    $online = array("human"=>0,"bot"=>0,"where"=>array());
    list($online["date"],$online["time"]) = explode(" ",date('Y-m-d H:i:s',time()-$plxPlugin->OnlineTime));
    $online["timestamp"]=mktime( substr($plxPlugin->Hour,0,2), substr($plxPlugin->Hour,3,2), substr($plxPlugin->Hour,6,2), substr($plxPlugin->Date,5,2), substr($plxPlugin->Date,8,2), substr($plxPlugin->Date,0,4));
    $files = array();
    if ($online["date"]!=$plxPlugin->Date){
      $files[] = $plxPlugin->Fileprefix.$online["date"].'.csv';
      if (substr($online["date"],0,4)!=substr($plxPlugin->Date,0,4)){ // different year
        list( , , , , , $online) = $plxPlugin->simplestat->scan_files($files,substr($online["date"],0,4),array(),array(),array(),array(),array(),$online,false);
        $files = array();
      }
    } 
    $files[] = $plxPlugin->Fileprefix.$plxPlugin->Date.'.csv';
    list( , , , , , $online) = $plxPlugin->simplestat->scan_files($files,substr($plxPlugin->Date,0,4),array(),array(),array(),array(),array(),$online,false);
    echo json_encode($online);
  }elseif ($file==6){ //referer
    if (!file_exists($plxPlugin->pathname . $year . "-refstat.json") || !readfile($plxPlugin->pathname . $year . "-refstat.json")) echo "{}";
  }else echo "{}";
  echo "}";
  exit;
} // if(isset($_POST['getdata']))

// Check token validity
//plxToken::validateFormToken($_POST);

// Get token html fragment
$Token =  plxToken::getTokenPostMethod();

$calculate=false;
$yearlist = array();

// Check if there is POST data
if(isset($_POST['calculate'])){
// Start the calculation of stats
  $calculate=true;
// Get list of years to process
  $files = array_diff(scandir($plxPlugin->pathname), array('..', '.'));
  $yearlist = $plxPlugin->simplestat->Calculate($files);
// Check each year to process. If stat for 31/12 is completely processed, assume that there is no need to reprocess
// Except in case of forced calculation
  if(isset($_POST['forceall'])){
	$plxPlugin->simplestat->Calculate_All($yearlist);
  } //if(!isset($_POST['forceall']))  (1st loop)
} //if(isset($_POST['calculate']))

// Add current year to list of years to process
$yearlist[substr($plxPlugin->Date,0,4)] = 1;

ksort($yearlist); // Sort list of years to have current in last

// Initialize Online var. User is online if logged since 15 min
//$online = array("human"=>0,"bot"=>0,"where"=>array());
$online = $plxPlugin->simplestat->Online();
#list($online["date"],$online["time"]) = explode(" ",date('Y-m-d H:i:s',time()-$plxPlugin->OnlineTime));
#$online["timestamp"]=mktime( substr($plxPlugin->Hour,0,2), substr($plxPlugin->Hour,3,2), substr($plxPlugin->Hour,6,2), substr($plxPlugin->Date,5,2), substr($plxPlugin->Date,8,2), substr($plxPlugin->Date,0,4));

// Process 1 by 1 each year of the year list
foreach($yearlist as $year=>$v){

  // Read existing calculated stats
  // Except in case of forced calculation
  if(isset($_POST['forceall'])){
    // Basic stat calculated each time for current day (visitors, views, bots)
    $filename = $plxPlugin->pathname . $year . "-daystat.json";
    $file_content = file_exists($filename) ? file_get_contents($filename) : '[]';
    $daystat = ($file_content) ? json_decode($file_content,true) : array() ;

    // Advanced stats only calculated when user push "calculate stat" button
    if ($calculate){
      // View per hour
      $filename = $plxPlugin->pathname . $year . "-hourstat.json";
      $file_content = file_exists($filename) ? file_get_contents($filename) : '[]';
      $hourstat = ($file_content) ? json_decode($file_content,true) : array() ;
      // View per url
      $filename = $plxPlugin->pathname . $year . "-urlstat.json";
      $file_content = file_exists($filename) ? file_get_contents($filename) : '[]';
      $urlstat = ($file_content) ? json_decode($file_content,true) : array() ;
      // View per browser family
      $filename = $plxPlugin->pathname . $year . "-navstat.json";
      $file_content = file_exists($filename) ? file_get_contents($filename) : '[]';
      $navstat = ($file_content) ? json_decode($file_content,true) : array() ;
      // View per referer
      $filename = $plxPlugin->pathname . $year . "-refstat.json";
      $file_content = file_exists($filename) ? file_get_contents($filename) : '[]';
      $refstat = ($file_content) ? json_decode($file_content,true) : array() ;
    } //if ($calculate)
  } //if(!isset($_POST['forceall'])) (2nd loop)
  
  // for basic process (no recalculation), open only current day log file
  if (!$calculate) $files = array($plxPlugin->Fileprefix.$plxPlugin->Date.'.csv');
  
  // initialize stats array if not already done
  if (!isset($daystat)) $daystat = array();
  if (!isset($hourstat)) $hourstat = array();
  if (!isset($navstat)) $navstat = array();
  if (!isset($urlstat)) $urlstat = array();
  if (!isset($refstat)) $refstat = array();

  // Scan each files of the year to get stat
  list($daystat, $hourstat, $navstat, $urlstat, $refstat)=$plxPlugin->simplestat->scan_files($files, $year, $daystat, $hourstat, $navstat, $urlstat, $refstat, $online, $calculate);

  // For past year stats, if no data on 31/12, create the line to close the year and not reprocess it next time
  if ($year != substr($plxPlugin->Date,0,4) && !isset($daystat[$year."-12-31"]))
    $daystat[$year."-12-31"] = array( "vue"=>0,"vis"=>0,"bvue"=>0,"bvis"=>0,"ok"=>true );

// Save JSON files
  plxUtils::write(json_encode($daystat),$plxPlugin->pathname . $year . "-daystat.json");
  if ($calculate){
    plxUtils::write(json_encode($hourstat),$plxPlugin->pathname . $year . "-hourstat.json");
    plxUtils::write(json_encode($urlstat),$plxPlugin->pathname . $year . "-urlstat.json");
    plxUtils::write(json_encode($navstat),$plxPlugin->pathname . $year . "-navstat.json");
    plxUtils::write(json_encode($refstat),$plxPlugin->pathname . $year . "-refstat.json");
  } // if ($calculate)
} //foreach($yearlist as $year=>$v) (2nd loop)

// If no data, set today data at 0
if (empty($daystat[$plxPlugin->Date]))
  $daystat[$plxPlugin->Date] = array( "vue"=>0,"vis"=>0,"bvue"=>0,"bvis"=>0 );

// Get label of day, months from pluxml core lang file
$month_list=array();
$month_list[] = defined("L_JANUARY")? ucfirst(L_JANUARY) : "January";
$month_list[] = defined("L_FEBRUARY")? ucfirst(L_FEBRUARY) : "February";
$month_list[] = defined("L_MARCH")? ucfirst(L_MARCH) : "March";
$month_list[] = defined("L_APRIL")? ucfirst(L_APRIL) : "April";
$month_list[] = defined("L_MAY")? ucfirst(L_MAY) : "May";
$month_list[] = defined("L_JUNE")? ucfirst(L_JUNE) : "June";
$month_list[] = defined("L_JULY")? ucfirst(L_JULY) : "July";
$month_list[] = defined("L_AUGUST")? ucfirst(L_AUGUST) : "August";
$month_list[] = defined("L_SEPTEMBER")? ucfirst(L_SEPTEMBER) : "September";
$month_list[] = defined("L_OCTOBER")? ucfirst(L_OCTOBER) : "October";
$month_list[] = defined("L_NOVEMBER")? ucfirst(L_NOVEMBER) : "November";
$month_list[] = defined("L_DECEMBER")? ucfirst(L_DECEMBER) : "December";

$month_list_short=array();
$month_list_short[] = defined("L_SHORT_JANUARY")? ucfirst(L_SHORT_JANUARY) : "Jan";
$month_list_short[] = defined("L_SHORT_FEBRUARY")? ucfirst(L_SHORT_FEBRUARY) : "Feb";
$month_list_short[] = defined("L_SHORT_MARCH")? ucfirst(L_SHORT_MARCH) : "Mar";
$month_list_short[] = defined("L_SHORT_APRIL")? ucfirst(L_SHORT_APRIL) : "Apr";
$month_list_short[] = defined("L_SHORT_MAY")? ucfirst(L_SHORT_MAY) : "May";
$month_list_short[] = defined("L_SHORT_JUNE")? ucfirst(L_SHORT_JUNE) : "Jun";
$month_list_short[] = defined("L_SHORT_JULY")? ucfirst(L_SHORT_JULY) : "Jul";
$month_list_short[] = defined("L_SHORT_AUGUST")? ucfirst(L_SHORT_AUGUST) : "Aug";
$month_list_short[] = defined("L_SHORT_SEPTEMBER")? ucfirst(L_SHORT_SEPTEMBER) : "Sep";
$month_list_short[] = defined("L_SHORT_OCTOBER")? ucfirst(L_SHORT_OCTOBER) : "Oct";
$month_list_short[] = defined("L_SHORT_NOVEMBER")? ucfirst(L_SHORT_NOVEMBER) : "Nov";
$month_list_short[] = defined("L_SHORT_DECEMBER")? ucfirst(L_SHORT_DECEMBER) : "Dec";

$day_list=array();
$day_list[] = defined("L_SUNDAY")? ucfirst(L_SUNDAY) : "Sunday";
$day_list[] = defined("L_MONDAY")? ucfirst(L_MONDAY) : "Monday";
$day_list[] = defined("L_TUESDAY")? ucfirst(L_TUESDAY) : "Tuesday";
$day_list[] = defined("L_WEDNESDAY")? ucfirst(L_WEDNESDAY) : "Wednesday";
$day_list[] = defined("L_THURSDAY")? ucfirst(L_THURSDAY) : "Thursday";
$day_list[] = defined("L_FRIDAY")? ucfirst(L_FRIDAY) : "Friday";
$day_list[] = defined("L_SATURDAY")? ucfirst(L_SATURDAY) : "Saturday";
unset($core_lang);
?>
<div id="groups" class="inline-form action-bar">
<h2><?php echo $plxPlugin->getlang('L_SS_TITLE'); ?></h2>
<p id="actualiser" class="timer">&nbsp;</p>
<form action="plugin.php?p=plxSimpleStat" method="post" name="form_simplestat" id="form_simplestat">
<select id="dashselector" onchange="add_dash(this[this.selectedIndex].value)">
<option value=""><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_SELECT') ?></option>
<option value="1.2"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1') ?></option>
<option value="7"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_7') ?></option>
<option value="8"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_8') ?></option>
<option value="2"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_2') ?></option>
<option value="3"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_3') ?></option>
<option value="4"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_4') ?></option>
<option value="6"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_6') ?></option>
<option value="5"><?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5') ?></option>
</select>
<input name="calculate" value="1" type="hidden">
<?php echo $Token."\n"; ?>
<input name="submit" value="<?php echo $plxPlugin->lang('L_SS_ADMIN_UPDATE_STAT') ?>" type="submit">
<input name="forceall" value="<?php echo $plxPlugin->lang('L_SS_ADMIN_UPDATE_STAT_FORCE') ?>" type="submit">
<?php echo plxToken::getTokenPostMethod() ?>
</form>
</div>
<!--[if lte IE 9]><style type="text/css">.dash-foot span{display:inline-block;padding-top:6px;}</style><![endif]-->
<div id="<?php echo $plxPlugin->getlang('L_SS_TITLE'); ?>">
<table id="dashsum" cellpadding=0 cellspacing=0>
<thead>
<tr><th class="thstat"><img src="<?php echo PLX_PLUGINS ?>plxSimpleStat/img/stat.png" style="vertical-align: middle">&nbsp;&nbsp;<?php echo $plxPlugin->lang('L_SS_ADMIN_TODAY_TITLE') ?></th>
<th class="thhuman"><img src="<?php echo PLX_PLUGINS ?>plxSimpleStat/img/human.png" style="vertical-align: middle">&nbsp;&nbsp;<?php echo $plxPlugin->lang('L_SS_ADMIN_HUMANS') ?></th>
<th class="thbot"><img src="<?php echo PLX_PLUGINS ?>plxSimpleStat/img/bot.png" style="vertical-align: middle">&nbsp;&nbsp;<?php echo $plxPlugin->lang('L_SS_ADMIN_ROBOTS') ?></th></tr>
</thead>
<tbody>
<tr><td><?php echo $plxPlugin->lang('L_SS_ADMIN_NB_UNIQUE_VISITS') ?></td><td><?php echo $daystat[$plxPlugin->Date]["vis"]; ?></td><td><?php echo $daystat[$plxPlugin->Date]["bvis"]; ?></td></tr>
<tr><td><?php echo $plxPlugin->lang('L_SS_ADMIN_NB_VIEWS') ?></td><td><?php echo $daystat[$plxPlugin->Date]["vue"]; ?></td><td><?php echo $daystat[$plxPlugin->Date]["bvue"]; ?></td></tr>
<tr><td><?php echo $plxPlugin->lang('L_SS_ADMIN_VIEWS_PER_VISIT') ?></td><td><?php echo ($daystat[$plxPlugin->Date]["vis"]==0)?'':number_format($daystat[$plxPlugin->Date]["vue"]/$daystat[$plxPlugin->Date]["vis"],2); ?></td><td><?php echo ($daystat[$plxPlugin->Date]["bvis"]==0)?'':number_format($daystat[$plxPlugin->Date]["bvue"]/$daystat[$plxPlugin->Date]["bvis"],2) ?></td></tr>
<tr><td><?php echo $plxPlugin->lang('L_SS_ADMIN_ONLINE_VISITS') ?></td><td><?php echo $online["human"]; ?></td><td><?php echo $online["bot"]; ?></td></tr>
</tbody></table>
</div>
<?php if ($plxPlugin->getParam('ActAuto') == 1) { ?>
<script language="javascript" type="text/javascript">
var counter = <?php echo $plxPlugin->getParam('ActAutoTime'); ?>;
var intervalId = null;
function actualiser() {
  document.getElementById("actualiser").innerHTML = "<?php echo $plxPlugin->lang('L_SS_ADMIN_ACTAUTO') ?>" + counter + " <?php echo $plxPlugin->lang('L_SS_ADMIN_SECOND') ?>";
  counter--;
}
function sendform () {
    document.querySelectorAll("input[type=submit]")[0].click();     
}
intervalId = setInterval(actualiser, 1000);
setTimeout(sendform,counter * 1000); //attend 5s avant d'appeler la fonction sendform
</script>
<?php } ?>
<link rel="stylesheet" href="<?php echo PLX_PLUGINS ?>plxSimpleStat/css/plxSimpleStat.css" type="text/css" media="screen" />
<script type="text/javascript" src="<?php echo PLX_PLUGINS ?>plxSimpleStat/js/standalone-framework.js"></script>
<script type="text/javascript" src="<?php echo PLX_PLUGINS ?>plxSimpleStat/js/highcharts.js"></script>
<script type="text/javascript" src="<?php echo PLX_PLUGINS ?>plxSimpleStat/js/tsorter.min.js"></script>
<script type="text/javascript" src="<?php echo PLX_PLUGINS ?>plxSimpleStat/js/no-data-to-display.js"></script>
<script language="javascript" type="text/javascript">
var langue = [
"<?php echo $plxPlugin->lang('L_SS_ADMIN_AJAX_LOAD_ERROR') ?>", //0
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_PREV_YEAR') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_NEXT_YEAR') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_PREV_MONTH') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_NEXT_MONTH') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_REFRESH') ?>", //5
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_TOP') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_SIZE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_BUTTON_DELETE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_SUBTITLE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_SUBTITLE_GSM') ?>", //10
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VIEW_SHORT') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VIEW_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VISIT_SHORT') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VISIT_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_BOT_SHORT') ?>", //15
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_BOT_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VIEW_VISIT_SHORT') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_VIEW_VISIT_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_2_SUBTITLE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_2_HOUR_TOOLTIP') ?>", //20
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_2_VIEW_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_3_SUBTITLE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_3_VIEW_LONG') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_4_URL') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_4_VIEW') ?>", //25
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_TYPE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_IP') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_URL') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_AGE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_HOME_NAME') ?>", //30
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_NODATA') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_BOT') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_5_HUMAN') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_NOONLINE') ?>",
"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_AVERAGE') ?>"
];
Highcharts.setOptions({lang:{
resetZoom:"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_ZOOM_RESET') ?>",
resetZoomTitle:"<?php echo $plxPlugin->lang('L_SS_ADMIN_WIDGET_1_ZOOM_RESET_T') ?>",
noData:langue[31],
months:[ "<?php echo implode('","',$month_list) ?>"],
shortMonths: [ "<?php echo implode('","',$month_list_short) ?>"],
weekdays:["<?php echo implode('","',$day_list) ?>"]
}});
var pluginID = "<?php echo $plxPlugin->getlang('L_SS_TITLE'); ?>";
var pluginDir="<?php echo PLX_PLUGINS.'plxSimpleStat/'; ?>";
var toggleTop = <?php echo $plxPlugin->MaxTopUrl ?>;
</script>
<script type="text/javascript" src="<?php echo PLX_PLUGINS ?>plxSimpleStat/js/admin.js"></script>
