<?php

/*
 * Wavatars come from :
 * http://www.shamusyoung.com/twentysidedtale/?p=1462
 * */

# Uncomment for using gravatar
const GRAVATAR_URL = 'https://www.gravatar.com/avatar/';
const WAVATAR_SIZE = 80;
const WAVATAR_CACHE = 'cache/';
const WAVATAR_BLANK = 'blank.png';
define('WAVATAR_CACHE_PATH', defined('PLX_ROOT') ? PLX_ROOT . $plxShow->plxMotor->aConf['medias'] . 'wavatars/' : __DIR__ . '/' . WAVATAR_CACHE);

if((!is_dir(WAVATAR_CACHE_PATH) and !@mkdir(WAVATAR_CACHE_PATH)) or !is_writable(WAVATAR_CACHE_PATH)) {
	die('No writing grants for "' . WAVATAR_CACHE_PATH . '" folder');
}

function wavatar_clamp ($v) {
	if($v < 0) { return 0; }
	if($v > 255) { return 255; }
    return $v;
}

function wavatar_hsl ($h, $s, $l) {

    if ($h>240 || $h<0 || $s>240 || $s<0 || $l>240 || $l<0)
        return array(0,0,0);
    if ($h<=40) {
        $R=255;
        $G=(int)($h/40*256);
        $B=0;
    } elseif ($h>40 && $h<=80) {
        $R=(1-($h-40)/40)*256;
        $G=255;
        $B=0;
    } elseif ($h>80 && $h<=120) {
        $R=0;
        $G=255;
        $B=($h-80)/40*256;
    } elseif ($h>120 && $h<=160) {
        $R=0;
        $G=(1-($h-120)/40)*256;
        $B=255;
    } elseif ($h>160 && $h<=200) {
        $R=($h-160)/40*256;
        $G=0;
        $B=255;
    } elseif ($h>200) {
        $R=255;
        $G=0;
        $B=(1-($h-200)/40)*256;
    }

    $R=$R+(240-$s)/240*(128-$R);
    $G=$G+(240-$s)/240*(128-$G);
    $B=$B+(240-$s)/240*(128-$B);

    if ($l<120) {
        $R=($R/120)*$l;
        $G=($G/120)*$l;
        $B=($B/120)*$l;
    } else {
        $R=$l*((256-$R)/120)+2*$R-256;
        $G=$l*((256-$G)/120)+2*$G-256;
        $B=$l*((256-$B)/120)+2*$B-256;
    }
    return array(
		(int)wavatar_clamp($R),
		(int)wavatar_clamp($G),
		(int)wavatar_clamp($B)
	);
}

function wavatar_paste_image($base, $part) {

    $file = __DIR__ . '/parts/' . $part . '.png';
    $im = @imagecreatefrompng($file);
    if($im) {
	    imagecopy($base, $im, 0, 0, 0, 0, WAVATAR_SIZE, WAVATAR_SIZE);
	    imagedestroy($im);
	}
}

const WAVATAR_BACKGROUNDS = 4;
const WAVATAR_FACES = 11;
const WAVATAR_BROWS = 8;
const WAVATAR_EYES = 13;
const WAVATAR_PUPILS = 11;
const WAVATAR_MOUTHS = 19;

function wavatar_build ($seed, $filename, $size=WAVATAR_SIZE) {
    //look at the seed (an md5 hash) and use pairs of digits to determine our
    //"random" parts and colors.
    $face = 1 + hexdec(substr ($seed,  1, 2)) % WAVATAR_FACES;
	$bg_color = hexdec(substr($seed, 3, 2)) % 240;
    $wav_color = hexdec(substr ($seed,  7, 2)) % 240;

    $indexes = array(
		'fade'		=> 1 + hexdec (substr ($seed,  5, 2)) % WAVATAR_BACKGROUNDS,
		'mask'		=> $face,
		'shine'		=> $face,
		'brow'		=> 1 + hexdec (substr ($seed,  9, 2)) % WAVATAR_BROWS,
		'eyes'		=> 1 + hexdec (substr ($seed, 11, 2)) % WAVATAR_EYES,
		'pupils'	=> 1 + hexdec (substr ($seed, 13, 2)) % WAVATAR_PUPILS,
		'mouth'		=> 1 + hexdec (substr ($seed, 15, 2)) % WAVATAR_MOUTHS,
    );
    // create backgound
    $avatar = imagecreatetruecolor (WAVATAR_SIZE, WAVATAR_SIZE);
    //Pick a random color for the background
    $c = wavatar_hsl ($bg_color, 240, 50);
    $bg = imagecolorallocate ($avatar, $c[0], $c[1], $c[2]);
    imagefill($avatar, 1, 1, $bg);
    $c = wavatar_hsl ($wav_color, 240, 170);
    $bg = imagecolorallocate ($avatar, $c[0], $c[1], $c[2]);
    //Now add the various layers onto the image
    foreach($indexes as $field=>$index) {
		wavatar_paste_image ($avatar, $field . $index);
		if($field == 'mask') {
    		$avSize = (int)(WAVATAR_SIZE / 2);
			imagefill($avatar, $avSize, $avSize, $bg);
		}
	}

    //resize if needed
    if ($size != WAVATAR_SIZE) {
        $out = imagecreatetruecolor($size,$size);
        imagecopyresampled ($out,$avatar, 0, 0, 0, 0, $size, $size, WAVATAR_SIZE, WAVATAR_SIZE);
        imagepng($out, $filename);
        imagedestroy($out);
    } else {
        imagepng($avatar, $filename);
    }
	imagedestroy($avatar);
}

function wavatar_build_blank () {
    if (file_exists (WAVATAR_BLANK)) {
		return;
	}

    $avatar = imagecreatetruecolor (1, 1);
    $bg = imagecolorallocate ($avatar, 255, 255, 255);
    imagefill($avatar, 0, 0, $bg);
    imagepng($avatar, WAVATAR_BLANK);
    imagedestroy($avatar);
}

function wavatar_get($email, $size=WAVATAR_SIZE, $rating='') {
    $md5 = md5(strtolower(trim($email)));
    # Anti-hacking
    if(empty($size) or !is_integer($size) or $size < 16 or $size > 256) {
		$size = WAVATAR_SIZE;
	}

    if(defined('PLX_ROOT')) {
		global $plxShow;
		ob_start();
		$plxShow->template();
		$base =  ob_get_clean() . '/wavatars/';
	} else {
		$base = '';
	}

    $url = '';
    # make sure the image functions are available before trying to make wavatars
    if(function_exists('imagecreatetruecolor')) {
	    $seed = substr ($md5, 0, 17);
        $filename = WAVATAR_CACHE_PATH . $seed . '.png';
        if(!file_exists($filename)) {
			wavatar_build($seed, $filename, $size);
		}
        $url = $base . WAVATAR_CACHE . $seed . '.png';
    }

    if(!defined('PLX_ROOT') and !defined('DEMO') and defined('GRAVATAR_URL')) {
		if(empty($base)) {
			$base = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/' . dirname($_SERVER['SCRIPT_NAME']) . '/';
		}
        $query = '?size=' . $size . '&d=' . urlencode($base . $url);
        if(!empty($rating) and in_array($rating, array('g', 'pg', 'r', 'x'))) {
			$query .= '&r=' . $rating;
		}
        return GRAVATAR_URL . $md5 . $query;
    }

    return $url;
}
