<?php
include 'lib.php';

const DEMO = true;
$email = filter_input(INPUT_GET, 'email', FILTER_VALIDATE_EMAIL);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge" />
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Check your wavatar</title>
</head><body>
	<h1>Samples</h1>
	<div class="samples">
<?php
const MATRICE = '0123456789abcdef';

function charAleatoire($taille='17') {
	$string = '';
	mt_srand((float)microtime()*1000000);
	for($i=0; $i<$taille; $i++) {
		$string .= MATRICE[mt_rand() % strlen(MATRICE)];
	}
	return $string;
}

for($i=50; $i>0; $i--) {
	$seed = charAleatoire();
	$filename = WAVATAR_CACHE . sprintf('sample%02d.png', $i);
	wavatar_build($seed, $filename);
?>
		<img src="<?= $filename ?>" title="<?= $seed ?>" width="<?= WAVATAR_SIZE ?>" height="<?= WAVATAR_SIZE ?>" />
<?php
}
?>
	</div>
	<h1>Your wavatar / gravatar</h1>
	</h1><div class="test">
		<div>
<?php
if(!empty($email)) {
?>
			<img id="wavatar" src="<?= wavatar_get($email) ?>" data-hash="<?= md5(strtolower(trim($email))) ?>" />
<?php
}
?>
		</div>
		<form>
			<label>
				<span>Your E-mail</span>
				<input type="email" name="email" value="<?= !empty($email) ? $email : '' ?>" required />
			</label>
			<button>Send</button>
		</form>
	</div>
	<h1>Registered wavatars</h1>
	<div class="cache">
<?php
$files = array_filter(
	glob(WAVATAR_CACHE . '*.png'),
	function($item) {
		return !preg_match('@sample\d+\.png$@', $item);
	}
);
if(!empty($files)) {
	foreach($files as $f) {
?>
		<img src="<?= $f ?>" title="<?= basename($f, '.png') ?>" width="<?= WAVATAR_SIZE ?>" height="<?= WAVATAR_SIZE ?>" />
<?php
	}
}
?>
	</div>
	<footer style="text-align: center;">
		<a href="http://www.shamusyoung.com/twentysidedtale/?p=1462" target="_blank">Wavatars</a>
		<a href="http://fr.gravatar.com/support/what-is-gravatar/" target="_blank">Gravatar</a>
	</footer>
	<script>
(function() {
	const el = document.getElementById('wavatar');
	const hash1 = el.dataset.hash;
	const img1 = new Image();
	img1.onload = function(event) {
		console.log('load', event);
		const img = new Image();
		img.src = img1.src;
		el.parentElement.appendChild(img);
	}
	img1.onloadend = function(event) {
		console.log('loadend', event);
	}
	img1.onerror = function(event) {
		console.log('error', event);
	}
	img1.src = 'https://www.gravatar.com/avatar/' + hash1 + '?s=80&d=404';
})();
	</script>
</body></html>
