(function() {
	'use strict';

	// Retour fluide vers haut de page
	const topBtn = document.querySelector('#nav-footer a[href="#top"]');
	if(topBtn != null) {
		topBtn.onclick = function(e) {
			const top = document.getElementById('top');
			if(top != null) {
				e.preventDefault();
				top.scrollIntoView({ behavior: 'smooth' });
			}
		}
	} else {
		console.error('The top button is missing.');
	}

	// hack against navigation()
	const navBtns = document.querySelectorAll('#pagination a');
	for(var i=0, iMax=navBtns.length; i<iMax; i++) {
		navBtns[i].classList.add('button');
	}

	// Ajouter un commentaire
	if('frm_comment' in document.forms) {
		const frmComment = document.forms.frm_comment;
		const answerComs = document.getElementById('answer-coms');
		if(answerComs != null) {
			const captions = [
				answerComs.dataset.cancel,
				answerComs.dataset.reply
			];
			answerComs.addEventListener('click', function(event) {
				if(typeof event.target.dataset.comid != 'undefined') {
					// event.preventDefault();
					const labels = event.target.control.labels;
					const comParent = frmComment.elements.parent;

					if(!event.target.control.checked) {
						comParent.value = event.target.dataset.comid;
						frmComment.elements.name.focus();
						// console.log('comm #', event.target.dataset.comid);
						// console.log('Author', event.target.dataset.author);
						const inReplyTo = document.getElementById('replyTo');
						if(inReplyTo != null) {
							inReplyTo.textContent = inReplyTo.textContent.replace(/##/, event.target.dataset.author);
						}

						var nextComs = false;
						for(var i=0, iMax=labels.length; i<iMax; i++) {
							if(labels[i] != event.target) {
								labels[i].disabled = true;
								if(nextComs && typeof labels[i].dataset.comid != 'undefined') {
									const div = document.getElementById('com-' + labels[i].dataset.comid);
									if(div != null) {
										div.classList.add('noactive');
									}

								}
							} else {
								nextComs = true;
								labels[i].classList.add('active');
							}

						event.target.textContent =  captions[0];
						}
					} else {
						comParent.form.reset();
						for(var i=0, iMax=labels.length; i<iMax; i++) {
							if(typeof labels[i].dataset.comid != 'undefined') {
								const div = document.getElementById('com-' + labels[i].dataset.comid);
								if(div != null) {
									div.classList.remove('noactive');
								}
							}
						}

						event.target.textContent =  captions[1];
					}
				}
			});

			// Vérifie si commentaire refusé
		}

		document.getElementById('id-comm-title').addEventListener('change', function(event) {
			console.log(event.target.id, event.target.checked);
		});
	}

	// --------- slideshow ------------

	const slideshow = document.getElementById('slideshow');
	if(slideshow != null) {
		const TAG = 'slideshow-thumb';
		var range = 0;
		var position = 0;
		var sliding = null;
		var leaving = null;

		var computed;
		const tempImg = new Image();
		// tempImg.onloadend ne fonctionne qu'avec Firefox
		tempImg.onload = function(event) {
			var w, h;
			const maxWidth = parseInt(computed.maxWidth);
			const maxHeight = parseInt(computed.maxHeight);
			const ratio = tempImg.width / tempImg.height;
			if(ratio > maxWidth / maxHeight) {
				// priorité à width
				w = (tempImg.width < maxWidth) ? tempImg.width : maxWidth;
				h = parseInt(w / ratio);
			} else {
				// priorité à height
				h = (tempImg.height < maxHeight) ? tempImg.height : maxHeight;
				w = parseInt(h * ratio);
			}
			// Si les dimensions des images sont identiques : pas de transition sur les dimensions !
			// console.log('Image size : ', w, 'x', h);
			slideshowImg.style.width = (slideshowImg.width != w) ? w + 'px' : '';
			slideshowImg.style.height = (slideshowImg.height != h) ? h + 'px' : '';
			slideshowImg.src = tempImg.src;
		}

		function displaySlide(id) {
			if(typeof id == 'number') { position = id; }

			if(position < 0) {
				position = range - 1;
			} else if(position >= range) {
				position = 0;
			}
			const thumbnail = document.getElementById(TAG + '-'  + position)
			thumbnail.click();
			thumbnail.scrollIntoView({behavior: 'smooth'});
		}

		const slideshowImg = document.getElementById('slideshow-img');
		const caption = document.getElementById('slideshow-caption');
		const counter = document.getElementById('slideshow-counter');

		function slideshowImgShow(src) {
			computed = getComputedStyle(slideshowImg);
			slideshowImg.style.width = computed.width;
			slideshowImg.style.height = computed.height;
			tempImg.src = src.replace(/\.tb\.(jpe?g|png|gif|webp)$/, ".$1");

			var timer1 = setTimeout(function() {
				clearTimeout(timer1);
			}, 20);
		}

		// gestion du click dans la galerie
		const gallery = document.getElementById('slideshow-gallery');
		if(gallery != null) {
			gallery.onclick = function(event) {
				if(event.target.id.startsWith(TAG)) {
					event.preventDefault();
					const previous = gallery.querySelector('img.active');
					if(previous != null) {
						previous.classList.remove('active');
					}
					caption.textContent = event.target.dataset.title;
					position = parseInt(event.target.id.replace(/.*-(\d+)$/, '$1'));
					counter.textContent = (position + 1) + ' / ' + range;
					event.target.classList.add('active');

					slideshowImgShow(event.target.src);
				}
			}

			const content = document.querySelector('.main-content');
			if(content != null) {
				content.addEventListener('click', function(event) {
					if(range >= 0 && event.target.tagName == 'IMG') {
						if(event.target.src.match(/\.tb\.(?:jpe?g|png|gif|webp)/)) {
							event.preventDefault();
							if(!('thumb' in event.target.dataset)) {
								// Construction de la galerie
								gallery.textContent = '';
								range = 0;
								const imgs = document.querySelectorAll('img[src*=".tb."]');
								for(var i=0, iMax=imgs.length; i<iMax; i++) {
									const el = imgs[i];
									const src = el.src;
									// Pas d'image en double dans la galerie
									const imgsList = [];
									if(/\.(?:jpe?g|png|gif|webp)/.test(src) && imgsList.indexOf(src) < 0) {
										const img = document.createElement('IMG');
										img.src = src;
										img.alt = el.alt;
										img.id = TAG + '-' + range;
										var title = el.title.trim();
										if(title.length == 0) {
											title = el.parentElement.title.trim();
											if(title.length == 0) {
												title = el.alt;
											}
										}
										img.setAttribute('data-title', title);
										gallery.appendChild(img);
										el.dataset['thumb'] = i;
										range++;
									}
								}
								if(range == 0) {
									// no picture found
									range = -1;
								}
							}

							if(range > 0) {
								if(range == 1) {
									slideshow.classList.remove('with-gallery');
								} else {
									slideshow.classList.add('with-gallery');
								}
								// We have pictures
								slideshowImg.style.width = event.target.width + 'px';
								slideshowImg.style.height = event.target.height + 'px';
								document.body.classList.add('slideshow');
								displaySlide(parseInt(event.target.dataset.thumb));
							}

							if('ontouchstart' in document.documentElement && !document.documentElement.fullscreenElement && navigator.userAgent.match(/(?:android|iphone|ipad|webos|mobi)/i)) {
								slideshow.requestFullscreen();
							}
						} else {
							if(event.target.src.match(/\.tb\.(?:jpe?g|png|gif|webp)/)) {
								// Pour article.php: zoom pour les vignettes de l'article
								event.preventDefault();
								alert('ok');
							}
						}
					}
				});
			}

			document.getElementById('slideshow-prev').onclick = function(event) {
				event.preventDefault();
				position--;
				displaySlide();
			}

			document.getElementById('slideshow-next').onclick = function(event) {
				event.preventDefault();
				position++;
				displaySlide();
			}
		}

		// Fin de la transition
		slideshowImg.ontransitionend = function(event) {
			if(event.propertyName == 'width' || event.propertyName == 'height') {
				slideshowImg.style.width = '';
				slideshowImg.style.height = '';
				if(leaving === true) {
					document.body.classList.remove('slideshow');
					slideshow.style.opacity = '';
					leaving = null;
				}
				return;
			}
		}

		const closeBtn = document.getElementById('slideshow-close');
		closeBtn.onclick = function(event) {
			event.preventDefault();
			slideshowImg.style.width = slideshowImg.width + 'px';
			slideshow.style.opacity = '1';
			var timer1 = setTimeout(function() {
				leaving = true;
				slideshowImg.style.width = parseInt(slideshowImg.width / 4) + 'px';
				slideshow.style.opacity = '0.05';
				clearTimeout(timer1);
			}, 20);
			if(sliding == null) {
				clearInterval(sliding);
				sliding = null;
			}
		}

		// The keyboard
		window.addEventListener('keydown', function(event) {
			if(
				!event.shiftKey &&
				!event.ctrlKey &&
				!event.altKey &&
				document.body.classList.contains('slideshow') &&
				(range > 1 || event.key.startsWith('Esc'))
			) {
				switch(event.key) {
					case ' ':
					case 'Enter':
					case 'Right':
					case 'ArrowRight':
					case 'n':
					case 'N':
						position++;
						displaySlide();
						break;
					case 'Backspace':
					case 'Left':
					case 'ArrowLeft':
					case 'b':
					case 'B':
						position--;
						displaySlide();
						break;
					case 'Esc':
					case 'Escape':
						closeBtn.click();
						break;
					case 'Home':
						position = 0;
						displaySlide();
						break;
					case 'End':
						position = range - 1;
						displaySlide();
						break;
					case 'p':
					case 'P':
						if(sliding == null) {
							// starting
							position++;
							displaySlide();

							// For next slide
							sliding = setInterval(function() {
								position++;
								displaySlide();
							}, slideshow.dataset.interval);
						} else {
							clearInterval(sliding);
							sliding = null;
						}
						break;
					default: return;
				}
				event.preventDefault();
			}
		});
	} else {
		// console.error('#slideshow element not found');
	}

	// --------------- gravatar ---------------------
	if(document.body.classList.contains('mode-article')) {
		const container = document.querySelector('.comments[data-gravatar][data-size]');
		if(container != null) {
			const avatars = container.querySelectorAll('img[data-hash]');
			const template = container.dataset.gravatar + '#HASH#?size=' + container.dataset.size + '&d=404';
			var cnt = avatars.length;

			function gravatar() {
				cnt--;
				return template.replace(/#HASH#/, avatars[cnt].dataset.hash);
			}

			if(cnt > 0) {
				const img = new Image();
				img.onload = function(event) {
					avatars[cnt].src = img.src;
				};
				img.onloaded = function(event) {
					if(cnt > 0) {
						img.src = gravatar();
					}
				}
				img.src = gravatar();
			}
		}
	}

	// ---------------- onePage --------------
	const menu = document.getElementById('menu');
	if(false && menu != null && 'onepage' in menu.dataset) {
		menu.addEventListener('click', function(event) {
			if(event.target.tagName == 'A' && event.target.parentElement.classList.contains(menu.dataset.onepage)) {
				const id = event.target.href.replace(/^.*#/, '');
				if(id != null) {
					event.preventDefault();
					const actives = event.currentTarget.querySelectorAll('li.active');
					for(var i=0, iMax=actives.length; i<iMax; i++) {
						actives[i].classList.remove('active');
					}
					document.getElementById(id).scrollIntoView({behavior: 'smooth'});
					event.target.parentElement.classList.add('active');
				}
			}
		});
	}

	function onePageResize() {
		const articles = document.querySelectorAll('.main-content.onepage > article[data-ratio]');
		for(var i=0, iMax=articles.length; i<iMax; i++) {
			articles[i].style.minHeight = Math.min(Math.round(articles[i].clientWidth / articles[i].dataset.ratio), window.innerHeight) + 'px';
		}
	}

	window.addEventListener("orientationchange", function(event) {
		// console.log(window.screen.orientation);
		onePageResize();
	}, false);

	onePageResize();

})();

/*
 * Gére les notes de pieds de pages. Pour insérer un renvoi vers une note de pied de page , insérer dans le texte:
 * <a data-footnote="contenu de la note en pied de page. <a href='https://www.pluxml.org'>PluXml</a>."></a>
 *
 * voir forum https://forum.pluxml.org/discussion/6960/plugin-notes-en-bas-de-page
 * */
(function() {
    'use strict';

    const article = document.querySelector('.article[id^="post-"]');
    if(article == null) {
        return;
    }

    const footnotes = article.querySelectorAll('a[data-footnote]');
    if(footnotes.length == 0) {
        return;
    }

    const el = document.createElement('UL');
    el.className = 'footnotes';
    Array.from(footnotes).forEach(function(item, x) {
        const i = x+1;
        const idSrc = `footnote-${i}`;
        const idTarget = `note-${i}`;
        item.innerHTML = `<sup>(${i})</sup>`;
        item.id = idSrc
        item.href = `#${idTarget}`;
        const note = document.createElement('LI');
        note.innerHTML = `<a href="#${idSrc}">${i}. </a>${item.dataset.footnote}`;
        note.id = idTarget;
        el.appendChild(note);
    });

    article.appendChild(el);
})();

/*
 * Crée un sommaire pour la page d'un article divisé en chapitres.
 * Chaque chapitre doit avoir au minimum la structure suivante :
 * <div class="chapter">
 *   <h2>Titre du chapitre</h2>
 *   <div>
 *     contenu du chapitre
 *    </div>
 * </div>
 *
 * Voir discussion : https://forum.pluxml.org/discussion/6973/long-articles-avec-une-option-de-pagination-chapitre-par-chapitre
 * */
(function(query1) {
  'use strict';

  const list = [...document.body.querySelectorAll(query1 + ' > h2')];
  if(list.length == 0) { return; }

  if(list.length > 1) {
    // On crée une barre de navigation s'il y a plus de 1 chapitre
    var innerHTML = '';
    list.forEach((item, i) => {
      const caption = item.textContent;
      innerHTML += `<button data-page="${i}">${caption}</button>`;
    });

    // On crée la barre de navigation
    const pagination_numbers_container = document.createElement('NAV');
    pagination_numbers_container.className = 'art-nav center';
    pagination_numbers_container.innerHTML = innerHTML;
    const page0 = list[0].parentElement;
    page0.parentElement.insertBefore(pagination_numbers_container, page0);

    // On gére le click sur la barre de navigation
    pagination_numbers_container.addEventListener('click', (evt) => {
      if(evt.target.hasAttribute('data-page')) {
        evt.preventDefault();
        // On affiche uniquement le chapitre demandé
        [...document.body.querySelectorAll(query1 + '.active')].forEach((item) => {
          item.classList.remove('active');
        });
        const i = parseInt(evt.target.dataset.page);
        list[i].parentElement.classList.add('active');
        // On met en évidence uniquement le bouton du chapitre affiché
        [...pagination_numbers_container.querySelectorAll('.active')].forEach((item) => {
          item.classList.remove('active');
        });
        event.target.classList.add('active');
      }
    });
  }

  // On allume sur le premier .new-page ( Fire up )
  list[0].parentElement.classList.add('active');
  const btn = document.body.querySelector('.art-nav button');
  if(btn != null) {
    btn.classList.add('active');
  }
})('.new-page');
