<?php
if(!defined('PLX_ROOT')) { exit; }

const AVATAR_SIZE = 50;

ob_start();
$plxShow->template();
define('AVATAR_DEFAULT', ob_get_clean() . '/img/wavatar.png');

$allowedArtComs = $plxShow->plxMotor->plxRecord_arts->f('allow_com') && $plxShow->plxMotor->plxRecord_arts->f('allow_com');

if(!empty($plxShow->plxMotor->plxRecord_coms)) {
	# On a des commentaires
	$wavatarsLib = __DIR__ . '/wavatars/lib.php';
	if(file_exists($wavatarsLib)) {
		include $wavatarsLib;
		if(defined('GRAVATAR_URL')) {
			$use_gravatar = true;
		}
	}

	$cancel = $plxShow->getLang('CANCEL');
	$reply = $plxShow->getLang('REPLY');
?>
		<h3 id="comments"><?= $plxShow->artNbCom(); ?> :</h3>
		<div <?= $allowedArtComs ? 'id="answer-coms"' : '' ?> class="comments" data-cancel="<?= $cancel ?>" data-reply="<?= $reply ?>"<?= !empty($use_gravatar) ? ' data-gravatar="' . GRAVATAR_URL . '" data-size="' . AVATAR_SIZE . '"' : '' ?>>
<?php
	while($plxShow->plxMotor->plxRecord_coms->loop()) {
		$author = $plxShow->plxMotor->plxRecord_coms->f('author');
?>
			<div id="<?php $plxShow->comId(); ?>" class="<?php $plxShow->comLevel(); ?>">
				<div class="com-avatar">
<?php
$email = $plxShow->plxMotor->plxRecord_coms->f('mail');
if(!empty($email)) {
	$hash = md5(strtolower(trim($email)));
	if(function_exists('wavatar_get')) {
		$src = wavatar_get($email, AVATAR_SIZE);
?>
					<img src="<?= $src ?>" width="<?= AVATAR_SIZE ?>" height="<?= AVATAR_SIZE ?>" data-hash="<?= $hash ?>"/>
<?php
	} else {
?>
					<img src="<?= AVATAR_DEFAULT ?>" width="<?= AVATAR_SIZE ?>" height="<?= AVATAR_SIZE ?>" data-hash="<?= $hash ?>" />
<?php
	}
} else {
?>
					<img src="<?= AVATAR_DEFAULT ?>" width="<?= AVATAR_SIZE ?>" height="<?= AVATAR_SIZE ?>" />
<?php
}
?>
				</div>
				<header class="com-header">
					<a class="nbcom" href="<?php $plxShow->ComUrl(); ?>">#<?= $plxShow->plxMotor->plxRecord_coms->i + 1 ?></a>&nbsp;
					<time datetime="<?php $plxShow->comDate('#num_year(4)-#num_month-#num_day #hour:#minute'); ?>"><?php $plxShow->comDate('#num_day/#num_month/#num_year(4) - #hour:#minute'); ?></time>,
<?php
		$site =  trim($plxShow->plxMotor->plxRecord_coms->f('site'));
		if(!empty($site)) {
?>
					<a rel="nofollow" href="<?= $site ?>" target="_blank"><?= $author ?></a>
<?php
		} else {
?>
					<span><?= $author ?></span>
<?php
		}
?>
					<?php $plxShow->lang('SAID'); ?>&nbsp;:
				</header>
				<main class="com-main">
					<blockquote>
						<p class="content_com type-<?php $plxShow->comIndex(); ?>"><?php $plxShow->comContent(); ?></p>
					</blockquote>
				</main>
<?php
		if(!empty($allowedArtComs)) {
?>
				<footer class="com-footer">
					<label for="id-comm-title" class="button" data-comid="<?php $plxShow->comId(); ?>" data-author="<?= $author ?>"><?= $reply ?></label>
				</footer>
<?php
		}
?>
			</div>
<?php
	} # Fin boucle commentaires
?>
		</div>
<?php
}

if($allowedArtComs) {
	if(!isset($_SESSION['msgcom']) || isset($_SESSION['msg'])) {
		# l'id de la form suivante est utilisé par plxMotor::demarrage(). Il doit être égal à "form".
?>
	<input type="checkbox" id="id-comm-title" class="toggle" />
	<h3 class="no-print"><span><?php $plxShow->lang(!empty($plxShow->plxMotor->plxRecord_coms) ? 'ADD_A_COMMENT' : 'WRITE_THE_FIRST_COMMENT') ?></span><span id="replyTo"><?php $plxShow->lang('REPLY_TO') ?></span></h3>
	<form name="frm_comment" id="form" action="<?php $plxShow->artUrl(); ?>#form" method="post" class="frm-comment">
		<div>
			<input type="hidden" name="parent" value="<?php $plxShow->comGet('parent'); ?>" />
			<input type="text" name="name" value="<?php $plxShow->comGet('name'); ?>" minlength="4" maxlength="30" placeholder="<?php $plxShow->lang('NAME') ?>" required />
		</div>
		<div class="infos">
			<input type="email" name="mail" value="<?php $plxShow->comGet('mail'); ?>" maxlength="30" placeholder="<?php $plxShow->lang('EMAIL') ?>" />
			<input type="url" name="site" value="<?php $plxShow->comGet('site'); ?>" maxlength="30" placeholder="<?php $plxShow->lang('WEBSITE') ?>" />
		</div>
		<textarea name="content" rows="6" placeholder="<?php $plxShow->lang('COMMENT') ?>" required><?php $plxShow->comGet('content'); ?></textarea>
		<?php $plxShow->comMessage('<p id="com_message" class="#com_class"><strong>#com_message</strong></p>'); ?>
<?php printCapcha(); ?>
		<div>
			<button type="submit" class="button"><?php $plxShow->lang('SEND_COMMENT') ?></button>
		</div>
	</form>
<?php
	} else {
		# Le commentaire est publié ou en modération
?>
	<?php $plxShow->comMessage('<p id="com_message" class="#com_class"><strong>#com_message</strong></p>'); ?>
<?php
	}
?>
	<?php $plxShow->comFeed('rss', $plxShow->artId(), '<p class="rss"><a href="#feedUrl" title="#feedTitle">#feedName</a></p>'); ?>
<?php
	# End of allowed comments
} else {
	# Comments are banned !
?>
	<p>
		<?php $plxShow->lang('COMMENTS_CLOSED') ?>.
	</p>
<?php
}
