<?php
if (!defined('PLX_ROOT')) exit;

const THEME_TAGS = true;
const THEME_ARCHIVES = true;

const MENU_TEMPLATE = <<< TEMPLATE
<li class="#static_class #static_status" id="#static_id"><a href="#static_url">#static_name</a></li>
TEMPLATE;
const GROUP_TEMPLATE = <<< TEMPLATE
<span class="#group_class #group_status">#group_name</span>
TEMPLATE;
const TAG_TEMPLATE = <<< TEMPLATE
<a class="#tag_status" href="#tag_url">#tag_name</a>
TEMPLATE;
const ART_POST_THUMBNAIL_TEMPLATE = <<< TEMPLATE
<a class="art thumbnail" href="#img_url"><img src="#img_thumb_url" alt="#img_alt" #img_thumb_size title="#img_title" /></a>
TEMPLATE;
const ART_THUMBNAIL_TEMPLATE = <<< TEMPLATE
<a class="art thumbnail" href="#img_url" target=_blank><img src="#img_thumb_url" alt="#img_alt" #img_thumb_size title="#img_title" /></a>
TEMPLATE;
const CAT_THUMBNAIL_TEMPLATE = <<< TEMPLATE
<a class="cat thumbnail" href="#img_url" target=_blank><img src="#img_thumb_url" alt="#img_alt" #img_thumb_size title="#img_title" /></a>
TEMPLATE;

if(method_exists($plxShow, 'authorList')) {
	$users = array_filter(
		$plxShow->plxMotor->aUsers,
		function($user) { return !empty($user['active']) and empty($user['delete']); }
	);
	if(count($users) > 1) {
		define('MULTI_USERS', true);
	}
}

function printCapcha() {
	global $plxShow;

	if($plxShow->plxMotor->aConf['capcha']) {
		// Hack against PluXml: $plxShow->plxMotor->plxCapcha est instancié uniquement en mode article.
		if(empty($plxShow->plxMotor->plxCapcha)) {
			$plxShow->plxMotor->plxCapcha = new plxCapcha();
		}
?>
		<div>
			<label for="id_rep"><strong><?php echo $plxShow->lang('ANTISPAM_WARNING') ?></strong> :</label>
			<div class="capcha-challenge">
				<p>
					<?php $plxShow->capchaQ(); ?>
				</p>
				<input type="text" name="rep" id="id_rep" maxlength="1" class="antispam" autocomplete="off" required />
			</div>
		</div>
<?php
	}
}
?>
<!DOCTYPE html>
<html lang="<?php $plxShow->defaultLang() ?>">
<head>
	<meta charset="<?php $plxShow->charset('min'); ?>">
	<meta name="viewport" content="width=device-width, user-scalable=yes, initial-scale=1.0">
	<title><?php $plxShow->pageTitle(); ?></title>
<?php
foreach(array('description keywords author') as $mt) {
	$plxShow->meta($mt);
}
?>
	<link rel="icon" href="<?php $plxShow->template(); ?>/img/favicon.png" />
	<link rel="stylesheet" href="<?php $plxShow->template(); ?>/css/knacss.min.css" />
	<link rel="stylesheet" href="<?php $plxShow->template(); ?>/css/theme.css" />
<?php
	$plxShow->templateCss();
	$plxShow->pluginsCss();
if($plxMotor->aConf['enable_rss']) {
	$rssMode = $plxMotor->mode;
	switch($rssMode) {
		case 'categorie' :
			ob_start(); $plxShow->catName();
			$rssTitle = sprintf($plxShow->getLang('CATEGORIE_RSS_FEEDS'), ob_get_clean());
			break;
		case 'tags':
				if(defined('THEME_TAGS')) {
			   		$rssTitle = sprintf($plxShow->getLang('TAGS_RSS_FEEDS'), $plxShow->plxMotor->cible);
				}
			break;
		case 'user':
			$rssTitle = sprintf($plxShow->getLang('AUTHOR_RSS_FEEDS'));
			break;
		default:
			$rssTitle = $plxShow->getLang('ARTICLES_RSS_FEEDS');
			$rssMode = '';
	}
?>
	<link rel="alternate" type="application/rss+xml" title="<?=$rssTitle ?>" href="<?php $plxShow->urlPostsRssFeed($rssMode); ?>" />
	<link rel="alternate" type="application/rss+xml" title="<?php $plxShow->lang('COMMENTS_RSS_FEEDS') ?>" href="<?php $plxShow->urlRewrite('feed.php?rss/commentaires') ?>" />
<?php
}

if(method_exists($plxShow, 'canonical')) {
	$plxShow->canonical();
}

$logos = array_filter(
	glob($plxMotor->aConf['racine_themes'] . $plxMotor->style . '/img/logo*'),
	function($item) { return preg_match('@\.(?:jpe?g|png|svg|gif|webp)$@', $item); }
);

?>
</head>
<body class="page mode-<?php $plxShow->mode(true) ?><?= defined('FULL_WIDTH') ? '' : ' with-sidebar' ?><?= preg_match('@^static-(sitemap|contact|gallery)\.php$@', $plxShow->plxMotor->template) ? ' smart' : '' ?>">
<?php
if(!defined('NO_HEADER')) {
?>
	<header class="main-header<?= !empty($logos) ? ' with-logo' : '' ?>" id="top">
		<!-- img src="<?php $plxShow->template(); ?>/img/banner.jpg" alt="banner" / -->
		<div>
<?php
if(count($logos) > 0) {
?>
			<div class="logo">
				<a href="<?php $plxShow->urlRewrite() ?>"><img src="<?php $plxShow->urlRewrite($logos[0]) ?>" alt="<?php $plxShow->mainTitle(); ?>" /></a>
			</div>
<?php
}
?>
			<div class="brand">
				<h1><?php $plxShow->mainTitle('link'); ?></h1>
				<h2><?php $plxShow->subTitle(); ?></h2>
			</div>
		</div>
<?php eval($plxShow->callHook("ResponsiveSlidesJs")) ?>
	</header>
<?php
}
?>
	<nav id="nav-header">
		<button role="button" aria-label="open/close navigation"><?php $plxShow->lang('MENU'); ?></button>
		<ul id="menu" <?= !empty($myStaticPages) ? 'data-onepage="' . strtolower(MY_GROUP) . '"' : '' ?>>
			<?php $plxShow->staticList($plxShow->getLang('HOME'), MENU_TEMPLATE, GROUP_TEMPLATE, -1); ?>
			<li class="menu categories">
				<span class="group <?= ($plxMotor->mode == 'categorie') ? 'active' : 'noactive' ?>"><?php $plxShow->lang('CATEGORIES'); ?></span>
				<ul class="sub-menu">
<?php $plxShow->catList('','<li class="#cat_status"><a href="#cat_url"><span>#cat_name</span> <span>(<em>#art_nb</em>)</span></a></li>'); ?>
				</ul>
			</li>
			<!-- ?php $plxShow->pageBlog(MENU_TEMPLATE); ? -->
		</ul>
	</nav>
	<main class="main-content">
