const gulp = require('gulp');
const sass = require('gulp-sass');
const postcss = require('gulp-postcss');
const CombineMQ = require('postcss-combine-media-query');
const autoprefixer = require('autoprefixer');
const CSSnano = require('cssnano');
const rename = require('gulp-rename');
const uglify = require('gulp-uglify');

gulp.task('css:full', () => {
  return gulp.src('sass/knacss.scss')
    .pipe(sass(
      {
      outputStyle: 'expanded'
      }))
    .pipe(
      postcss([
        autoprefixer, // ajoute les préfixes vendeurs
      ]))
	.pipe(rename('knacss.css'))
    .pipe(gulp.dest('../css'));
});

gulp.task('css:mini', () => {
  return gulp.src('sass/knacss.scss')
    .pipe(sass(
      {
      outputStyle: 'compact'
      }))
    .pipe(
      postcss([
        CombineMQ, // rassemble les Media Queries (parfait pour les classes utilitaires)
        autoprefixer, // ajoute les préfixes vendeurs
        CSSnano // minification 
      ]))
	.pipe(rename('knacss.min.css'))
    .pipe(gulp.dest('../css'));
});

gulp.task('css:grillade', () => {
  return gulp.src('sass/utils/grillade.scss')
    .pipe(sass(
      {
      outputStyle: 'compact'
      }))
    .pipe(
      postcss([
        CombineMQ, // rassemble les Media Queries (parfait pour les classes utilitaires)
        autoprefixer, // ajoute les préfixes vendeurs
        CSSnano // minification 
      ]))
	.pipe(rename('grillade.css'))
    .pipe(gulp.dest('../css'));
});

gulp.task('css:theme', () => {
	return gulp.src('../css/theme.css')
	.pipe(
		postcss([
			CombineMQ,
			autoprefixer,
			CSSnano
		])
	)
	.pipe(rename('theme.min.css'))
	.pipe(gulp.dest('../css'))
});

gulp.task('js:theme', () => {
	return gulp.src('../js/script.js')
	.pipe(uglify())
	.pipe(rename('script.min.js'))
	.pipe(gulp.dest('../js'))
});

// Tâche BUILD : tapez "gulp" ou "gulp build"
// gulp.task('build', gulp.series('css:full', 'css:mini', 'css:grillade'));
gulp.task('build', gulp.series('css:full', 'css:mini'));
gulp.task('theme', gulp.series('css:theme', 'js:theme'));

// Tâche par défaut
gulp.task('default', gulp.series('build', 'theme'));

