<?php
if(!defined('PLX_ROOT')) { exit; }

include 'header.php';

if(method_exists($plxShow, 'artNavigation')) {
?>
		            <div id="art-navigation">
<?php $plxShow->artNavigation('<li><a class="button" href="#url" rel="#dir" title="#title">#emoji</a></li>'); ?>
		            </div>
<?php	
}

?>					
		<article class="article" id="post-<?php echo $plxShow->artId(); ?>">
			<header class="art-header">
				<h2>
					<?php $plxShow->artTitle(); ?>
				</h2>
<?php
if(defined('MULTI_USERS')) {
?>
				<div>
					<span class="written-by"><?php $plxShow->lang('WRITTEN_BY'); ?> <?php $plxShow->artAuthor() ?></span>
					<time class="art-date" datetime="<?php $plxShow->artDate('#num_year(4)-#num_month-#num_day'); ?>"><?php $plxShow->artDate('#num_day #month #num_year(4)'); ?></time>
					<span class="art-nb-com"><?php $plxShow->artNbCom(); ?></span>
				</div>
<?php
}
?>
			</header>
			<main class="art-main">
				<?php $plxShow->artThumbnail(ART_THUMBNAIL_TEMPLATE); ?>
<?php $plxShow->artContent(); ?>
			</main>
			<footer class="art-footer">
<?php
if(!defined('MULTI_USERS')) {
?>
				<span>
					<?php $plxShow->lang('PUBLISHED_ON') ?>	<time class="art-date" datetime="<?php $plxShow->artDate('#num_year(4)-#num_month-#num_day'); ?>"><?php $plxShow->artDate('#num_day #month #num_year(4)'); ?></time>
				</span>
<?php
}
?>
				<span class="classified-in">
					<?php $plxShow->lang('CLASSIFIED_IN') ?> : <?php $plxShow->artCat(' ') ?>
				</span>
<?php
if(defined('THEME_TAGS')) {
?>
				<span class="tags">
					<?php $plxShow->lang('TAGS') ?> : <?php $plxShow->artTags(TAG_TEMPLATE, ' ') ?>
				</span>
<?php
}
?>
			</footer>
		</article>
<?php
if(defined('MULTI_USERS')) {
	ob_start();
?>
		<div class="author-infos">
			<p><?php $plxShow->lang('AUTHOR_ABOUT'); /* must contain #art_author */ ?> :</p>
			<div>
			#art_authorinfos
			</div>
		</div>
<?php
	$plxShow->artAuthorInfos(ob_get_clean());
}

if($plxShow->plxMotor->aConf['allow_com']) {
	include 'comments.php';
}

include 'footer.php';
