import { FreeDatas2HTML, SortingField } from "../src/FreeDatas2HTML";
const errors=require("../src/errors.js");
const fixtures=require("./fixtures.js");

describe("Test des champs de classement.", () =>
{
    let converter: FreeDatas2HTML;
    let sortingField: SortingField;
    
    beforeEach( async () =>
    {
        document.body.insertAdjacentHTML("afterbegin", fixtures.datasViewEltHTML);
        converter=new FreeDatas2HTML("CSV");
        converter.parser.setRemoteSource({ url:"http://localhost:9876/datas/datas1.csv" });
        converter.datasViewElt={  id:"datas" };
        await converter.run(); // parsage + 1er affichage des données
        const  fields=document.querySelectorAll("th");
    });

    afterEach( () =>
    {
        document.body.removeChild(document.getElementById("fixture"));
    });

    describe("Test des données reçues pour configurer le champ de classement.",  () =>
    {
        it("Doit générer une erreur, si initialisé sans fournir la liste des champs servant à classer les données.", () =>
        {
            converter=new FreeDatas2HTML("CSV");
            // Pas lancé converter.run() donc les données n'ont pas été parsées :
            expect(() => { return  new SortingField(converter, 0); }).toThrowError(errors.sortingFieldNeedDatas);
        });

         it("Doit générer une erreur, si initialisé avec un numéro du champ de classement n'existant dans ceux à afficher.", () =>
        {
            expect(() => { return new SortingField(converter, 9); }).toThrowError(errors.sortingFieldNotFound);
            expect(() => { return new SortingField(converter, -1); }).toThrowError(errors.sortingFieldNotFound);
            expect(() => { return new SortingField(converter, 1.1); }).toThrowError(errors.sortingFieldNotFound);
            converter.fields2Rend=[0,2,3];
            expect(() => { return new SortingField(converter, 1); }).toThrowError(errors.sortingFieldNotFound);
        });

       it("Si tous les paramètres sont ok, ils doivent être acceptés.", () =>
        {
            expect(() => { return sortingField=new SortingField(converter, 1, "th"); }).not.toThrowError();
            expect(sortingField.datasFieldNb).toEqual(1);
            expect(sortingField.fieldsDOMSelector).toEqual("th");
            converter.fields2Rend=[0,2,3];
            expect(() => { return sortingField=new SortingField(converter, 3, "th.test"); }).not.toThrowError();
            expect(sortingField.datasFieldNb).toEqual(3);
            expect(sortingField.fieldsDOMSelector).toEqual("th.test");
        });
    });
    
    describe("Création et action des liens permettant de classer les données affichées.", () =>
    {
        it("Doit générer une erreur, si les éléments HTML devant contenir les noms des champs ne sont pas trouvés dans le DOM.", () =>
        {
            sortingField=new SortingField(converter, 0, "th.cols");
            expect(() => { return sortingField.field2HTML(); }).toThrowError(errors.sortingsFieldNotInHTML);
        });

       it("Doit générer une erreur, si le nombre d'éléments trouvés dans le DOM pour les entêtes est différent de celui des champs à afficher.", () =>
        {
            sortingField=new SortingField(converter, 0, "td");
            expect(() => { return sortingField.field2HTML(); }).toThrowError(errors.sortingFieldsNbFail);
        });

        it("Doit générer un élement lien ayant comme ancre le nom du champ ciblé.",  () =>
        {
            sortingField=new SortingField(converter, 0);
            sortingField.field2HTML();
            sortingField=new SortingField(converter, 2);
            sortingField.field2HTML();
            let getTH=document.getElementsByTagName("th");
            expect(getTH[0].innerHTML).toEqual(fixtures.sortingColumn1HTML);
            expect(getTH[2].innerHTML).toEqual(fixtures.sortingColumn2HTML);
        });
        
        it("Doit générer un élement lien ayant comme ancre le nom du champ ciblé, même si tous les champs ne sont pas affichés.",  () =>
        {
           converter.fields2Rend=[0,2,3];
           converter.refreshView();
            sortingField=new SortingField(converter, 0);
            sortingField.field2HTML();
            sortingField=new SortingField(converter, 2);
            sortingField.field2HTML();
            let getTH=document.getElementsByTagName("th");
            expect(getTH[0].innerHTML).toEqual(fixtures.sortingColumn1HTML);
            expect(getTH[1].innerHTML).toEqual(fixtures.sortingColumn2HTML);// puisque le champ "1" n'est pas affiché.
        });

        it("Lorsqu'ils sont cliqués, doivent transmettre l'information au convertisseur + lui demander d'actualiser l'affichage.", () =>
        {
            const sortingField1=new SortingField(converter, 2);
            sortingField1.field2HTML();
            const sortingField2=new SortingField(converter, 3);
            sortingField2.field2HTML();
            converter.datasSortingFields=[sortingField1, sortingField2];

            let getTHLinks=document.querySelectorAll("th a") as NodeListOf<HTMLElement>;
            spyOn(converter, "refreshView"); 
            getTHLinks[0].click();// tri ascendant 1er champ
            expect(sortingField1.converter.datasSortedField).toEqual(sortingField1);
            expect(sortingField1.converter.datasSortedField.order).toEqual("asc");
            expect(converter.refreshView).toHaveBeenCalledTimes(1);
            
            getTHLinks[1].click();// tri ascendant mais sur le second champ
            expect(sortingField2.converter.datasSortedField).toEqual(sortingField2);
            expect(sortingField2.converter.datasSortedField.order).toEqual("asc");
            expect(converter.refreshView).toHaveBeenCalledTimes(2);
            
            getTHLinks[0].click();// tri descendant sur le 1er champ
            expect(sortingField1.converter.datasSortedField).toEqual(sortingField1);
            expect(sortingField1.converter.datasSortedField.order).toEqual("desc");
            expect(converter.refreshView).toHaveBeenCalledTimes(3);

            getTHLinks[0].click();// de nouveau ascendant
            expect(sortingField1.converter.datasSortedField).toEqual(sortingField1);
            expect(sortingField1.converter.datasSortedField.order).toEqual("asc");
            expect(converter.refreshView).toHaveBeenCalledTimes(4);
        });
    });    
});