import { FreeDatas2HTML, Selector } from "../FreeDatas2HTML";
import { MixedFieldsRender } from "../extensions/MixedFieldsRender";

const initialise=async () =>
{
    try
    {
        // Création d'un convertisseur parsant des données transmises en JSON :
        const converter=new FreeDatas2HTML("JSON");
        converter.parser.setRemoteSource({ url: "https://freedatas2html.le-fab-lab.com/datas/links.json"});
        // Parsage des données, qui ne sont pas encore affichées :
        await converter.run();
        
        // Chaînes à utiliser par le moteur de rendu :
        const renderSettings=
        {
            allBegining: `<ul>`,
            allEnding: `</ul>`,
            datasLinesDisplaying: `<li><ul><li>##1##</li><li>Mots-clés : ##2##.</li>##0##</ul></li>`
        };
        // Fonctions spécifiques pour créer les liens hypertextes :
        const rendAnchor2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["url"] !== undefined && values["url"] !== "") // je considère que anchor est toujours renseigné, mais on pourrait tester.
                return `<a href="${values['url']}" target="_blank">${values["anchor"]}</a>`;
            else
                return `<b>${values["anchor"]}</b>`;
        };
        const rendUrl2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["url"] !== "") // si values["url"] = undefined, la fonction rendUrl2HTML() n'est pas appelée.
                return `<li><a href="${values['url']}" target="_blank" title="Visiter ${values['anchor']}">${values["url"]}</a></li>`;
            else
                return  "";
        };
        const myRender=new MixedFieldsRender(renderSettings);
        myRender.fieldRenders=[{ name:"anchor",  rend2HTML: rendAnchor2HTML}, { name:"url",  rend2HTML: rendUrl2HTML}];
        converter.datasRender=myRender;
        
        // Création d'un filtre sur le troisième champ :
        let filtre1=new Selector(converter, 2, { id:"filtre1"}, "," );
        filtre1.filter2HTML("Mots-clés");
        converter.datasFilters=[filtre1];
                
        // Affichage initial avec l'id de l'élément HTML devant afficher le compteur :
        converter.datasViewElt={  id:"datas" };
        converter.refreshView(); 
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithMixedFields.ts");
initialise();