import { FreeDatas2HTML } from "../FreeDatas2HTML";
var errors = require("../errors.js");
errors.needSortingFields = "Vous devez fournir au moins un champ de classement valide.";
var SortingFieldsStandAlone = (function () {
    function SortingFieldsStandAlone(converter, elt, settings) {
        if (settings === void 0) { settings = SortingFieldsStandAlone.defaultSettings; }
        this._datasViewElt = { id: "", eltDOM: undefined };
        this.datasSortingFields = [];
        if (converter.fields.length === 0)
            throw new Error(errors.sortingFieldNeedDatas);
        this._datasViewElt = FreeDatas2HTML.checkInDOMById(elt);
        this._converter = converter;
        this.rendSettings = settings;
    }
    Object.defineProperty(SortingFieldsStandAlone.prototype, "converter", {
        get: function () {
            return this._converter;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SortingFieldsStandAlone.prototype, "datasViewElt", {
        get: function () {
            return this._datasViewElt;
        },
        enumerable: true,
        configurable: true
    });
    SortingFieldsStandAlone.prototype.rend2HTML = function (label) {
        if (label === void 0) { label = ""; }
        if (this.datasSortingFields.length === 0)
            throw new Error(errors.needSortingFields);
        var htmlContent = this.rendSettings.allBeginning.replace("#LABEL", label);
        for (var _i = 0, _a = this.datasSortingFields; _i < _a.length; _i++) {
            var field = _a[_i];
            htmlContent += this.rendSettings.fieldBeginning + "<a href='#freeDatas2HTMLSorting" + field.datasFieldNb + "' id='freeDatas2HTMLSorting" + field.datasFieldNb + "'>" + this._converter.fields[field.datasFieldNb] + "</a>" + this.rendSettings.fieldEnding;
        }
        htmlContent += this.rendSettings.allEnding;
        this._datasViewElt.eltDOM.innerHTML = htmlContent;
        var _loop_1 = function (field) {
            var sortingLink = document.getElementById("freeDatas2HTMLSorting" + field.datasFieldNb);
            sortingLink.addEventListener("click", function (e) {
                e.preventDefault();
                if (field.order === undefined || field.order === "desc")
                    field.order = "asc";
                else
                    field.order = "desc";
                field.converter.datasSortedField = field;
                field.converter.refreshView();
            });
        };
        for (var _b = 0, _c = this.datasSortingFields; _b < _c.length; _b++) {
            var field = _c[_b];
            _loop_1(field);
        }
    };
    SortingFieldsStandAlone.defaultSettings = {
        allBeginning: "<span>#LABEL</span><ul>",
        allEnding: "</ul>",
        fieldBeginning: "<li>",
        fieldEnding: "</li>",
    };
    return SortingFieldsStandAlone;
}());
export { SortingFieldsStandAlone };
export { FreeDatas2HTML, SortingField } from "../FreeDatas2HTML";
export { errors };
