var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { FreeDatas2HTML, Pagination, Render, SearchEngine, SortingField } from "../FreeDatas2HTML";
var initialise = function () {
    try {
        var dataDisplayElt_1 = document.getElementById("datas");
        var dataDisplayOptionsElt_1 = document.getElementById("displayOptions");
        var myFile_1 = document.getElementById("myFile");
        var myForm = document.getElementById("userSettings");
        var pagesElt_1 = document.getElementById("pages");
        var paginationElt_1 = document.getElementById("paginationOptions");
        var searchElt_1 = document.getElementById("search");
        if (dataDisplayElt_1 === null || dataDisplayOptionsElt_1 === null || myFile_1 === null || myForm === null || pagesElt_1 === null || paginationElt_1 === null || searchElt_1 === null)
            throw new Error("Tous les éléments HTML nécessaires au fonctionnement n'ont pas été trouvés dans la page;");
        var converter_1;
        var myRender_1 = new Render();
        myRender_1.settings.allBegining = "<table class='table-hover'><caption>Nombre de résultats : <span  id='counter'></span></caption>";
        myFile_1.addEventListener("change", function (e) {
            dataDisplayElt_1.innerHTML = "";
            dataDisplayOptionsElt_1.innerHTML = "";
            pagesElt_1.innerHTML = "";
            paginationElt_1.innerHTML = "";
            searchElt_1.innerHTML = "";
            converter_1 = new FreeDatas2HTML("CSV");
            converter_1.datasRender = myRender_1;
            var selectedFiles = myFile_1.files;
            if (selectedFiles !== null && selectedFiles.length === 1) {
                var extension = selectedFiles[0].name.substring(selectedFiles[0].name.lastIndexOf(".") + 1);
                if (extension !== "csv")
                    dataDisplayOptionsElt_1.innerHTML = "<p class='text-danger'>Le fichier que vous avez s\u00E9lectionn\u00E9 ne semble pas \u00EAtre un fichier CSV.</p>";
                else {
                    var reader_1 = new FileReader();
                    reader_1.onload = function (e) {
                        return __awaiter(this, void 0, void 0, function () {
                            var fieldsSelectorHTML, i;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        converter_1.parser.datas2Parse = reader_1.result;
                                        return [4, converter_1.run()];
                                    case 1:
                                        _a.sent();
                                        fieldsSelectorHTML = "<fieldset class=\"form-group\"><legend>Quels champs souhaitez-vous afficher ?</legend>";
                                        for (i = 0; i < converter_1.fields.length; i++)
                                            fieldsSelectorHTML += "<label for=\"selectedField_" + i + "\" class=\"paper-check\"> <input type=\"checkbox\" class=\"selectedFields\" id=\"selectedField_" + i + "\" name=\"selectedField_" + i + "\" value=" + i + " checked> <span>" + converter_1.fields[i] + "</span></label>";
                                        fieldsSelectorHTML += "</fieldset>";
                                        dataDisplayOptionsElt_1.innerHTML = fieldsSelectorHTML + "<button type=\"submit\" class=\"btn-success\">Valider</button>";
                                        return [2];
                                }
                            });
                        });
                    };
                    reader_1.readAsText(selectedFiles[0]);
                }
            }
        });
        myForm.addEventListener("submit", function (e) {
            e.preventDefault();
            dataDisplayElt_1.innerHTML = "";
            var fields2Rend = [];
            var checkBox;
            for (var i = 0; i < converter_1.fields.length; i++) {
                checkBox = document.getElementById("selectedField_" + i);
                if (checkBox !== null) {
                    if (checkBox.checked)
                        fields2Rend.push(i);
                }
            }
            if (fields2Rend.length === 0)
                dataDisplayElt_1.innerHTML = "<p class='text-danger'>Merci de s\u00E9lectionner les champs que vous souhaitez afficher !</p>";
            else {
                converter_1.fields2Rend = fields2Rend;
                converter_1.datasViewElt = { id: "datas" };
                var mySearch = new SearchEngine(converter_1, { id: "search" });
                mySearch.label = "Qui cherche trouve ?";
                mySearch.btnTxt = "Va chercher !";
                mySearch.automaticSearch = true;
                mySearch.nbCharsForSearch = 2;
                mySearch.placeholder = "Saisir un moins 2 caractères";
                mySearch.filter2HTML();
                converter_1.datasFilters = [mySearch];
                var pagination = new Pagination(converter_1, { id: "pages" }, "Page à afficher :");
                pagination.options = { displayElement: { id: "paginationOptions" }, values: [10, 20, 50, 100, 500], name: "Choix de pagination :" };
                pagination.selectedValue = 20;
                converter_1.pagination = pagination;
                pagination.options2HTML();
                converter_1.datasCounterElt = { id: "counter" };
                var sortingField = void 0;
                converter_1.datasSortingFields = [];
                for (var i = 0; i < converter_1.fields2Rend.length; i++) {
                    sortingField = new SortingField(converter_1, converter_1.fields2Rend[i]);
                    converter_1.datasSortingFields.push(sortingField);
                }
                converter_1.refreshView();
                var here = window.location;
                if (window.location.hash !== "") {
                    window.location.hash = "";
                    window.location.assign(here + "paginationOptions");
                }
                else
                    window.location.assign(here + "#paginationOptions");
            }
        });
    }
    catch (e) {
        console.error(e);
        document.getElementById("datas").innerHTML = "<div class=\"alert alert-warning\">D\u00E9sol\u00E9, mais un probl\u00E8me technique emp\u00EAche le fonctionnement normal de cette page.</div>";
    }
};
console.log("Hello, les dev !\nLe code source TypeScript utilisé pour faire fonctionner cette page est lisible ici : :\nhttps://forge.chapril.org/Fab_Blab/FreeDatas2HTML/src/branch/master/src/demo/exampleWithUserFile.ts");
initialise();
