var errors = require("./errors.js");
var SortingField = (function () {
    function SortingField(converter, datasFieldNb, fieldsDOMSelector) {
        if (fieldsDOMSelector === void 0) { fieldsDOMSelector = "th"; }
        this._order = undefined;
        if (converter.fields.length === 0)
            throw new Error(errors.sortingFieldNeedDatas);
        else if (!converter.checkField2Rend(datasFieldNb))
            throw new Error(errors.sortingFieldNotFound);
        else {
            this._converter = converter;
            this._datasFieldNb = datasFieldNb;
            this._fieldsDOMSelector = fieldsDOMSelector;
        }
    }
    Object.defineProperty(SortingField.prototype, "converter", {
        get: function () {
            return this._converter;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SortingField.prototype, "datasFieldNb", {
        get: function () {
            return this._datasFieldNb;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SortingField.prototype, "fieldsDOMSelector", {
        get: function () {
            return this._fieldsDOMSelector;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SortingField.prototype, "order", {
        get: function () {
            return this._order;
        },
        set: function (setting) {
            this._order = setting;
        },
        enumerable: true,
        configurable: true
    });
    SortingField.prototype.field2HTML = function () {
        var fields = document.querySelectorAll(this.fieldsDOMSelector);
        if (fields === undefined)
            throw new Error(errors.sortingFieldsNotInHTML);
        else if (fields.length !== this._converter.realFields2Rend().length)
            throw new Error(errors.sortingFieldsNbFail);
        else {
            var htmlContent = void 0;
            var index = this._converter.getFieldDisplayRank(this._datasFieldNb);
            htmlContent = fields[index].innerHTML;
            htmlContent = "<a href='#freeDatas2HTMLSorting" + this._datasFieldNb + "' id='freeDatas2HTMLSorting" + this._datasFieldNb + "'>" + htmlContent + "</a>";
            fields[index].innerHTML = htmlContent;
            var sortingElement = document.getElementById("freeDatas2HTMLSorting" + this._datasFieldNb), field_1 = this;
            sortingElement.addEventListener("click", function (e) {
                e.preventDefault();
                var order = field_1._order;
                if (order === undefined || order === "desc")
                    field_1._order = "asc";
                else
                    field_1._order = "desc";
                field_1._converter.datasSortedField = field_1;
                field_1._converter.refreshView();
            });
        }
    };
    return SortingField;
}());
export { SortingField };
