var errors = require("./errors.js");
import { FreeDatas2HTML } from "./FreeDatas2HTML";
var SearchEngine = (function () {
    function SearchEngine(converter, elt, fields) {
        this._datasViewElt = { id: "", eltDOM: undefined };
        this._btnTxt = "Search";
        this._fields2Search = [];
        this.label = "";
        this.nbCharsForSearch = 0;
        this.placeholder = "";
        this.automaticSearch = false;
        this._inputValue = "";
        this.searchMode = {
            accentOff: true,
            caseOff: true,
            separatedWords: true,
            specialCharsOff: true,
            specialCharsWhiteList: "",
        };
        if (converter.fields.length === 0 || converter.datas.length === 0)
            throw new Error(errors.filterNeedDatas);
        else {
            this._datasViewElt = FreeDatas2HTML.checkInDOMById(elt);
            this._converter = converter;
            if (fields !== undefined && fields.length !== 0) {
                for (var _i = 0, fields_1 = fields; _i < fields_1.length; _i++) {
                    var field = fields_1[_i];
                    if (!this._converter.checkFieldExist(field))
                        throw new Error(errors.searchFieldNotFound);
                    else
                        this._fields2Search.push(this.converter.fields[field]);
                }
            }
            else
                this._fields2Search = this._converter.fields;
        }
    }
    Object.defineProperty(SearchEngine.prototype, "converter", {
        get: function () {
            return this._converter;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SearchEngine.prototype, "datasViewElt", {
        get: function () {
            return this._datasViewElt;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SearchEngine.prototype, "btnTxt", {
        get: function () {
            return this._btnTxt;
        },
        set: function (txt) {
            if (txt.trim() !== "" && txt.length <= 30)
                this._btnTxt = txt;
            else
                console.error(errors.searchBtnTxtFail);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SearchEngine.prototype, "inputValue", {
        get: function () {
            return this._inputValue;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SearchEngine.prototype, "fields2Search", {
        get: function () {
            return this._fields2Search;
        },
        enumerable: true,
        configurable: true
    });
    SearchEngine.prototype.filter2HTML = function () {
        if (this.nbCharsForSearch > 0 && this.placeholder === "")
            this.placeholder = "Please enter at least NB characters.";
        var html = "<form id=\"freeDatas2HTMLSearch\">";
        if (this.label !== "")
            html += "<label for=\"freeDatas2HTMLSearchTxt\">" + this.label + "</label>";
        html += "<input type=\"search\" id=\"freeDatas2HTMLSearchTxt\" name=\"freeDatas2HTMLSearchTxt\"";
        if (this.nbCharsForSearch > 0)
            html += " placeholder=\"" + this.placeholder.replace("NB", "" + this.nbCharsForSearch) + "\"";
        else if (this.placeholder !== "")
            html += " placeholder=\"" + this.placeholder + "\"";
        html += ">&nbsp;<input type=\"submit\" id=\"freeDatas2HTMLSearchBtn\" value=\"" + this._btnTxt + "\"></form>";
        this._datasViewElt.eltDOM.innerHTML = html;
        var searchInput = document.getElementById("freeDatas2HTMLSearchTxt"), mySearch = this;
        searchInput.addEventListener("input", function (e) {
            e.preventDefault();
            mySearch._inputValue = searchInput.value.trim();
            var searchLength = mySearch._inputValue.length;
            if (mySearch.automaticSearch && (mySearch.nbCharsForSearch === 0 || (searchLength === 0) || (searchLength >= mySearch.nbCharsForSearch)))
                mySearch._converter.refreshView();
        });
        var searchBtn = document.getElementById("freeDatas2HTMLSearchBtn");
        searchBtn.addEventListener("click", function (e) {
            e.preventDefault();
            mySearch._converter.refreshView();
        });
    };
    SearchEngine.prototype.searchPreProcessing = function (searchElement) {
        var finalString = searchElement;
        if (this.searchMode.accentOff)
            finalString = finalString.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
        if (this.searchMode.caseOff)
            finalString = finalString.toLowerCase();
        if (this.searchMode.specialCharsOff) {
            var validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 " + this.searchMode.specialCharsWhiteList;
            var validString = "";
            for (var _i = 0, finalString_1 = finalString; _i < finalString_1.length; _i++) {
                var letter = finalString_1[_i];
                if (validChars.indexOf(letter) !== -1)
                    validString += letter;
            }
            finalString = validString;
        }
        return finalString;
    };
    SearchEngine.prototype.dataIsOk = function (data) {
        var realSearch = this.searchPreProcessing(this._inputValue.trim());
        if (realSearch.length === 0)
            return true;
        var searchedWords = [];
        if (this.searchMode.separatedWords)
            searchedWords = realSearch.split(" ");
        else
            searchedWords[0] = realSearch;
        var nbFound = 0;
        for (var _i = 0, searchedWords_1 = searchedWords; _i < searchedWords_1.length; _i++) {
            var word = searchedWords_1[_i];
            for (var field in data) {
                if (this._fields2Search.indexOf(field) !== -1) {
                    if (this.searchPreProcessing(data[field]).indexOf(word.trim()) !== -1) {
                        nbFound++;
                        break;
                    }
                }
            }
        }
        if (nbFound < searchedWords.length)
            return false;
        else
            return true;
    };
    return SearchEngine;
}());
export { SearchEngine };
