var errors = require("./errors.js");
var Render = (function () {
    function Render(settings) {
        if (settings === void 0) { settings = Render.defaultSettings; }
        this._fields = [];
        this.datas = [];
        this.settings = settings;
    }
    Object.defineProperty(Render.prototype, "fields", {
        get: function () {
            return this._fields;
        },
        set: function (fields) {
            if (fields.length === 0)
                throw new Error(errors.renderNeedFields);
            else
                this._fields = fields;
        },
        enumerable: true,
        configurable: true
    });
    Render.prototype.rend2HTML = function () {
        if (this._fields.length === 0)
            throw new Error(errors.renderNeedFields);
        else {
            var datasHTML = this.settings.allBegining;
            if (this.settings.fieldsBegining !== undefined && this.settings.fieldDisplaying !== undefined && this.settings.fieldsEnding !== undefined) {
                datasHTML += this.settings.fieldsBegining;
                for (var _i = 0, _a = this._fields; _i < _a.length; _i++) {
                    var field = _a[_i];
                    datasHTML += this.settings.fieldDisplaying.replace("#FIELDNAME", field);
                }
                datasHTML += this.settings.fieldsEnding;
            }
            datasHTML += this.settings.linesBegining;
            for (var _b = 0, _c = this.datas; _b < _c.length; _b++) {
                var row = _c[_b];
                datasHTML += this.settings.lineBegining;
                for (var _d = 0, _e = this._fields; _d < _e.length; _d++) {
                    var field = _e[_d];
                    if (row[field] !== undefined)
                        datasHTML += this.settings.dataDisplaying.replace("#VALUE", row[field]).replace("#FIELDNAME", field);
                    else
                        datasHTML += this.settings.dataDisplaying.replace("#VALUE", "").replace("#FIELDNAME", field);
                }
                datasHTML += this.settings.lineEnding;
            }
            datasHTML += this.settings.linesEnding + this.settings.allEnding;
            return datasHTML;
        }
    };
    Render.defaultSettings = {
        allBegining: "<table>",
        allEnding: "</table>",
        fieldsBegining: "<thead><tr>",
        fieldsEnding: "</tr></thead>",
        fieldDisplaying: "<th>#FIELDNAME</th>",
        linesBegining: "<tbody>",
        linesEnding: "</tbody>",
        lineBegining: "<tr>",
        lineEnding: "</tr>",
        dataDisplaying: "<td>#VALUE</td>"
    };
    return Render;
}());
export { Render };
