var errors = require("./errors.js");
var RemoteSource = (function () {
    function RemoteSource(RemoteSettings) {
        this.allowedUrlProtocol = ["https:", "http:"];
        this._url = "";
        this._headers = [];
        this._withCredentials = false;
        if (RemoteSettings.url !== "")
            this.url = RemoteSettings.url;
        if (RemoteSettings.headers !== undefined)
            this.headers = RemoteSettings.headers;
        if (RemoteSettings.withCredentials !== undefined)
            this.withCredentials = RemoteSettings.withCredentials;
    }
    Object.defineProperty(RemoteSource.prototype, "url", {
        get: function () {
            return this._url;
        },
        set: function (url) {
            if (url.trim().length === 0)
                throw new Error(errors.remoteSourceNeedUrl);
            else {
                try {
                    var checkUrl = new URL(url);
                    if (this.allowedUrlProtocol.indexOf(checkUrl.protocol) === -1)
                        throw new Error();
                }
                catch (e) {
                    console.error(e);
                    throw new Error(errors.remoteSourceUrlFail);
                }
                this._url = url.trim();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RemoteSource.prototype, "headers", {
        get: function () {
            return this._headers;
        },
        set: function (headers) {
            var forbiddenHeadersNames = ["Accept-Charset", "Accept-Encoding", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Connection", "Content-Length", "Cookie", "Cookie2", "Date", "DNT", "Expect", "Host", "Keep-Alive", "Origin", "Referer", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "Via"];
            for (var _i = 0, headers_1 = headers; _i < headers_1.length; _i++) {
                var header = headers_1[_i];
                header.key = header.key.trim();
                if (header.key.startsWith("Sec-") || header.key.startsWith("Proxy-") || forbiddenHeadersNames.indexOf(header.key) !== -1)
                    console.error(errors.remoteSourceHeaderIsUnallowed);
                else
                    this._headers.push({ key: header.key, value: header.value.trim() });
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RemoteSource.prototype, "withCredentials", {
        get: function () {
            return this._withCredentials;
        },
        set: function (credentials) {
            this._withCredentials = credentials;
        },
        enumerable: true,
        configurable: true
    });
    RemoteSource.prototype.getFetchSettings = function () {
        var headers = new Headers();
        if (this._headers !== undefined) {
            for (var _i = 0, _a = this._headers; _i < _a.length; _i++) {
                var header = _a[_i];
                headers.append(header.key, header.value);
            }
        }
        var credentials = (this._withCredentials) ? "include" : "omit";
        return { method: "GET", headers: headers, credentials: credentials };
    };
    return RemoteSource;
}());
export { RemoteSource };
