var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var errors = require("./errors.js");
import { RemoteSource } from "./RemoteSource";
var ParserForHTML = (function () {
    function ParserForHTML(datasRemoteSource) {
        this._document2Parse = document;
        this._parseResults = undefined;
        this._fieldsSelector = "table > thead > tr > th";
        this._rowsSelector = "table > tbody > tr";
        this._datasSelector = "tr > td";
        if (datasRemoteSource !== undefined)
            this._datasRemoteSource = datasRemoteSource;
        else
            this._datasRemoteSource = new RemoteSource({ url: "" });
    }
    ParserForHTML.prototype.setRemoteSource = function (source) {
        this._datasRemoteSource = new RemoteSource(source);
    };
    Object.defineProperty(ParserForHTML.prototype, "datasRemoteSource", {
        get: function () {
            return this._datasRemoteSource;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForHTML.prototype, "document2Parse", {
        get: function () {
            return this._document2Parse;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForHTML.prototype, "fieldsSelector", {
        get: function () {
            return this._fieldsSelector;
        },
        set: function (selector) {
            if (selector.trim() === "")
                throw new Error(errors.parserSelectorsIsEmpty);
            else
                this._fieldsSelector = selector.trim();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForHTML.prototype, "rowsSelector", {
        get: function () {
            return this._rowsSelector;
        },
        set: function (selector) {
            if (selector.trim() === "")
                throw new Error(errors.parserSelectorsIsEmpty);
            else
                this._rowsSelector = selector.trim();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForHTML.prototype, "datasSelector", {
        get: function () {
            return this._datasSelector;
        },
        set: function (selector) {
            if (selector.trim() === "")
                throw new Error(errors.parserSelectorsIsEmpty);
            else
                this._datasSelector = selector.trim();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForHTML.prototype, "parseResults", {
        get: function () {
            return this._parseResults;
        },
        enumerable: true,
        configurable: true
    });
    ParserForHTML.prototype.parse = function () {
        return __awaiter(this, void 0, void 0, function () {
            var realFields, datas, parseErrors, settings, response, responseHTML, parserDOM, fields, i, checkField, rows, datasElts, i, dataObject, j;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        realFields = [], datas = [], parseErrors = [];
                        if (!(this._datasRemoteSource.url !== "")) return [3, 3];
                        settings = this._datasRemoteSource.getFetchSettings();
                        return [4, fetch(this._datasRemoteSource.url, settings)];
                    case 1:
                        response = _a.sent();
                        if (!response.ok)
                            throw new Error(errors.parserRemoteFail);
                        return [4, response.text()];
                    case 2:
                        responseHTML = _a.sent();
                        parserDOM = new DOMParser();
                        this._document2Parse = parserDOM.parseFromString(responseHTML, "text/html");
                        _a.label = 3;
                    case 3:
                        fields = this._document2Parse.querySelectorAll(this._fieldsSelector);
                        if (fields.length === 0)
                            throw new Error(errors.parserElementsNotFound + this._fieldsSelector);
                        for (i = 0; i < fields.length; i++) {
                            checkField = (fields[i].textContent + "").trim();
                            if (checkField !== "" && realFields.indexOf(checkField) === -1)
                                realFields.push(checkField);
                            else
                                parseErrors.push({ row: -1, message: errors.parserFieldNameFail });
                        }
                        if (realFields.length === 0)
                            throw new Error(errors.parserFieldsNotFound);
                        rows = this._document2Parse.querySelectorAll(this._rowsSelector);
                        for (i = 0; i < rows.length; i++) {
                            datasElts = rows[i].querySelectorAll(this._datasSelector);
                            if (datasElts.length !== realFields.length)
                                parseErrors.push({ row: i, message: errors.parserNumberOfFieldsFail });
                            dataObject = {};
                            for (j = 0; j < datasElts.length && j < realFields.length; j++)
                                dataObject[realFields[j]] = datasElts[j].textContent + "";
                            if (Object.keys(dataObject).length !== 0)
                                datas.push(dataObject);
                            else
                                parseErrors.push({ row: i, message: errors.parserLineWithoutDatas });
                        }
                        this._parseResults =
                            {
                                datas: datas,
                                errors: parseErrors,
                                fields: realFields,
                            };
                        return [2];
                }
            });
        });
    };
    return ParserForHTML;
}());
export { ParserForHTML };
