var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var Papa = require("papaparse");
var errors = require("./errors.js");
import { RemoteSource } from "./RemoteSource";
var ParserForCSV = (function () {
    function ParserForCSV(datasRemoteSource) {
        this._datas2Parse = "";
        this._parseResults = undefined;
        this.options = {
            delimiter: "",
            newline: "",
            quoteChar: '"',
            escapeChar: '"',
            transformHeader: function (field, index) { return field.trim(); },
            preview: 0,
            comments: "",
            fastMode: undefined,
            transform: undefined
        };
        this._privateOptions = {
            header: true,
            download: false,
            downloadRequestHeaders: undefined,
            skipEmptyLines: "greedy",
            withCredentials: undefined
        };
        if (datasRemoteSource !== undefined)
            this._datasRemoteSource = datasRemoteSource;
        else
            this._datasRemoteSource = new RemoteSource({ url: "" });
    }
    ParserForCSV.prototype.setRemoteSource = function (source) {
        this._datasRemoteSource = new RemoteSource(source);
    };
    Object.defineProperty(ParserForCSV.prototype, "datasRemoteSource", {
        get: function () {
            return this._datasRemoteSource;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForCSV.prototype, "datas2Parse", {
        get: function () {
            return this._datas2Parse;
        },
        set: function (datas) {
            if (datas.trim().length === 0)
                throw new Error(errors.parserNeedDatas);
            else
                this._datas2Parse = datas.trim();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForCSV.prototype, "parseResults", {
        get: function () {
            return this._parseResults;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ParserForCSV.prototype, "privateOptions", {
        get: function () {
            return this._privateOptions;
        },
        enumerable: true,
        configurable: true
    });
    ParserForCSV.prototype.parse = function () {
        return __awaiter(this, void 0, void 0, function () {
            var parser, parseContent, _i, _a, header;
            var _this = this;
            return __generator(this, function (_b) {
                parser = this;
                parseContent = "";
                if (parser._datasRemoteSource.url !== "") {
                    parseContent = parser._datasRemoteSource.url;
                    this._privateOptions.download = true;
                    this._privateOptions.withCredentials = parser._datasRemoteSource.withCredentials;
                    if (parser._datasRemoteSource.headers !== undefined) {
                        this._privateOptions.downloadRequestHeaders = {};
                        for (_i = 0, _a = parser._datasRemoteSource.headers; _i < _a.length; _i++) {
                            header = _a[_i];
                            this._privateOptions.downloadRequestHeaders[header.key] = header.value;
                        }
                    }
                }
                else if (parser._datas2Parse !== "")
                    parseContent = parser._datas2Parse;
                else
                    throw new Error(errors.parserNeedSource);
                return [2, new Promise(function (resolve, reject) {
                        Papa.parse(parseContent, {
                            delimiter: _this.options.delimiter,
                            newline: _this.options.newline,
                            quoteChar: _this.options.quoteChar,
                            escapeChar: _this.options.escapeChar,
                            header: true,
                            transformHeader: _this.options.transformHeader,
                            preview: _this.options.preview,
                            comments: _this.options.comments,
                            complete: function (results) {
                                var realFields = [], parseErrors = [];
                                for (var _i = 0, _a = results.meta.fields; _i < _a.length; _i++) {
                                    var field = _a[_i];
                                    var checkField = field.trim();
                                    if (checkField !== "" && realFields.indexOf(checkField) === -1)
                                        realFields.push(checkField);
                                    else
                                        parseErrors.push({ row: -1, message: errors.parserFieldNameFail });
                                }
                                if (realFields.length === 0)
                                    reject(new Error(errors.parserFieldsNotFound));
                                else {
                                    parser._parseResults =
                                        {
                                            datas: results.data,
                                            errors: parseErrors.concat(results.errors),
                                            fields: realFields,
                                        };
                                    resolve(true);
                                }
                            },
                            download: _this._privateOptions.download,
                            downloadRequestHeaders: _this._privateOptions.downloadRequestHeaders,
                            skipEmptyLines: "greedy",
                            fastMode: _this.options.fastMode,
                            withCredentials: _this._privateOptions.withCredentials,
                            transform: _this.options.transform
                        });
                    })];
            });
        });
    };
    return ParserForCSV;
}());
export { ParserForCSV };
