var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var compare = require("natural-orderby").compare;
var errors = require("./errors.js");
import { ParserForCSV } from "./ParserForCSV";
import { ParserForHTML } from "./ParserForHTML";
import { ParserForJSON } from "./ParserForJSON";
import { Render } from "./Render";
var FreeDatas2HTML = (function () {
    function FreeDatas2HTML(datasFormat, datas2Parse, datasRemoteSource) {
        if (datas2Parse === void 0) { datas2Parse = ""; }
        this._datasViewElt = undefined;
        this.stopIfParseErrors = false;
        this._datasSortingFunctions = [];
        this.datasFilters = [];
        this.datasSortingFields = [];
        this._fields2Rend = [];
        this.datasCounterElt = undefined;
        this._fields = [];
        this._datas = [];
        this._datas2Rend = [];
        this._nbDatasValid = 0;
        this.datasRender = new Render();
        switch (datasFormat) {
            case "CSV":
                this.parser = new ParserForCSV();
                break;
            case "HTML":
                this.parser = new ParserForHTML();
                break;
            case "JSON":
                this.parser = new ParserForJSON();
                break;
        }
        if (datas2Parse.trim() !== "")
            this.parser.datas2Parse = datas2Parse;
        else if (datasRemoteSource !== undefined)
            this.parser.setRemoteSource(datasRemoteSource);
    }
    FreeDatas2HTML.checkInDOMById = function (checkedElt) {
        var searchEltInDOM = document.getElementById(checkedElt.id);
        if (searchEltInDOM === null)
            throw new Error(errors.converterElementNotFound + checkedElt.id);
        else {
            checkedElt.eltDOM = searchEltInDOM;
            return checkedElt;
        }
    };
    Object.defineProperty(FreeDatas2HTML.prototype, "datasViewElt", {
        set: function (elt) {
            this._datasViewElt = FreeDatas2HTML.checkInDOMById(elt);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreeDatas2HTML.prototype, "datas", {
        get: function () {
            return this._datas;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreeDatas2HTML.prototype, "fields", {
        get: function () {
            return this._fields;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreeDatas2HTML.prototype, "nbDatasValid", {
        get: function () {
            return this._nbDatasValid;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreeDatas2HTML.prototype, "fields2Rend", {
        get: function () {
            return this._fields2Rend;
        },
        set: function (fields) {
            if (fields.length === 0)
                this._fields2Rend = fields;
            else {
                this._fields2Rend = [];
                for (var _i = 0, fields_1 = fields; _i < fields_1.length; _i++) {
                    var field = fields_1[_i];
                    if (!this.checkFieldExist(field))
                        throw new Error(errors.converterFieldNotFound);
                    else
                        this._fields2Rend.push(field);
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreeDatas2HTML.prototype, "datas2Rend", {
        get: function () {
            return this._datas2Rend;
        },
        enumerable: true,
        configurable: true
    });
    FreeDatas2HTML.prototype.getSortingFunctionForField = function (datasFieldNb) {
        for (var _i = 0, _a = this._datasSortingFunctions; _i < _a.length; _i++) {
            var checkedFunction = _a[_i];
            if (checkedFunction.datasFieldNb === datasFieldNb)
                return checkedFunction;
        }
        return undefined;
    };
    FreeDatas2HTML.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.parser.parse()];
                    case 1:
                        _a.sent();
                        if (this.parser.parseResults === undefined)
                            throw new Error(errors.parserFail);
                        else {
                            if (this.stopIfParseErrors && this.parser.parseResults.errors !== undefined)
                                throw new Error(errors.parserMeetErrors);
                            else {
                                this._fields = this.parser.parseResults.fields;
                                this._datas = this.parser.parseResults.datas;
                                if (this._datasViewElt !== undefined)
                                    this.refreshView();
                                return [2, true];
                            }
                        }
                        return [2];
                }
            });
        });
    };
    FreeDatas2HTML.prototype.checkFieldExist = function (nb) {
        if (this.parser.parseResults === undefined || this.parser.parseResults.fields[nb] === undefined)
            return false;
        else
            return true;
    };
    FreeDatas2HTML.prototype.checkField2Rend = function (nb) {
        if (this._fields2Rend.length === 0)
            return this.checkFieldExist(nb);
        else {
            if (this._fields2Rend.indexOf(nb) === -1)
                return false;
            else
                return true;
        }
    };
    FreeDatas2HTML.prototype.getFieldDisplayRank = function (nb) {
        if (this.checkField2Rend(nb) === false)
            return -1;
        if (this._fields2Rend.length === 0)
            return nb;
        else
            return this._fields2Rend.indexOf(nb);
    };
    FreeDatas2HTML.prototype.realFields2Rend = function () {
        if (this._fields2Rend.length === 0)
            return this._fields;
        else {
            var realFields = [];
            for (var _i = 0, _a = this._fields2Rend; _i < _a.length; _i++) {
                var fieldId = _a[_i];
                realFields.push(this._fields[fieldId]);
            }
            return realFields;
        }
    };
    Object.defineProperty(FreeDatas2HTML.prototype, "datasSortingFunctions", {
        set: function (SortingFunctions) {
            this._datasSortingFunctions = [];
            for (var _i = 0, SortingFunctions_1 = SortingFunctions; _i < SortingFunctions_1.length; _i++) {
                var checkedFunction = SortingFunctions_1[_i];
                if (!this.checkFieldExist(checkedFunction.datasFieldNb))
                    throw new Error(errors.converterFieldNotFound);
                else
                    this._datasSortingFunctions.push(checkedFunction);
            }
        },
        enumerable: true,
        configurable: true
    });
    FreeDatas2HTML.prototype.refreshView = function (paginationSelected) {
        if (paginationSelected === void 0) { paginationSelected = false; }
        if (this._fields.length === 0 || this._datasViewElt === undefined)
            throw new Error(errors.converterRefreshFail);
        else {
            if (this._fields2Rend.length === 0)
                this.datasRender.fields = this._fields;
            else
                this.datasRender.fields = this.realFields2Rend();
            this._datas2Rend = this.datas2HTML(paginationSelected);
            this.datasRender.datas = this._datas2Rend;
            this._datasViewElt.eltDOM.innerHTML = this.datasRender.rend2HTML();
            this.datasCounter2HTML();
            for (var _i = 0, _a = this.datasSortingFields; _i < _a.length; _i++) {
                var field = _a[_i];
                field.field2HTML();
            }
            if (this.pagination !== undefined && !paginationSelected)
                this.pagination.pages2HTML();
        }
    };
    FreeDatas2HTML.prototype.datasCounter2HTML = function () {
        if (this.datasCounterElt !== undefined) {
            this.datasCounterElt = FreeDatas2HTML.checkInDOMById(this.datasCounterElt);
            this.datasCounterElt.eltDOM.textContent = "" + this._nbDatasValid;
        }
    };
    FreeDatas2HTML.prototype.datas2HTML = function (paginationSelected) {
        if (this.datasSortedField !== undefined) {
            var field_1 = this._fields[this.datasSortedField.datasFieldNb];
            var fieldOrder_1 = this.datasSortedField.order;
            if (this.getSortingFunctionForField(this.datasSortedField.datasFieldNb) !== undefined) {
                var myFunction_1 = this.getSortingFunctionForField(this.datasSortedField.datasFieldNb);
                this._datas.sort(function (a, b) { return myFunction_1.sort(a[field_1], b[field_1], fieldOrder_1); });
            }
            else
                this._datas.sort(function (a, b) { return compare({ order: fieldOrder_1 })(a[field_1], b[field_1]); });
        }
        var firstData = 0;
        if (this.pagination !== undefined && this.pagination.selectedValue !== undefined && this.pagination.pages !== undefined && this.pagination.pages.selectedValue !== undefined)
            firstData = this.pagination.selectedValue * (this.pagination.pages.selectedValue - 1);
        var maxData = (this.pagination !== undefined && this.pagination.selectedValue !== undefined) ? this.pagination.selectedValue : this._datas.length;
        if (this.pagination !== undefined && this.pagination.pages !== undefined && this.pagination.pages.selectedValue !== undefined && !paginationSelected)
            this.pagination.pages.selectedValue = 1;
        var datas2Display = [];
        var nbVisible = 0, nbTotal = 0;
        for (var row in this._datas) {
            var valid = true, i = 0;
            while (this.datasFilters[i] !== undefined && valid === true) {
                valid = this.datasFilters[i].dataIsOk(this._datas[row]);
                i++;
            }
            if (valid && nbTotal >= firstData && nbVisible < maxData) {
                datas2Display.push(this._datas[row]);
                nbVisible++;
                nbTotal++;
            }
            else if (valid)
                nbTotal++;
        }
        this._nbDatasValid = nbTotal;
        if (this._fields2Rend.length !== 0) {
            var realFields = this.realFields2Rend(), newDatas2Display = [];
            for (var row in datas2Display) {
                var newData = {};
                for (var field in datas2Display[row]) {
                    if (realFields.indexOf(field) !== -1)
                        newData[field] = datas2Display[row][field];
                }
                newDatas2Display.push(newData);
            }
            datas2Display = newDatas2Display;
        }
        return datas2Display;
    };
    return FreeDatas2HTML;
}());
export { FreeDatas2HTML };
export { Pagination } from "./Pagination";
export { Render } from "./Render";
export { SearchEngine } from "./SearchEngine";
export { Selector } from "./Selector";
export { SortingField } from "./SortingField";
