const path = require('path');

module.exports =
{
  mode: "development",
  entry:
  {
    segal: "./src/segal.ts"
  },
  output:
  {
    path: path.resolve(__dirname, "public"),
    filename: "JS/[name].app.js"
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  }, 
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
    ],
  },
  devServer: {
    static: path.join(__dirname, "public")
  },  
};