import { FreeDatas2HTML, Pagination, SearchEngine, Selector } from "../../src/FreeDatas2HTML";
import { MixedFieldsRender } from "../../src/extensions/MixedFieldsRender";

const initialise=async () =>
{
    try
    {
        // Création d'un convertisseur parsant des données transmises en JSON :
        const converter=new FreeDatas2HTML("CSV");
        converter.parser.setRemoteSource({ url: "https://pluxml.segal.bzh/data/medias/partenaires/partenaires.csv"});
        // Parsage des données, qui ne sont pas encore affichées :
        await converter.run();
        // Chaînes à utiliser par le moteur de rendu :
        const renderSettings=
        {
            allBegining: "<ul class=\"ulpartenairelvl1\">",
            allEnding: "</ul>",
            datasLinesDisplaying: `<li><h3>##0##</h3><ul class=\"ulpartenairelvl2\"><li>##1##</li>##2##<li>Lieu(x) d'exercice : ##4####5##.</li>##6####7####8##</ul></li>`
        };
        // Fonctions spécifiques pour créer les liens hypertextes :
        const rendName2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Fiche partenaire"] !== undefined && values["Fiche partenaire"].trim() !== "")
                return `<a href="${values['Fiche partenaire'].trim()}" title="Fiche partenaire de ${values["Nom commercial"].trim()}">${values["Nom commercial"].trim()}</a>`;
            else
                return values["Nom commercial"].trim();
        };

        const rendSSDomaine2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Sous activités"] !== undefined && values["Sous activités"].trim() !== "")
                return `<li>${values["Sous activités"].trim()}</li>`;
            else
                return "";
        };

        const rendLieuxVente2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Ville (si adresse pertinente)"] !== undefined && values["Ville (si adresse pertinente)"].trim() !== "")
                return `${values["Adresse (si pertinente)"].trim()}, ${values["Ville (si adresse pertinente)"].trim()}`;
            else
                return "";
        };

        const rendTel2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Téléphone"].trim() !== "")
                return  `<li>&#9990; <a href="tel:${values['Téléphone'].trim()}" title="Appelez ${values['Nom commercial'].trim()}">${values['Téléphone'].trim()}</a></li>`;
            else
                return  "";
        };
        
        const rendEmail2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["Courriel"].trim() !== "")
                return `<li>&#128231 <a href="mailto:${values['Courriel'].trim()}?subject=Le segal">Courriel</a></li>`;
            else
                return  "";
        };
        
        const rendSite2HTML=(values: {[index: string]:string} ) : string =>
        {
            if(values["www"].trim() !== "")
                return `<li><a href="${values['www'].trim()}" target="_blank" rel='noopener'>Sa page internet</a></li>`;
            else if(values["FB"].trim() !== "")
                return `<li><a href="${values['FB'].trim()}" target="_blank" rel='noopener'>Sa page facebook</a></li>`;
            else if(values["IG"].trim() !== "")
                return `<li><a href="${values['IG'].trim()}" target="_blank" rel='noopener'>Sa page instagram</a></li>`;
            else
                return  "";
        };

        const myRender=new MixedFieldsRender(renderSettings);
        myRender.fieldRenders=[{ name:"Nom commercial",  rend2HTML: rendName2HTML}, { name:"Sous activités",  rend2HTML: rendSSDomaine2HTML}, { name:"Ville (si adresse pertinente)",  rend2HTML: rendLieuxVente2HTML},  { name:"Téléphone",  rend2HTML: rendTel2HTML}, { name:"Courriel",  rend2HTML: rendEmail2HTML}, { name:"www",  rend2HTML: rendSite2HTML} ];
        converter.datasRender=myRender;
        
        // Création des filtres  :
        const filtre1=new Selector(converter, 1, { id:"filtreActivites"} );
        filtre1.filter2HTML("Domaine d'activité");
        // Dont un moteur de recherche :
        const mySearch=new SearchEngine(converter, { id:"search" });
        mySearch.label="";
        mySearch.btnTxt="Chercher";
        // La recherche se lance automatiquement, dès que 2 caractères sont saisis :
        mySearch.automaticSearch=true;
        mySearch.nbCharsForSearch=2;
        mySearch.placeholder="Exemples de recherche : creperie port-louis, pain bio...";
        mySearch.filter2HTML();
        converter.datasFilters=[filtre1,mySearch];
        
        // Id de l'élément HTML devant afficher la liste de partenaires :
        converter.datasViewElt={  id:"partenaires" };
       // Pas d'affichage initial, car il est généré en PHP côté backend.
    }
    catch(e)
    {
        console.error(e);
        document.getElementById("datas")!.innerHTML=`<div class="alert alert-warning">Désolé, mais un problème technique empêche l'affichage des données.</div>`;
    }
}

console.log("**** Hello les devs :-)\nLe code source de ce script est libre et vous pouvez le trouver à cette adresse :\n https://forge.chapril.org/Fab_Blab/freeDatas2HTML/src/branch/master/integrations/src/segal.ts");
initialise();