////////////////////////////////////////////////////////////////////////////////
// Window

function isWindowOpen(win)
{
	// if (win is not undefined, not null) and win.open and (not win.closed)
	if (win && win.open && ! win.closed)
		return true;
	else
		return false;
}

function isWindowLoaded(win)
{
	if (win && win.open && ! win.closed && win.document && win.document.readyState && win.document.readyState == 'complete')
		return true;
	else
		return false;
}

function LoqWindow_WriteUnbuffered(win, html_txt, scrolling)
{
	var h;
	var y;

	if (! scrolling)
		scrolling = 'auto';

	if (isWindowOpen(win) && win.document && win.document.body) {
		switch (scrolling) {
		case 'auto':
			h = win.document.body.scrollHeight - win.document.body.clientHeight;
			y = win.document.body.scrollTop;
			break;
		}
	}

	switch (html_txt.charCodeAt(0)) {
	case 0:
		if (isWindowOpen(win) && win.document)
			win.document.open(html_txt.substring(1));
		break;
	case 255:
		if (isWindowOpen(win) && win.document)
			win.document.close();
		break;
	default:
		if (isWindowOpen(win) && win.document)
			win.document.writeln(html_txt);
	}

	if (isWindowOpen(win) && win.document && win.document.body) {
		switch (scrolling) {
		case 'auto':
			if (y >= h)
				win.scrollTo(0, win.document.body.scrollHeight);
			break;

		case 'bottom':
			win.scrollTo(0, win.document.body.scrollHeight);
			break;
		}
	}
}

function LoqWindow()
{
	this.WriteUnbuffered = LoqWindow_WriteUnbuffered;
}

