
////////////////////////////////////////////////////////////////////////////////
// utility functions

function hasNoProperty(obj)
{
	if (typeof(obj) == 'undefined')
		return true;

	var p;
	for (p in obj) {
		break;
	}
	return ! p;
}

function isChannelName(peer)
{
	/* if peer is not undefined, is not null, is not empty('')
	// and it begins with one of #,&,+,! */
	if (peer && peer.search(/^[#&+!]/) != -1)
		return true;
	else
		return false;
}

function randomNick()
{
	// generate a random nick ('Loq0' to 'Loq999')
	return 'Loq' + Math.ceil(Math.random() * 999).toString();
}

////////////////////////////////////////////////////////////////////////////////

function htmlSafeString(str)
{
	// make a string html-safe
	return str.replace(/&/g, '&amp;') // & -> '&amp;'
		.replace(/</g, '&lt;')  // < -> '&lt;'
		.replace(/>/g, '&gt;')  // > -> '&gt;'
		.replace(/\"/g, '&quot;')  // " -> '&quot;'
		.replace(/^ /g, '&nbsp;') // ^' ' -> '&nbsp;'
		.replace(/ $/g, '&nbsp;') // ' '$ -> '&nbsp;'
		.replace(/  /g, ' &nbsp;'); // '  ' -> ' &nbsp;'
}

function jsSafeString(str)
{
	// make a string javascript-safe
	return str.replace(/\\/g, '\\\\')
		.replace(/\"/g, '&quot;')
		.replace(/\'/g, '\\\'');
}

////////////////////////////////////////////////////////////////////////////////

function Msg2Html(str)
{
	return mIRC2Html(emoticon2Img(str));
}

function Msg2Text(str)
{
	return mIRC2Text(str);
}

////////////////////////////////////////////////////////////////////////////////

var MSN_Emoticons = [
	[ /\(&amp;\)/g,
	'emoticon/bowwow.gif',
	'' ],

	[ /\([Yy]\)/g,
	'emoticon/thumbs_up.gif',
	' հ ' ],

	[ /\([Nn]\)/g,
	'emoticon/thumbs_down.gif',
	' հ Ʒ' ],

	[ /\([Bb]\)/g,
	'emoticon/beer_yum.gif',
	' ' ],

	[ /\([Dd]\)/g,
	'emoticon/martini_shaken.gif',
	'Ƽ ' ],

	[ /\([Xx]\)/g,
	'emoticon/girl_handsacrossamerica.gif',
	'ҳ' ],

	[ /\([Zz]\)/g,
	'emoticon/guy_handsacrossamerica.gif',
	'ҳ' ],

	[ /:(-)?\[/g,
	'emoticon/bat.gif',
	'' ],

	[ /\(\}\)/g,
	'emoticon/girl_hug.gif',
	' ' ],

	[ /\(\{\)/g,
	'emoticon/dude_hug.gif',
	' ' ],

	[ /:(-)?\)/g,
	'emoticon/regular_smile.gif',
	'̼' ],

	[ /:(-)?[Dd]/g,
	'emoticon/teeth_smile.gif',
	'  ' ],

	[ /:(-)?[Oo]/g,
	'emoticon/omg_smile.gif',
	'¦̾' ],

	[ /:(-)?[Pp]/g,
	'emoticon/tounge_smile.gif',
	'޷~' ],

	[ /;(-)?\)/g,
	'emoticon/wink_smile.gif',
	'ũ' ],

	[ /:(-)?\(/g,
	'emoticon/sad_smile.gif',
	'' ],

	[ /:(-)?[Ss]/g,
	'emoticon/confused_smile.gif',
	'' ],

	[ /:(-)?\|/g,
	'emoticon/whatchutalkingabout_smile.gif',
	'Ǹΰ' ],

	[ /:\'\(/g,
	'emoticon/cry_smile.gif',
	'ﺸ' ],

	[ /:(-)?\$/g,
	'emoticon/embaressed_smile.gif',
	'β' ],

	[ /\([Hh]\)/g,
	'emoticon/shades_smile.gif',
	'۶ ' ],

	[ /:(-)?@/g,
	'emoticon/angry_smile.gif',
	'ȭ' ],

	[ /\([Aa]\)/g,
	'emoticon/angel_smile.gif',
	'õ' ],

	[ /\(6\)/g,
	'emoticon/devil_smile.gif',
	'Ǹ' ],

	[ /\([Ll]\)/g,
	'emoticon/heart.gif',
	' ' ],

	[ /\([Uu]\)/g,
	'emoticon/broken_heart.gif',
	'ó ' ],

	[ /\([Kk]\)/g,
	'emoticon/kiss.gif',
	'ɿ~' ],

	[ /\([Gg]\)/g,
	'emoticon/present.gif',
	'̾' ],

	[ /\([Ff]\)/g,
	'emoticon/rose.gif',
	'   ' ],

	[ /\([Ww]\)/g,
	'emoticon/wilted_rose.gif',
	'õ  ' ],

	[ /\([Pp]\)/g,
	'emoticon/camera.gif',
	'ī޶' ],

	[ /\(~\)/g,
	'emoticon/film.gif',
	'ʸ' ],

	[ /\([Tt]\)/g,
	'emoticon/phone.gif',
	'ȭ' ],

	[ /\(@\)/g,
	'emoticon/kittykay.gif',
	'' ],

	[ /\([Cc]\)/g,
	'emoticon/coffee.gif',
	'Ŀ' ],

	[ /\([Ii]\)/g,
	'emoticon/lightbulb.gif',
	'' ],

	[ /\(S\)/g,
	'emoticon/moon.gif',
	'ʽ´' ],

	[ /\(\*\)/g,
	'emoticon/star.gif',
	'' ],

	[ /\(8\)/g,
	'emoticon/musical_note.gif',
	'ǥ' ],

	[ /\([Ee]\)/g,
	'emoticon/envelope.gif',
	'' ],

	[ /\(\^\)/g,
	'emoticon/cake.gif',
	' ؿ' ],

	[ /\([Oo]\)/g,
	'emoticon/clock.gif',
	'ð' ],

	[ /\([Mm]\)/g,
	'emoticon/messenger.gif',
	'޽ ' ]
];

function emoticon2Img(str)
{
	for (var i = 0; i < MSN_Emoticons.length; i++) {
		str = str.replace(MSN_Emoticons[i][0], '<img src="'+MSN_Emoticons[i][1]+'" alt="'+MSN_Emoticons[i][2]+'">');
	}
	return str;
}

////////////////////////////////////////////////////////////////////////////////

var mIRC_Colors= {
	'0':'#ffffff',
	'1':'#000000',
	'2':'#00007b',
	'3':'#009200',
	'4':'#ff0000',
	'5':'#7b0000',
	'6':'#9c009c',
	'7':'#ff7d00',
	'8':'#ffff00',
	'9':'#00ff00',
	'10':'#009294',
	'11':'#00ffff',
	'12':'#0000ff',
	'13':'#ff00ff',
	'14':'#7b7d7b',
	'15':'#d6d3d6'
};

function mIRC2Html(str)
{
	var html_str = '';

	{
		function makePlain()
		{
			if (cur_style) {
				if (cur_style & 4)
					html_str += '</b>';
				if (cur_style & 2)
					html_str += '</u>';
				if (cur_style & 1)
					html_str += '</font>';
				else if (cur_style & (8|16))
					html_str += '</font>';
				cur_style = 0;
			}
		}

		var cur_style = 0; // bg-color:10000(16), fg-color:1000(8), bold:100(4), underline:010(2), reverse:001(1)
		var cur_fg, cur_bg;
		for (var i = 0; i < str.length; i++) {
			// \x03:color, \x02:bold, \x1f:underline, \x16:reverse, \x0f:plain
			switch (str.charAt(i)) {
			case '\x02': // bold
				if (cur_style & 4) {
					html_str += '</b>';
					cur_style &= ~(4);
				}
				else {
					html_str += '<b>';
					cur_style |= 4;
				}
				break;
			case '\x03': // color
				if ((cur_style & (8|16)) && ! (cur_style & 1)) // fg|bg
					html_str += '</font>';
				var color = (/^([0-9]{1,2})(,([0-9]{1,2}))?/g).exec(str.substring(i+1,i+6));
				if (color) {
					if (color[3]) {
						cur_bg = mIRC_Colors[color[3]%16];
						cur_style |= 16;
					}
					cur_fg = mIRC_Colors[color[1]%16];
					if (! (cur_style & 1)) { // don't change color for reverse style
						html_str += '<font color="'+cur_fg+'"';
						if (cur_bg)
							html_str += ' style="background:'+cur_bg+'"';
						html_str +='>';
					}
					i += color[0].length;
					cur_style |= 8;
				}
				else {
					if (cur_style & 8) { // fg
						cur_style &= ~(8);
						cur_fg = '';
					}
					if (cur_style & 16) { // bg
						cur_style &= ~(16);
						cur_bg = '';
					}
				}
				break;
			case '\x0f': // plain
				makePlain();
				break;
			case '\x16': // reverse
				if (cur_style & 1) {
					html_str += '</font>';
					if (cur_style & (8|16)) {
						html_str += '<font color="'+cur_fg+'"';
						if (cur_bg)
							html_str += ' style="background:'+cur_bg+'"';
						html_str +='>';
					}
					cur_style &= ~(1);
				}
				else {
					//html_str += '<font color="'+document.bgColor+'" style="background:'+document.fgColor+'">';
					if (cur_style & (8|16)) {
						html_str += '</font>';
					}
					html_str += '<font color="#ffffff" style="background:#000000">';
					cur_style |= 1;
				}
				break;
			case '\x1f': // underline
				if (cur_style & 2) {
					html_str += '</u>';
					cur_style &= ~(2);
				}
				else {
					html_str += '<u>';
					cur_style |= 2;
				}
				break;
			default:
				html_str += str.charAt(i);
			}
		}

		makePlain();
	}

	return html_str;
}

function mIRC2Text(str)
{
	// \x03:color, \x02:bold, \x1f:underline, \x16:reverse, \x0f:plain
	return str.replace(/\x03(([0-9]{1,2})(,([0-9]{1,2}))?)?/g, '')
		.replace(/[\x02\x1f\x16\x0f]/g, '');
}
