////////////////////////////////////////////////////////////////////////////////
// Status Window

function LoqStatusWindow_WriteUnbuffered(html_txt, paragraph)
{
	var h;
	var y;

	if (this.win.document.body) {
		h = this.win.document.body.scrollHeight - this.win.document.body.clientHeight;
		y = this.win.document.body.scrollTop;
	}

	if (this.curParagraph && this.curParagraph != paragraph)
		this.win.document.writeln('<p>'.concat(html_txt));
	else
		this.win.document.writeln(html_txt);

	if (this.win.document.body) {
		if (y >= h) {
			this.win.scrollTo(0, this.win.document.body.scrollHeight);
		}
	}
}

function LoqStatusWindow_Write(html_txt, paragraph)
{
	if (this.isOpen()) {
		if (this.windowBuffer)
			this.FlushBuffer();
		if (html_txt) {
			this.WriteUnbuffered(html_txt, paragraph);
		}
	}
	else {
		// buffer output
		if (html_txt) {
			var windowBuffer;
			if (this.windowBuffer)
				windowBuffer = this.windowBuffer.concat( [ { 'txt':html_txt, 'par':paragraph } ] );
			else
				windowBuffer = [ { 'txt':html_txt, 'par':paragraph } ];
			this.windowBuffer = windowBuffer;
		}
	}

	this.curParagraph = paragraph;
}

function LoqStatusWindow_WriteLine(html_txt, paragraph)
{
	if (html_txt && html_txt != '')
		this.Write(html_txt + '<br>', paragraph);
	else
		this.Write(html_txt, paragraph);
}

function LoqStatusWindow_FlushBuffer()
{
	if (this.win && this.windowBuffer) {
		var windowBuffer = this.windowBuffer;
		// flush buffer
		for (var i = 0; i < windowBuffer.length; i++) {
			this.WriteUnbuffered(windowBuffer[i].txt, windowBuffer[i].par);
		}
		delete this.windowBuffer;
	}
}

function LoqStatusWindow(win)
{
	this.FlushBuffer = LoqStatusWindow_FlushBuffer;
	this.Write = LoqStatusWindow_Write;
	this.WriteLine = LoqStatusWindow_WriteLine;
	this.WriteUnbuffered = LoqStatusWindow_WriteUnbuffered;

	this.win = win;

	this.SetDocumentHead(
			'<html><head>' +
			//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">' +
			'<base target="_blank">' +
			'<basefont face="Fixedsys">' +
			'</head>' +
			'<body bgcolor="#ffffff">'
			);
	this.SetDocumentTail('</body></html>');
	this.OpenDocument();
}
LoqStatusWindow.prototype = new LoqSimpleWindow;
