////////////////////////////////////////////////////////////////////////////////
// Simple Window

function LoqSimpleWindow_isOpen()
{
	// if (this.win is not undefined, not null) and this.win.open and (not this.win.closed)
	if (this.win && this.win.open && ! this.win.closed)
		return true;
	else
		return false;
}

function LoqSimpleWindow_isLoaded()
{
	if (this.win && this.win.open && ! this.win.closed && this.win.document && this.win.document.readyState == 'complete')
		return true;
	else
		return false;
}

function LoqSimpleWindow_Focus()
{
	this.win.focus();
}

function LoqSimpleWindow_Close()
{
	this.win.close();
}

function LoqSimpleWindow_Write(html_txt)
{
	if (isWindowOpen(this.win)) {
		if (this.windowBuffer)
			this.FlushBuffer();
		if (html_txt) {
			this.WriteUnbuffered(this.win, html_txt, this.scrolling);
		}
	}
	else {
		// buffer output
		if (html_txt) {
			this.BufferIn(html_txt);
		}
	}
}

function LoqSimpleWindow_WriteLine(html_txt)
{
	if (html_txt && html_txt != '')
		this.Write(html_txt + '<br>');
	else
		this.Write(html_txt);
}

function LoqSimpleWindow_BufferIn(html_txt)
{
	var windowBuffer;
	if (this.windowBuffer)
		windowBuffer = this.windowBuffer.concat( [ html_txt ] );
	else
		windowBuffer = [ html_txt ];
	this.windowBuffer = windowBuffer;
}

function LoqSimpleWindow_FlushBuffer()
{
	if (this.win && this.windowBuffer) {
		var windowBuffer = this.windowBuffer;
		delete this.windowBuffer;
		// flush buffer
		for (var i = 0; i < windowBuffer.length; i++) {
			this.WriteUnbuffered(this.win, windowBuffer[i], this.scrolling);
		}
	}
}

function LoqSimpleWindow_OpenDocument(mime_type)
{
	if (this.win && this.win.document) {
		this.win.document.open(mime_type);
	}
	else {
		this.BufferIn('\0'+mime_type);
	}
	if (this.documentHead)
		this.Write(this.documentHead);
}

function LoqSimpleWindow_CloseDocument()
{
	if (this.win && this.win.document) {
		if (this.windowBuffer)
			this.FlushBuffer();
		if (this.documentTail)
			this.Write(this.documentTail);
		this.win.document.close();
	}
	else {
		if (this.documentTail)
			this.Write(this.documentTail);
		this.BufferIn('\xff');
	}
}

function LoqSimpleWindow_SetDocumentHead(head)
{
	this.documentHead = head;
}

function LoqSimpleWindow_SetDocumentTail(tail)
{
	this.documentTail = tail;
}

function LoqSimpleWindow_SetScrolling(scroll)
{
	this.scrolling = scroll;
}


function LoqSimpleWindow_Initialize(win)
{
	this.win = win;
}

function LoqSimpleWindow(win)
{
	this.Initialize = LoqSimpleWindow_Initialize;

	this.Focus = LoqSimpleWindow_Focus;
	this.Close = LoqSimpleWindow_Close;
	this.isLoaded = LoqSimpleWindow_isLoaded;
	this.isOpen = LoqSimpleWindow_isOpen;

	this.OpenDocument = LoqSimpleWindow_OpenDocument;
	this.CloseDocument = LoqSimpleWindow_CloseDocument;
	this.SetDocumentHead = LoqSimpleWindow_SetDocumentHead;
	this.SetDocumentTail = LoqSimpleWindow_SetDocumentTail;
	this.SetScrolling = LoqSimpleWindow_SetScrolling;

	this.Write = LoqSimpleWindow_Write;
	this.WriteLine = LoqSimpleWindow_WriteLine;

	this.BufferIn = LoqSimpleWindow_BufferIn;
	this.FlushBuffer = LoqSimpleWindow_FlushBuffer;
}
LoqSimpleWindow.prototype = new LoqWindow;

