
function LoqNetwork_Connected()
{
	return this.irc_a.connected;
}

function LoqNetwork_Connect(server, port)
{
	return this.irc_a.connect(server, port);
}

function LoqNetwork_Disconnect()
{
	return this.irc_a.disconnect();
}

function LoqNetwork_Send(command, param)
{
	if (this.irc_a.connected) {
		if (param) {
			top.DebugWindow.Trace(command.concat('  ', param), '>');
			this.irc_a.write(command.concat(' ', param));
		}
		else {
			top.DebugWindow.Trace(command, '>');
			this.irc_a.write(command);
		}
	}
	else {
		this.loq_main.status_window.WriteLine('<font color="#000080">*** Not connected to server</font>', 'CER');
	}
}

function LoqNetwork(loq_main, applet)
{
	this.Connected = LoqNetwork_Connected;
	this.Connect = LoqNetwork_Connect;
	this.Disconnect = LoqNetwork_Disconnect;
	this.Send = LoqNetwork_Send;

	this.loq_main = loq_main;
	this.irc_a = applet;
}
