function LoqMain_Initialize(arg)
{
	// properties
	this.protocol_interpreter = new LoqProtocolInterpreter(this);
	this.user_interpreter = new LoqUserInterpreter(this);

	this.chat_status_mgr = new LoqChatStatusMgr();
	this.chat_window_mgr = new LoqChatWindowMgr();

	this.channel_list_data = new Object;
	this.channel_list_window = new LoqChannelListWindow;

	this.status_window = new LoqStatusWindow(arg.status_w);
	//this.debug_window = new LoqDebugWindow();

	this.network = new LoqNetwork(this, arg.applet);

	this.main_w = arg.main_w;
}

function LoqMain_Finalize()
{
	if (this.channel_list_window.isOpen())
		this.channel_list_window.Close();

	this.user_interpreter.Execute('', '/disconnect');

	// close all channel windows
	for (var channel in this.chat_window_mgr.GetChannelWindow()) {
		this.chat_window_mgr.CloseChannelWindow(channel);
	}

	// close all query windows
	for (var nick in this.chat_window_mgr.GetQueryWindow()) {
		this.chat_window_mgr.CloseQueryWindow(nick);
	}

	this.chat_status_mgr.IQuit();
}

function LoqMain(arg)
{
	// methods
	this.Finalize = LoqMain_Finalize;
	this.Initialize = LoqMain_Initialize;
}

