////////////////////////////////////////////////////////////////////////////////
// Framed Window

function LoqFramedWindow_isOpen(frameName)
{
	if (frameName) {
		if (isWindowOpen(this.win) && isWindowOpen(this.win.frames[frameName]))
			return true;
		else
			return false;
	}
	else {
		if (isWindowOpen(this.win))
			return true;
		else
			return false;
	}
}

function LoqFramedWindow_isLoaded(frameName)
{
	if (frameName) {
		if (isWindowLoaded(this.win) && isWindowLoaded(this.win.frames[frameName]))
			return true;
		else
			return false;
	}
	else {
		if (isWindowLoaded(this.win))
			return true;
		else
			return false;
	}
}

function LoqFramedWindow_Focus(frameName)
{
	if (frameName) {
		if (isWindowLoaded(this.win) && isWindowOpen(this.win.frames[frameName]))
			this.win.frames[frameName].focus();
	}
	else {
		this.win.focus();
	}
}

function LoqFramedWindow_Close()
{
	this.win.close();
}

function LoqFramedWindow_Write(frameName, html_txt)
{
	if (isWindowLoaded(this.win) && isWindowOpen(this.win.frames[frameName])) {
		if (this.framesBuffer[frameName])
			this.FlushBuffer(frameName);
		if (html_txt)
			this.WriteUnbuffered(this.win.frames[frameName], html_txt, this.scrolling[frameName]);
	}
	else {
		// buffer output
		if (html_txt) {
			this.BufferIn(frameName, html_txt);
		}
	}
}

function LoqFramedWindow_WriteLine(frameName, html_txt)
{
	if (html_txt && html_txt != '')
		this.Write(frameName, html_txt + '<br>')
	else
		this.Write(frameName, html_txt)
}

function LoqFramedWindow_BufferIn(frameName, html_txt)
{
	if (this.framesBuffer[frameName]) { // append to the buffer
		this.framesBuffer[frameName] = this.framesBuffer[frameName].concat(new Array(html_txt.toString()));
	}
	else { // allocate a new buffer
		this.framesBuffer[frameName] = new Array(html_txt.toString());
	}
}

function LoqFramedWindow_FlushBuffer(frameName)
{
	if (this.win && this.win.frames[frameName] && this.framesBuffer[frameName]) {
		var frameBuffer = this.framesBuffer[frameName];
		delete this.framesBuffer[frameName];
		// flush buffer
		for (var i = 0; i < frameBuffer.length; i++) {
			this.WriteUnbuffered(this.win.frames[frameName], frameBuffer[i], this.scrolling[frameName]);
		}
	}
}

function LoqFramedWindow_OpenDocument(frameName, mime_type)
{
	if (isWindowLoaded(this.win) && isWindowOpen(this.win.frames[frameName])) {
		this.win.frames[frameName].document.open(mime_type);
	}
	else {
		this.BufferIn(frameName, '\0'+mime_type);
	}
	if (this.documentHead[frameName]) {
		this.Write(frameName, this.documentHead[frameName]);
	}
}

function LoqFramedWindow_CloseDocument(frameName)
{
	if (isWindowLoaded(this.win) && isWindowOpen(this.win.frames[frameName])) {
		if (this.framesBuffer[frameName])
			this.FlushBuffer(frameName);
		if (this.documentTail[frameName])
			this.Write(this.documentTail[frameName]);
		this.win.frames[frameName].document.close();
	}
	else {
		if (this.documentTail[frameName])
			this.Write(this.documentTail[frameName]);
		this.BufferIn(frameName, '\xff');
	}
}

function LoqFramedWindow_SetDocumentHead(frameName, head)
{
	this.documentHead[frameName] = head;
}

function LoqFramedWindow_SetDocumentTail(frameName, tail)
{
	this.documentTail[frameName] = tail;
}

function LoqFramedWindow_SetScrolling(frameName, scroll)
{
	this.scrolling[frameName] = scroll;
}


function LoqFramedWindow_Initialize(win)
{
	this.win = win;
	this.framesBuffer = new Object;
	this.documentHead = new Object;
	this.documentTail = new Object;
	this.scrolling = new Object;
}

function LoqFramedWindow()
{
	this.Initialize = LoqFramedWindow_Initialize;

	this.Focus = LoqFramedWindow_Focus;
	this.Close = LoqFramedWindow_Close;
	this.isLoaded = LoqFramedWindow_isLoaded;
	this.isOpen = LoqFramedWindow_isOpen;

	this.OpenDocument = LoqFramedWindow_OpenDocument;
	this.CloseDocument = LoqFramedWindow_CloseDocument;
	this.SetDocumentHead = LoqFramedWindow_SetDocumentHead;
	this.SetDocumentTail = LoqFramedWindow_SetDocumentTail;
	this.SetScrolling = LoqFramedWindow_SetScrolling;

	this.Write = LoqFramedWindow_Write;
	this.WriteLine = LoqFramedWindow_WriteLine;

	this.BufferIn = LoqFramedWindow_BufferIn;
	this.FlushBuffer = LoqFramedWindow_FlushBuffer;
}
LoqFramedWindow.prototype = new LoqWindow;
