////////////////////////////////////////////////////////////////////////////////
// Debug Window

function LoqDebugWindow_Trace(txt, desc)
{
	if (this.isOpen()) {
		if (typeof(desc) == 'undefined') {
			if (LoqDebugWindow_Trace.caller)
				desc = LoqDebugWindow_Trace.caller.toString().match(/^\w+\W(\w+)/)[1]+'()';
			else
				desc = '';
		}

		if (this.windowBuffer)
			this.FlushBuffer();

		var msg;
		msg = '<font color="black">T ('.concat((new Date).toLocaleString(), ') ', desc, '</font> [<font color="blue">', htmlSafeString(txt), '</font>]<br>');

		this.WriteUnbuffered(this.win, msg);
	}
}

function LoqDebugWindow_Error(txt, desc)
{
	if (typeof(desc) == 'undefined') {
		if (LoqDebugWindow_Error.caller)
			desc = LoqDebugWindow_Error.caller.toString().match(/^\w+\W(\w+)/)[1]+'()';
		else
			desc = '';
	}

	var msg;
	msg = '<font color="red">E ('.concat((new Date).toLocaleString(), ') ', desc, '</font> [<font color="blue">', htmlSafeString(txt), '</font>]<br>');

	if (this.isOpen()) {
		if (this.windowBuffer)
			this.FlushBuffer();
		this.WriteUnbuffered(this.win, msg);
	}
	else {
		// buffer output
		this.BufferIn(msg);
	}
}

function LoqDebugWindow_Open()
{
	this.win = window.open('', '', 'width=600, height=100, resizable=yes scrollbars=yes');
	if (this.windowBuffer)
		this.FlushBuffer();
}

function LoqDebugWindow(win)
{
	this.Error = LoqDebugWindow_Error;
	this.Open = LoqDebugWindow_Open;
	this.Trace = LoqDebugWindow_Trace;

	this.win = win;

	this.SetDocumentHead('<html><head><title>Debug</title></head><body topmargin="4px" leftmargin="4px"><tt>');
	this.OpenDocument();
}
LoqDebugWindow.prototype = new LoqSimpleWindow;

var DebugWindow = new LoqDebugWindow;
