////////////////////////////////////////////////////////////////////////////////
// Channel Window Management

function LoqChatWindowMgr_GetChannelWindow(channelName)
{
	if (channelName && this.channelWindows)
		return this.channelWindows[channelName.toLowerCase()];
	else
		return this.channelWindows;
}

function LoqChatWindowMgr_OpenChannelWindow(channelName)
{
	var channel = channelName.toLowerCase();

	if (this.channelWindows[channel]) {
		top.DebugWindow.Error('channel window exists');
		return;
	}

	// open a window
	var channel_win;
	{
		channel_win = top.open('channel_w.html', '',
			'dependent=yes, toolbar=no, status=no, location=no,' +
			'resizable=yes, scrollbars=yes, width=640, height=240');

		/*
		if (! channel_win) {
			top.DebugWindow.Error('failed to open channel window');
			return;
		}
		*/

		channel_win.peer = channelName;
		channel_win.name = channelName;
	}

	// create a window
	var channel_window = new LoqChannelWindow(channel_win);
	{
		//channel_window.UpdateTopic();
		//channel_window.UpdateUserList();
	}

	// register the window
	this.channelWindows[channel] = channel_window;

	return channel_window;
}

function LoqChatWindowMgr_CloseChannelWindow(channelName)
{
	var channel = channelName.toLowerCase();

	var channel_window = this.channelWindows[channel];
	if (! channel_window) {
		top.DebugWindow.Error('channel window does not exist');
		return;
	}

	if (channel_window.isOpen()) {
		channel_window.Close();
	}

	delete this.channelWindows[channel];
}


////////////////////////////////////////////////////////////////////////////////
// Query Window Management

function LoqChatWindowMgr_GetQueryWindow(userNick)
{
	if (userNick && this.queryWindows)
		return this.queryWindows[userNick.toLowerCase()];
	else
		return this.queryWindows;
}

function LoqChatWindowMgr_OpenQueryWindow(userNick)
{
	var nick = userNick.toLowerCase();

	if (this.queryWindows[nick]) {
		top.DebugWindow.Error('query window exists');
		return;
	}

	// open a window
	var query_win;
	{
		query_win = top.open('query_w.html', '',
			'dependent=yes, toolbar=no, status=no, location=no,' +
			'resizable=yes, scrollbars=yes, width=640, height=240');

		/*
		if (! query_win) {
			top.DebugWindow.Error('failed to open query window');
			return;
		}
		*/

		query_win.peer = userNick;
		query_win.name = userNick;
	}

	// create a window
	var query_window = new LoqQueryWindow(query_win);

	// register the window
	this.queryWindows[nick] = query_window;

	return query_window;
}

function LoqChatWindowMgr_CloseQueryWindow(userNick)
{
	var nick = userNick.toLowerCase();

	var query_window = this.queryWindows[nick];
	if (! query_window) {
		top.DebugWindow.Error('query window does not exist');
		return;
	}

	if (query_window.isOpen()) {
		query_window.Close();
	}

	delete this.queryWindows[nick];
}

function LoqChatWindowMgr()
{
	// channel windows
	this.CloseChannelWindow = LoqChatWindowMgr_CloseChannelWindow;
	this.GetChannelWindow = LoqChatWindowMgr_GetChannelWindow;
	this.OpenChannelWindow = LoqChatWindowMgr_OpenChannelWindow;

	this.channelWindows = new Object();

	// query windows
	this.CloseQueryWindow = LoqChatWindowMgr_CloseQueryWindow;
	this.GetQueryWindow = LoqChatWindowMgr_GetQueryWindow;
	this.OpenQueryWindow = LoqChatWindowMgr_OpenQueryWindow;

	this.queryWindows = new Object();
}

