////////////////////////////////////////////////////////////////////////////////
// LoqChatWindow

function LoqChatWindow_WriteMyMessage(myNick, txt)
{
	if (txt.search(/^\1ACTION/) != -1) {
		this.WriteLine('chat_f',
			'<font color="#9c009c">* '.concat(myNick,
				' ',
				Msg2Html(htmlSafeString(txt.substring(8, txt.length-1))),
				'</font>'
			)
		);
	}
	else {
		this.WriteLine('chat_f',
			'<nobr><font color="#ff00ff">&lt;</font>'.concat(
				myNick,
				'<font color="#ff00ff">&gt;</font></nobr> ',
				Msg2Html(htmlSafeString(txt))
			)
		);
	}
}

function LoqChatWindow_WriteUserMessage(userNick, txt)
{
	if (txt.search(/^\1ACTION/) != -1) {
		this.WriteLine('chat_f',
			'<font color="#9c009c">* '.concat(userNick,
				' ',
				Msg2Html(htmlSafeString(txt.substring(8, txt.length-1))),
				'</font>'
			)
		);
	}
	else {
		this.WriteLine('chat_f',
			'<nobr><font color="#0000ff">&lt;</font>'.concat(
				userNick,
				'<font color="#0000ff">&gt;</font></nobr> ',
				Msg2Html(htmlSafeString(txt))
			)
		);
	}
}


////////////////////////////////////////////////////////////////////////////////
// LoqChannelWindow

function LoqChannelWindow_UpdateTopic(channelTopic)
{
	if (! this.isOpen()) {
		top.DebugWindow.Error('channel window is not open');
		return;
	}

	this.OpenDocument('topic_f');

	var topic;
	var title;

	if (channelTopic) {
		topic = Msg2Html(htmlSafeString(channelTopic));
		title = this.win.peer + ': ' + Msg2Text(channelTopic);
	}
	else if (this.isOpen() && this.win.peer) {
		topic = htmlSafeString(this.win.peer);
		title = this.win.peer;
	}
	else {
		topic = '(no topic)'
		title = topic;
	}

	if (this.isOpen()) {
		if (this.win.changeTitle) {
			this.win.changeTitle(title);
		}
		else {
			this.win.channelTitle = title;
		}
	}

	this.Write('topic_f', '<table width="100%" height="100%"><tr><td align="center" valign="middle">'+topic+'</td></tr></table>');

	this.CloseDocument('topic_f');
}

function LoqChannelWindow_UpdateUserList(channelUsers)
{
	if (! this.isOpen()) {
		top.DebugWindow.Error('channel window is not open');
		return;
	}

	this.OpenDocument('users_f');

	if (channelUsers) {
		this.Write('users_f',
			[
				'<script type="text/javascript">',
				'<!--',
				'function Selected(div)',
				'{',
					'div.style.backgroundColor="#0050a0";',
				'}',
				'function Deselected(div)',
				'{',
					'div.style.backgroundColor="#80a0d0";',
				'}',
				'//-->',
				'</script>'
			].join('\n')
		);
		this.Write('users_f', '<table width="100%" cellspacing="0" cellpadding="2" border="0">');
		var num_users = 0;
		for (var nick in channelUsers) {
			num_users++;
		}

		if (num_users > 0) {
			var users = new Array(num_users);

			for (var nick in channelUsers) {
				num_users--;
				users[num_users] = nick;
			}

			users.sort();

			for (var i = 0; i < users.length; i++) {
				users[i] = channelUsers[users[i]].userNick;
				//this.WriteLine('users_f', channelUsers[users[i]].userNick);
				//this.Write('users_f', '<tr onMouseOver="Selected(this)" onMouseOut="Deselected(this)"><td>'.concat(channelUsers[users[i]].userNick, '</td></tr>'));
				//this.Write('users_f', '<div width="100%" onMouseOver="Selected(this)" onMouseOut="Deselected(this)">'.concat(channelUsers[users[i]].userNick, '</div>'));
			}
			this.Write('users_f',
				'<tr onMouseOver="Selected(this)" onMouseOut="Deselected(this)"><td>'.concat(
					users.join('</td></tr><tr onMouseOver="Selected(this)" onMouseOut="Deselected(this)"><td>'),
					'</td></tr>'
				)
			);

		}
		this.Write('users_f', '</table>');
	}

	this.CloseDocument('users_f');
}

function LoqChannelWindow(win)
{
	this.UpdateUserList = LoqChannelWindow_UpdateUserList;
	this.UpdateTopic  = LoqChannelWindow_UpdateTopic;
	this.WriteMyMessage = LoqChatWindow_WriteMyMessage;
	this.WriteUserMessage = LoqChatWindow_WriteUserMessage;

	this.Initialize(win);

	this.SetDocumentHead('chat_f',
		'<html><head>' +
		//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">' +
		'<base target="_blank">' +
		'<basefont face="Fixedsys">' +
		'</head>' +
		'<body bgcolor="#ffffff">'
	);
	this.SetDocumentTail('chat_f', '</body></html>');
	this.OpenDocument('chat_f');

	this.SetScrolling('topic_f', 'none');
	this.SetDocumentHead('topic_f',
		'<html><head>' +
		//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">' +
		'<base target="_blank">' +
		'<basefont face="Fixedsys">' +
		'</head>' +
		'<body text="#ffffff" bgcolor="#0050a0">');
	this.SetDocumentTail('topic_f', '</body></html>');
	this.UpdateTopic();

	this.SetScrolling('users_f', 'none');
	this.SetDocumentHead('users_f',
		'<html><head>' +
		//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">' +
		'<base target="_blank">' +
		'<basefont face="Fixedsys">' +
		'</head>' +
		'<body text="#ffffff" bgcolor="#80a0d0"><nobr>');
	this.SetDocumentTail('users_f', '</body></html>');
	this.OpenDocument('users_f');
}
LoqChannelWindow.prototype = new LoqFramedWindow;


////////////////////////////////////////////////////////////////////////////////
// LoqQueryWindow

function LoqQueryWindow(win)
{
	this.WriteMyMessage = LoqChatWindow_WriteMyMessage;
	this.WriteUserMessage = LoqChatWindow_WriteUserMessage;

	this.Initialize(win);

	this.SetDocumentHead('chat_f',
		'<html><head>' +
		//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">' +
		'<base target="_blank">' +
		'<basefont face="Fixedsys">' +
		'</head>' +
		'<body bgcolor="#ffffff">'
	);
	this.SetDocumentTail('chat_f', '</body></html>');
	this.OpenDocument('chat_f');
}
LoqQueryWindow.prototype = new LoqFramedWindow;

