function LoqChannelListWindow_Open()
{
	{
		this.win = top.open('', '',
		'dependent=yes, toolbar=no, status=no, location=no, resizable=yes, scrollbars=yes, width=800, height=400');

		if (! this.isOpen()) {
			top.DebugWindow.Error('failed to open list window');
			return;
		}
	}
	this.Update();
}

function LoqChannelListWindow_Update(channel_list_data)
{
	this.OpenDocument();

	{
		if (channel_list_data) {
			this.Write(
				[
					'<style type="text/css">',
						'.ch { border-bottom: 1px solid #90b0e0; }',
						'.tp { border-bottom: 1px solid #e0e0e0; }',
					'</style>',
					'<script type="text/javascript">',
					'<!--',
					'function Selected(row)',
					'{',
						'for (var i = 0; i < 3; i++) row.cells[i].style.backgroundColor="#0050a0";',
						'for (var i = 3; i < 7; i++) row.cells[i].style.backgroundColor="#80a0d0";',
					'}',
					'function Deselected(row)',
					'{',
						'for (var i = 0; i < 3; i++) row.cells[i].style.backgroundColor="#80a0d0";',
						'for (var i = 3; i < 7; i++) row.cells[i].style.backgroundColor="#ffffff";',
					'}',
					'//-->',
					'</script>'
				].join('\n')
			);
			this.Write([
					'<table border="0" cellpadding="2" cellspacing="0" width="100%" height="100%">',
					'<tr>'+
						'<td>&nbsp;</td>'+
						'<td width="200px" align="center">Channel</td>'+
						'<td>&nbsp;</td>'+
						'<td width="32px" align="center" colspan="2">Users</td>'+
						'<td>&nbsp;</td>'+
						'<td width="100%" align="left">Topic</td>'+
					'</tr>',
					'<tr height="8" bgcolor="#80a0d0"><td colspan="7"></td></tr>'
			].join('\n'));

			var num_channels = 0;
			var channel_data;

			for (var channel in channel_list_data) {
				num_channels++;
			}

			if (num_channels > 0) {
				var channels = new Array(num_channels);

				var i = 0;
				for (var channel in channel_list_data) {
					channels[i++] = channel;
				}

				channels.sort();

				for (var i = 0; i < channels.length; i++) {
					channel_data = channel_list_data[channels[i]];
					this.Write(
						''.concat(
							'<tr valign="middle" onMouseOver="Selected(this)" onMouseOut="Deselected(this)">',
							'<td bgcolor="#80a0d0"></td><td class="ch" bgcolor="#80a0d0">',
							'<a href="" onClick="return joinChannel(\'',
								jsSafeString(channel_data.channel),
							'\');"><font color="#ffffff">',
								htmlSafeString(channel_data.channel),
							'</font></a></td><td bgcolor="#80a0d0"></td>',
							'<td align="right">',
								channel_data.users,
							'</td><td></td><td></td>',
							'<td class="tp">',
								Msg2Html(htmlSafeString(channel_data.topic)),
							'</td>',
							'</tr>'
						)
					);
				}
				this.Write('<tr><td colspan="2" bgcolor="#80a0d0" align="center"><nobr>'+num_channels+' Channels</td><td bgcolor="#80a0d0"></td><td colspan="4"></td></tr>');
			}

			this.Write('<tr><td colspan="3" bgcolor="#80a0d0" height="100%"></td><td colspan="4"></td></tr>');
			this.Write('</table>');
		}
	}

	//this.CloseDocument();
}

function LoqChannelListWindow()
{
	this.Open = LoqChannelListWindow_Open;
	this.Update = LoqChannelListWindow_Update;

	this.SetDocumentHead([
			'<html><head>',
			//'<meta http-equiv="Content-Type" content="text/html; charset=euc-kr">',
			'<title>Channels</title>',
			'<base target="_blank">',
			'<basefont face="Fixedsys">',
			'<style>',
			'<!--',
			'a:active { text-decoration: none }',
			'a:link { text-decoration: none }',
			'a:visited { text-decoration: none }',
			'a:hover { text-decoration: underline }',
			'-->',
			'</style>',
			'<script type="text/javascript">',
			'<!--',
			'function joinChannel(channel)',
			'{ if (self.opener && self.opener.Loq) self.opener.Loq.user_interpreter.Execute(\'\', \'/join \'+channel); return false; }',
			'function Load()',
			'{ self.opener.Loq.channel_list_window.FlushBuffer(); }',
			'//-->',
			'</script>',
			'</head>',
			'<body text="#000000" link="#000000" vlink="#000000" bgcolor="#ffffff" marginheight="0" marginwidth="0" topmargin="0" leftmargin="0" style="margin:0;padding:0">'
	].join('\n'));

	this.SetDocumentTail('</body></html>');
}
LoqChannelListWindow.prototype = new LoqSimpleWindow;
