import java.io.*;
import java.lang.*;
import java.net.*;
import java.util.*;
import netscape.javascript.*;                                

public class IRC extends java.applet.Applet implements Runnable
{
	Socket sock = null;
	BufferedReader in = null;
	OutputStream out = null;
	String server, port;
	public boolean connected = false;
	Thread reader = null;
	JSObject win = null;

	public void init()
	{
		try {
			// get window
			win = JSObject.getWindow(this);
		}
		catch (Exception e) {
			trace("run[getWindow]", e.toString());
			return;
		}

		if (reader == null) {
			reader = new Thread(this);
			reader.start();
		}
	}

	public void stop()
	{
		if (sock != null && connected) {
			disconnect();
		}

		if (reader != null && reader.isAlive()) {
			win = null;
			try {
				synchronized (reader) {
					reader.notify();
				}
				reader.join(100);
			}
			catch (InterruptedException e) {
				trace("stop", e.toString());
			}
		}
	}

	public void run()
	{
		for (;;) {
			try {
				synchronized (reader) {
					reader.wait();
				}
			}
			catch (InterruptedException e) {
				trace("run[wait]", e.toString());
			}

			if (win == null)
				return;

			try {
				// connect to server
				sock = new Socket(server, Integer.valueOf(port).intValue());
				in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
				out = sock.getOutputStream();
				connected = true;
			}
			catch (Exception e) {
				trace("run[Socket]", e.toString());
				continue;
			}

			try {
				win.eval("if (top && top.Loq) top.Loq.protocol_interpreter.Connected();");
			}
			catch (Exception e) {
				trace("run[eval]", e.toString());
			}

			String line;
			for (;;) {
				try {
					line = in.readLine();
				}
				catch (IOException e) {
					trace("run[readLine]", e.toString());
					line = null;
				}
				if (line == null) {
					trace("run", "Connection closed");
					break;
				}
				try {
					win.eval("if (top && top.Loq) top.Loq.protocol_interpreter.Execute('"+makeJSSafeString(line)+"');");
				}
				catch (Exception e) {
					trace("if (top && top.Loq) top.Loq.protocol_interpreter.Execute('"+makeJSSafeString(line)+"');", e.toString());
				}
			}
			connected = false;

			try {
				win.eval("if (top && top.Loq) top.Loq.protocol_interpreter.Execute(null);");
			}
			catch (Exception e) {
				trace("run[eval]", e.toString());
			}
		}
	}

	public void connect(String srv, String prt)
	{
		server = srv;
		port = prt;

		synchronized (reader) {
			reader.notify();
		}
	}

	public void disconnect()
	{
		try {
			sock.close();
			synchronized (reader) {
				reader.notify();
			}
		}
		catch (IOException e) {
			trace("disconnect", e.toString());
		}
	}

	public void write(String msg)
	{
		byte[] msgAsBytes = (msg+"\r\n").getBytes();

		try {
			out.write(msgAsBytes, 0, msgAsBytes.length);
			out.flush();
		}
		catch (IOException e) {
			trace("write", e.toString());
		}
	}

	static String makeJSSafeString(String str)
	{
		StringBuffer strBuffer = new StringBuffer();
		for (int i = 0; i < str.length(); i++) {
			switch (str.charAt(i)) {
			case '\'':
				strBuffer.append("\\'");
				break;
			case '\\':
				strBuffer.append("\\\\");
				break;
			default:
				strBuffer.append(str.charAt(i));
			}
		}

		return strBuffer.toString();
	}

	void trace(String func, String msg)
	{
		if (msg == null)
			System.err.println("IRC::"+func+"()");
		else
			System.err.println("IRC::"+func+"() ["+msg+"]");
	}
}
