/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.PrintWriter;
import java.net.Socket;
import javax.swing.JApplet;
import netscape.javascript.JSObject;

public class JavaSocketBridge
extends JApplet {
    JSObject browser = null;
    Socket socket = null;
    PrintWriter out = null;
    Listener listener = null;
    boolean running = false;
    String address = null;
    int port = -1;
    boolean connectionDone = false;

    public void init() {
        this.browser = JSObject.getWindow((Applet)this);
    }

    public void stop() {
        this.running = false;
        this.disconnect();
    }

    public void destroy() {
        this.running = false;
        this.disconnect();
    }

    public void start() {
        this.browser.call("java_socket_bridge_ready", null);
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                this.running = false;
                return;
            }
            if (this.address == null || this.port == -1 || this.socket != null) continue;
            this.do_connect(this.address, this.port);
        }
    }

    public boolean connect(String string, int n) {
        this.address = string;
        this.port = n;
        this.connectionDone = false;
        while (!this.connectionDone) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.connectionDone = false;
        return this.socket != null;
    }

    private void do_connect(String string, int n) {
        if (this.socket == null) {
            try {
                this.socket = new Socket(string, n);
                this.out = new PrintWriter(this.socket.getOutputStream());
                this.listener = new Listener(this.socket, this);
                this.listener.start();
                this.log("Java Socket Bridge CONNECTED: " + this.getUrl());
            }
            catch (Exception exception) {
                this.error("Could not connect to " + string + " on port " + n + "\n" + exception.getMessage());
                this.connectionDone = true;
            }
        } else {
            this.error("Already connected to " + this.getUrl());
        }
        this.connectionDone = true;
    }

    public boolean disconnect() {
        if (this.socket != null) {
            try {
                this.log("Java Socket Bridge DISCONNECTED: " + this.getUrl());
                this.listener.close();
                this.out.close();
                this.socket = null;
                this.address = null;
                this.port = -1;
                return true;
            }
            catch (Exception exception) {
                this.error("An error occured while closing the socket\n" + exception.getMessage());
                this.socket = null;
                return false;
            }
        }
        return false;
    }

    public void send(String string) {
        if (this.out != null) {
            try {
                this.out.println(string);
                this.out.flush();
                this.log("Java Socket Bridge SENT: " + string);
            }
            catch (Exception exception) {
                this.error("Could not write to socket\n" + exception.getMessage());
            }
        } else {
            this.error("Not connected");
        }
    }

    public void hear(String string) {
        Object[] objectArray = new Object[]{string};
        this.browser.call("on_socket_get", objectArray);
        this.log("Java Socket Bridge RECEIVED: " + string);
    }

    public void error(String string) {
        string = "Java Socket Bridge ERROR: " + string;
        this.log(string);
        Object[] objectArray = new Object[]{string};
        this.browser.call("on_socket_error", objectArray);
    }

    public void log(String string) {
        System.out.println(string);
    }

    private String getUrl() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getInetAddress().getHostName() + ":" + this.socket.getPort();
    }
}

