#  Music Support: Syntherella

CindyScript offers a wide range of very versatile functions for the generation of audio output.
These audio functions cover the generation of music (via a built-in synthesizer), as well as the generation of algorithmically generated audio samples (how, for instance, does a function sound?).
They can be used to serve many different purposes, e.g.
…

*  …to enhance the appearance of usual Cinderella files
*  …as an integral part of certain Cinderella files (games, physical simulations, etc.)
*  …to demonstrate and study mathematical structures of music
*  …to demonstrate and study mathematical and physical structures of sound

The audio interface is subdivided into two essential parts:

##### MIDI Audio

The [MIDI Functions](MIDI_Functions.md) can be used to create melody and instrument based audio signals.
MIDI is a standard format for electronic music that is used for the communication between electronic instruments (like keyboards) and computers.
The [MIDI Functions](MIDI_Functions.md) of CindyScript represent an interface to a built-in synthesizer of your computer.
It provides access to synthesized musical instruments (pianos, percussion instruments, strings, etc.) and to melodic scales and timing.
Furthermore it gives access to sound characteristics like volume, reverb, balance, etc.
The CindyScript MIDI interface is designed to provide a high-level and intuitive interface to this functionality.

##### Sampled Audio

The sampled audio interface tightly links mathematical functions and processes to audible experiences.
It provides a streamlined set of features that allow to “play” mathematical functions, study harmonic spectra and create sound from algorithmic or physical simulations.

For further, more detailed information, you may refer to the following sections:

*  **[MIDI Functions](MIDI_Functions.md):**
Description of functions for playing tones and melodies, including a discussion of instruments, sound characteristics and timing.

*  **[Sampled-Audio Functions](Sampled-Audio_Functions.md)**: Description of functions for generation of audio samples “from scratch”.
