/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2014 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=2636928640&e<<7,e^=4022730752&e<<15,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=.5*3*Math.PI,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");for(var r=n.EPSILON10,o=n.PI,a=n.TWO_PI;-(o+r)>e;)e+=a;if(-o>e)return-o;for(;e>o+r;)e-=a;return e>o?o:e},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=e%n.TWO_PI;return 0>r?(r+n.TWO_PI)%n.TWO_PI:r},n.equalsEpsilon=function(e,n,o){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");return o=r(o,0),Math.abs(e-n)<=o};var o=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],n=r;e>=n;n++)o.push(t*n);return o[e]},n.incrementWrap=function(e,n,o){if(o=r(o,0),!t(e))throw new i("n is required.");if(o>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=o),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");a=new e(r)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){return Math.asin(n.clamp(e,-1,1))},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};o.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new o);var a=i.clock,u=i.cone,s=e(i.magnitude,1),h=s*Math.sin(u);return n.x=h*Math.cos(a),n.y=h*Math.sin(a),n.z=s*Math.cos(u),n},o.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new o(e,t,i)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o]=i.z},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n],a},o.fromArray=o.unpack,o.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.getMinimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},o.getMaximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o,h=new o;o.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");o.normalize(e,s),o.normalize(i,h);var n=o.dot(s,h),a=o.magnitude(o.cross(s,h,s));return Math.atan2(a,n)};var f=new o;o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,f);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Z,i):n.y<=n.z?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_Z,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.x-i.x)<=n&&Math.abs(e.y-i.y)<=n&&Math.abs(e.z-i.z)<=n},o.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=i.x,h=i.y,f=i.z,w=a*f-u*h,d=u*s-o*f,c=o*h-a*s;return n.x=w,n.y=d,n.z=c,n},o.fromDegrees=function(e,i,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var h=n.toRadians(e),f=n.toRadians(i);return o.fromRadians(h,f,a,u,s)};var w=new o,d=new o,c=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,a,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");a=e(a,0);var h=r(u)?u.radiiSquared:c,f=Math.cos(n);w.x=f*Math.cos(i),w.y=f*Math.sin(i),w.z=Math.sin(n),w=o.normalize(w,w),o.multiplyComponents(h,w,d);var l=Math.sqrt(o.dot(w,d));return d=o.divideByScalar(d,l,d),w=o.multiplyByScalar(w,a,w),r(s)||(s=new o),o.add(d,w,s)},o.fromDegreesArray=function(e,i,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return o.fromRadiansArray(u,i,a)},o.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(0!==e.length%2)throw new t("positions length must be a multiple of 2.");var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],h=e[u+1];n[u/2]=o.fromRadians(s,h,0,i,n[u/2])}return n},o.fromDegreesArrayHeights=function(e,i,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,i,a)},o.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(0!==e.length%3)throw new t("positions length must be a multiple of 3.");var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],h=e[u+1],f=e[u+2];n[u/3]=o.fromRadians(s,h,f,i,n[u/3])}return n},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return o.fromRadians=function(i,n,a,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=i,u.latitude=n,u.height=a,u):new o(i,n,a)},o.fromDegrees=function(e,i,a,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),o.fromRadians(e,i,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.toString=function(e){if(!r(e))throw new t("cartographic is required");return"("+e.longitude+", "+e.latitude+", "+e.height+")"},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return o.toString(this)},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(r,i,n){if(r=t(r,0),i=t(i,0),n=t(n,0),0>r||0>i||0>n)throw new o("All radii components must be greater than or equal to zero.");this._radii=new e(r,i,n),this._radiiSquared=new e(r*r,i*i,n*n),this._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,n*n*n*n),this._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===n?0:1/n),this._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===n?0:1/(n*n)),this._minimumRadius=Math.min(r,i,n),this._maximumRadius=Math.max(r,i,n),this._centerToleranceSquared=u.EPSILON1};n(s.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),s.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new s(n.x,n.y,n.z)},s.fromCartesian3=function(e){return i(e)?new s(e.x,e.y,e.z):new s},s.WGS84=a(new s(6378137,6378137,6356752.314245179)),s.UNIT_SPHERE=a(new s(1,1,1)),s.MOON=a(new s(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.geocentricSurfaceNormal=e.normalize,s.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new o("cartographic is required.");var n=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(n),h=u*Math.sin(n),f=Math.sin(a);return i(t)||(t=new e),t.x=s,t.y=h,t.z=f,e.normalize(t,t)},s.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,f=new e;s.prototype.cartographicToCartesian=function(r,t){var n=h,o=f;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(o,n,t)},s.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new o("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var w=new e,d=new e,c=new e;s.prototype.cartesianToCartographic=function(t,n){var o=this.scaleToGeodeticSurface(t,d);if(!i(o))return void 0;var a=this.geodeticSurfaceNormal(o,w),s=e.subtract(t,o,c),h=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=h,n.latitude=f,n.height=l,n):new r(h,f,l)},s.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new o("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var l=new e,m=new e;return s.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");var n=r.x,a=r.y,s=r.z,h=this._oneOverRadii,f=h.x,w=h.y,d=h.z,c=n*n*f*f,p=a*a*w*w,y=s*s*d*d,g=c+p+y,q=Math.sqrt(1/g),x=e.multiplyByScalar(r,q,l);if(g<this._centerToleranceSquared)return isFinite(q)?e.clone(x,t):void 0;var v=this._oneOverRadiiSquared,M=v.x,b=v.y,z=v.z,S=m;S.x=2*x.x*M,S.y=2*x.y*b,S.z=2*x.z*z;var E,R,I,O,_,P,C,T,N,A,L,U=(1-q)*e.magnitude(r)/(.5*e.magnitude(S)),B=0;do{U-=B,I=1/(1+U*M),O=1/(1+U*b),_=1/(1+U*z),P=I*I,C=O*O,T=_*_,N=P*I,A=C*O,L=T*_,E=c*P+p*C+y*T-1,R=c*N*M+p*A*b+y*L*z;var W=-2*R;B=E/W}while(Math.abs(E)>u.EPSILON12);return i(t)?(t.x=n*I,t.y=a*O,t.z=s*_,t):new e(n*I,a*O,s*_)},s.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");i(t)||(t=new e);var n=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,h=1/Math.sqrt(n*n*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,h,t)},s.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},s.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},s.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},s.prototype.toString=function(){return this._radii.toString()},s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,i,n,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var n=this._semimajorAxis,o=r.longitude*n,a=r.latitude*n,u=r.height;return i(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,u=e.y*n,s=e.z;return i(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",[],function(){"use strict";var e={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(r,t,i,n){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0),this.w=e(n,0)};n.fromElements=function(e,t,i,o,a){return r(a)?(a.x=e,a.y=t,a.z=i,a.w=o,a):new n(e,t,i,o)},n.fromColor=function(e,i){if(!r(e))throw new t("color is required");return r(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new n(e.red,e.green,e.blue,e.alpha)},n.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new n(e.x,e.y,e.z,e.w):void 0},n.packedLength=4,n.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o++]=i.z,n[o]=i.w},n.unpack=function(i,o,a){if(!r(i))throw new t("array is required");return o=e(o,0),r(a)||(a=new n),a.x=i[o++],a.y=i[o++],a.z=i[o++],a.w=i[o],a},n.fromArray=n.unpack,n.getMaximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},n.getMinimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},n.getMinimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},n.getMaximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},n.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},n.magnitude=function(e){return Math.sqrt(n.magnitudeSquared(e))};var o=new n;n.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return n.subtract(e,i,o),n.magnitude(o)},n.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var o=n.magnitude(e);return i.x=e.x/o,i.y=e.y/o,i.z=e.z/o,i.w=e.w/o,i},n.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},n.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},n.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},n.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},n.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},n.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},n.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},n.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var a=new n;n.lerp=function(e,i,o,u){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof o)throw new t("t is required and must be a number.");if(!r(u))throw new t("result is required.");return n.multiplyByScalar(i,o,a),u=n.multiplyByScalar(e,1-o,u),n.add(a,u,u)};var u=new n;return n.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var o=n.normalize(e,u);return n.abs(o,o),i=o.x<=o.y?o.x<=o.z?o.x<=o.w?n.clone(n.UNIT_X,i):n.clone(n.UNIT_W,i):o.z<=o.w?n.clone(n.UNIT_Z,i):n.clone(n.UNIT_W,i):o.y<=o.z?o.y<=o.w?n.clone(n.UNIT_Y,i):n.clone(n.UNIT_W,i):o.z<=o.w?n.clone(n.UNIT_Z,i):n.clone(n.UNIT_W,i)},n.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},n.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.x-i.x)<=n&&Math.abs(e.y-i.y)<=n&&Math.abs(e.z-i.z)<=n&&Math.abs(e.w-i.w)<=n},n.ZERO=i(new n(0,0,0,0)),n.UNIT_X=i(new n(1,0,0,0)),n.UNIT_Y=i(new n(0,1,0,0)),n.UNIT_Z=i(new n(0,0,1,0)),n.UNIT_W=i(new n(0,0,0,1)),n.prototype.clone=function(e){return n.clone(this,e)},n.prototype.equals=function(e){return n.equals(this,e)},n.prototype.equalsEpsilon=function(e,r){return n.equalsEpsilon(this,e,r)},n.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},n}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var i=e[t];r+=i*i}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var i=e[h.getElementIndex(c[t],d[t])];r+=2*i*i}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var u=Math.abs(e[h.getElementIndex(c[a],d[a])]);u>i&&(n=a,i=u)}var s=1,f=0,w=d[n],l=c[n];if(Math.abs(e[h.getElementIndex(l,w)])>t){var m,p=e[h.getElementIndex(l,l)],y=e[h.getElementIndex(w,w)],g=e[h.getElementIndex(l,w)],q=(p-y)/2/g;m=0>q?-1/(-q+Math.sqrt(1+q*q)):1/(q+Math.sqrt(1+q*q)),s=1/Math.sqrt(1+m*m),f=m*s}return r=h.clone(h.IDENTITY,r),r[h.getElementIndex(w,w)]=r[h.getElementIndex(l,l)]=s,r[h.getElementIndex(l,w)]=f,r[h.getElementIndex(w,l)]=-f,r}var h=function(e,t,i,n,o,a,u,s,h){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(i,0),this[7]=r(a,0),this[8]=r(h,0)};h.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new h(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},h.fromArray=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new h),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o[9]=e[n+9],o},h.fromColumnMajorArray=function(e,r){if(!t(e))throw new i("values parameter is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!t(e))throw new i("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},h.fromQuaternion=function(e,r){if(!t(e))throw new i("quaternion is required");var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,f=e.y*e.z,w=e.y*e.w,d=e.z*e.z,c=e.z*e.w,l=e.w*e.w,m=n-s-d+l,p=2*(o-c),y=2*(a+w),g=2*(o+c),q=-n+s-d+l,x=2*(f-u),v=2*(a-w),M=2*(f+u),b=-n-s+d+l;return t(r)?(r[0]=m,r[1]=g,r[2]=v,r[3]=p,r[4]=q,r[5]=M,r[6]=y,r[7]=x,r[8]=b,r):new h(m,p,y,g,q,x,v,M,b)},h.fromScale=function(e,r){if(!t(e))throw new i("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new h(e.x,0,0,0,e.y,0,0,0,e.z)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new h(e,0,0,0,e,0,0,0,e)},h.fromRotationX=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new h(1,0,0,0,n,-o,0,o,n)},h.fromRotationY=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new h(n,0,o,0,1,0,-o,0,n)},h.fromRotationZ=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new h(n,-o,0,o,n,0,0,0,1)},h.toArray=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+r},h.getColumn=function(r,n,o){if(!t(r))throw new i("matrix is required.");if("number"!=typeof n||0>n||n>2)throw new i("index must be 0, 1, or 2.");var a=3*n,u=r[a],s=r[a+1],h=r[a+2];return t(o)?(o.x=u,o.y=s,o.z=h,o):new e(u,s,h)},h.setColumn=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");o=h.clone(e,o);var a=3*r;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o},h.getRow=function(r,n,o){if(!t(r))throw new i("matrix is required.");if("number"!=typeof n||0>n||n>2)throw new i("index must be 0, 1, or 2.");var a=r[n],u=r[n+3],s=r[n+6];return t(o)?(o.x=a,o.y=u,o.z=s,o):new e(a,u,s)},h.setRow=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");return o=h.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var f=new e;h.getScale=function(r,n){if(!t(r))throw new i("matrix is required.");return t(n)||(n=new e),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),n};var w=new e;h.getMaximumScale=function(r){return h.getScale(r,w),e.getMaximumComponent(w)},h.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],w=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],d=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],c=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],l=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return t(n)?(n[0]=o,n[1]=a,n[2]=u,n[3]=s,n[4]=f,n[5]=w,n[6]=d,n[7]=c,n[8]=l,n):new h(o,s,d,a,f,c,u,w,l)},h.multiplyByVector=function(r,n,o){if(!t(r))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");var a=n.x,u=n.y,s=n.z,h=r[0]*a+r[3]*u+r[6]*s,f=r[1]*a+r[4]*u+r[7]*s,w=r[2]*a+r[5]*u+r[8]*s;return t(o)?(o.x=h,o.y=f,o.z=w,o):new e(h,f,w)},h.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");return t(n)?(n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n):new h(e[0]*r,e[3]*r,e[6]*r,e[1]*r,e[4]*r,e[7]*r,e[2]*r,e[5]*r,e[8]*r)},h.negate=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r):new h(-e[0],-e[3],-e[6],-e[1],-e[4],-e[7],-e[2],-e[5],-e[8])},h.transpose=function(e,r){if(!t(e))throw new i("matrix is required");var n=e[0],o=e[3],a=e[6],u=e[1],s=e[4],f=e[7],w=e[2],d=e[5],c=e[8];return t(r)?(r[0]=n,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=f,r[6]=w,r[7]=d,r[8]=c,r):new h(n,u,w,o,s,d,a,f,c)};var d=[1,0,0],c=[2,2,1],l=new h,m=new h;return h.getEigenDecomposition=function(e,r){if(!t(e))throw new i("matrix is required.");var n=o.EPSILON20,f=10,w=0,d=0;
t(r)||(r={});for(var c=r.unitary=h.clone(h.IDENTITY,r.unitary),p=r.diagonal=h.clone(e,r.diagonal),y=n*a(p);f>d&&u(p)>y;)s(p,l),h.transpose(l,m),h.multiply(p,l,p),h.multiply(m,p,p),h.multiply(c,l,c),++w>2&&(++d,w=0);return r},h.abs=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r):new h(Math.abs(e[0]),Math.abs(e[3]),Math.abs(e[6]),Math.abs(e[1]),Math.abs(e[4]),Math.abs(e[7]),Math.abs(e[2]),Math.abs(e[5]),Math.abs(e[8]))},h.determinant=function(e){if(!t(e))throw new i("matrix is required");var r=e[0],n=e[3],o=e[6],a=e[1],u=e[4],s=e[7],h=e[2],f=e[5],w=e[8];return r*(u*w-f*s)+a*(f*o-n*w)+h*(n*s-u*o)},h.inverse=function(e,r){if(!t(e))throw new i("matrix is required");var n=e[0],a=e[1],u=e[2],s=e[3],f=e[4],w=e[5],d=e[6],c=e[7],l=e[8],m=h.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new i("matrix is not invertible");t(r)||(r=new h),r[0]=f*l-c*w,r[1]=c*u-a*l,r[2]=a*w-f*u,r[3]=d*w-s*l,r[4]=n*l-d*u,r[5]=s*u-n*w,r[6]=s*c-d*f,r[7]=d*a-n*c,r[8]=n*f-s*a;var p=1/m;return h.multiplyByScalar(r,p,r)},h.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},h.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},h.IDENTITY=n(new h(1,0,0,0,1,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN1ROW0=3,h.COLUMN1ROW1=4,h.COLUMN1ROW2=5,h.COLUMN2ROW0=6,h.COLUMN2ROW1=7,h.COLUMN2ROW2=8,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n"+"("+this[1]+", "+this[4]+", "+this[7]+")\n"+"("+this[2]+", "+this[5]+", "+this[8]+")"},h}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,i,n,o,a,u,s){"use strict";var h=function(e,r,i,n,o,a,u,s,h,f,w,d,c,l,m,p){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(h,0),this[3]=t(c,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(f,0),this[7]=t(l,0),this[8]=t(i,0),this[9]=t(u,0),this[10]=t(w,0),this[11]=t(m,0),this[12]=t(n,0),this[13]=t(s,0),this[14]=t(d,0),this[15]=t(p,0)};h.packedLength=16,h.pack=function(e,r,o){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},h.unpack=function(e,r,o){if(!i(e))throw new n("array is required");return r=t(r,0),i(o)||(o=new h),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},h.clone=function(e,r){return i(e)?i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new h(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},h.fromArray=h.unpack,h.fromColumnMajorArray=function(e,r){if(!i(e))throw new n("values is required");return h.clone(e,r)},h.fromRowMajorArray=function(e,r){if(!i(e))throw new n("values is required.");return i(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},h.fromRotationTranslation=function(e,r,t){if(!i(e))throw new n("rotation is required.");if(!i(r))throw new n("translation is required.");return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=0,t[4]=e[3],t[5]=e[4],t[6]=e[5],t[7]=0,t[8]=e[6],t[9]=e[7],t[10]=e[8],t[11]=0,t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=1,t):new h(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)},new u,h.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!i(e))throw new n("translation is required.");if(!i(r))throw new n("rotation is required.");if(!i(t))throw new n("scale is required.");i(o)||(o=new h);var a=t.x,u=t.y,s=t.z,f=r.x*r.x,w=r.x*r.y,d=r.x*r.z,c=r.x*r.w,l=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,g=r.z*r.w,q=r.w*r.w,x=f-l-y+q,v=2*(w-g),M=2*(d+p),b=2*(w+g),z=-f+l-y+q,S=2*(m-c),E=2*(d-p),R=2*(m+c),I=-f-l+y+q;return o[0]=x*a,o[1]=b*a,o[2]=E*a,o[3]=0,o[4]=v*u,o[5]=z*u,o[6]=R*u,o[7]=0,o[8]=M*s,o[9]=S*s,o[10]=I*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},h.fromTranslation=function(e,r){return h.fromRotationTranslation(u.IDENTITY,e,r)},h.fromScale=function(e,r){if(!i(e))throw new n("scale is required.");return i(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},h.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return i(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new h(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,w=new e,d=new e;h.fromCamera=function(r,t){if(!i(r))throw new n("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!i(o))throw new n("camera.eye is required.");if(!i(a))throw new n("camera.target is required.");if(!i(u))throw new n("camera.up is required.");e.normalize(e.subtract(a,o,f),f),e.normalize(e.cross(f,u,w),w),e.normalize(e.cross(w,f,d),d);var s=w.x,c=w.y,l=w.z,m=f.x,p=f.y,y=f.z,g=d.x,q=d.y,x=d.z,v=o.x,M=o.y,b=o.z,z=s*-v+c*-M+l*-b,S=g*-v+q*-M+x*-b,E=m*v+p*M+y*b;return i(t)?(t[0]=s,t[1]=g,t[2]=-m,t[3]=0,t[4]=c,t[5]=q,t[6]=-p,t[7]=0,t[8]=l,t[9]=x,t[10]=-y,t[11]=0,t[12]=z,t[13]=S,t[14]=E,t[15]=1,t):new h(s,c,l,z,g,q,x,S,-m,-p,-y,E,0,0,0,1)},h.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=r)throw new n("aspectRatio must be greater than zero.");if(0>=t)throw new n("near must be greater than zero.");if(0>=o)throw new n("far must be greater than zero.");var u=Math.tan(.5*e),s=1/u,f=s/r,w=(o+t)/(t-o),d=2*o*t/(t-o);return i(a)?(a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=w,a[11]=-1,a[12]=0,a[13]=0,a[14]=d,a[15]=0,a):new h(f,0,0,0,0,s,0,0,0,0,w,d,0,0,-1,0)},h.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");var f=1/(r-e),w=1/(o-t),d=1/(u-a),c=-(r+e)*f,l=-(o+t)*w,m=-(u+a)*d;return f*=2,w*=2,d*=-2,i(s)?(s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=d,s[11]=0,s[12]=c,s[13]=l,s[14]=m,s[15]=1,s):new h(f,0,0,c,0,w,0,l,0,0,d,m,0,0,0,1)},h.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");var f=2*a/(r-e),w=2*a/(o-t),d=(r+e)/(r-e),c=(o+t)/(o-t),l=-(u+a)/(u-a),m=-1,p=-2*u*a/(u-a);return i(s)?(s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=d,s[9]=c,s[10]=l,s[11]=m,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s):new h(f,0,d,0,0,w,c,0,0,0,l,p,0,0,m,0)},h.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");var s=2*a/(r-e),f=2*a/(o-t),w=(r+e)/(r-e),d=(o+t)/(o-t),c=-1,l=-1,m=-2*a;return i(u)?(u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=w,u[9]=d,u[10]=c,u[11]=l,u[12]=0,u[13]=0,u[14]=m,u[15]=0,u):new h(s,0,w,0,0,f,d,0,0,0,c,m,0,0,l,0)},h.computeViewportTransformation=function(e,r,n,o){e=t(e,t.EMPTY_OBJECT);var a=t(e.x,0),u=t(e.y,0),s=t(e.width,0),f=t(e.height,0);r=t(r,0),n=t(n,1);var w=.5*s,d=.5*f,c=.5*(n-r),l=w,m=d,p=c,y=a+w,g=u+d,q=r+c,x=1;return i(o)?(o[0]=l,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=y,o[13]=g,o[14]=q,o[15]=x,o):new h(l,0,0,y,0,m,0,g,0,0,p,q,0,0,0,x)},h.toArray=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},h.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+r},h.getColumn=function(e,t,o){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");var a=4*t,u=e[a],s=e[a+1],h=e[a+2],f=e[a+3];return i(o)?(o.x=u,o.y=s,o.z=h,o.w=f,o):new r(u,s,h,f)},h.setColumn=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");o=h.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},h.getRow=function(e,t,o){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");var a=e[t],u=e[t+4],s=e[t+8],h=e[t+12];return i(o)?(o.x=a,o.y=u,o.z=s,o.w=h,o):new r(a,u,s,h)},h.setRow=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");return o=h.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var c=new e;h.getScale=function(r,t){if(!i(r))throw new n("matrix is required.");return i(t)||(t=new e),t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],c)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],c)),t};var l=new e;h.getMaximumScale=function(r){return h.getScale(r,l),e.getMaximumComponent(l)},h.multiply=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");var o=e[0],a=e[1],u=e[2],s=e[3],f=e[4],w=e[5],d=e[6],c=e[7],l=e[8],m=e[9],p=e[10],y=e[11],g=e[12],q=e[13],x=e[14],v=e[15],M=r[0],b=r[1],z=r[2],S=r[3],E=r[4],R=r[5],I=r[6],O=r[7],_=r[8],P=r[9],C=r[10],T=r[11],N=r[12],A=r[13],L=r[14],U=r[15],B=o*M+f*b+l*z+g*S,W=a*M+w*b+m*z+q*S,V=u*M+d*b+p*z+x*S,D=s*M+c*b+y*z+v*S,k=o*E+f*R+l*I+g*O,j=a*E+w*R+m*I+q*O,H=u*E+d*R+p*I+x*O,F=s*E+c*R+y*I+v*O,Z=o*_+f*P+l*C+g*T,G=a*_+w*P+m*C+q*T,X=u*_+d*P+p*C+x*T,Y=s*_+c*P+y*C+v*T,K=o*N+f*A+l*L+g*U,J=a*N+w*A+m*L+q*U,Q=u*N+d*A+p*L+x*U,$=s*N+c*A+y*L+v*U;return i(t)?(t[0]=B,t[1]=W,t[2]=V,t[3]=D,t[4]=k,t[5]=j,t[6]=H,t[7]=F,t[8]=Z,t[9]=G,t[10]=X,t[11]=Y,t[12]=K,t[13]=J,t[14]=Q,t[15]=$,t):new h(B,k,Z,K,W,j,G,J,V,H,X,Q,D,F,Y,$)},h.multiplyTransformation=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");var o=e[0],a=e[1],u=e[2],s=e[4],f=e[5],w=e[6],d=e[8],c=e[9],l=e[10],m=e[12],p=e[13],y=e[14],g=r[0],q=r[1],x=r[2],v=r[4],M=r[5],b=r[6],z=r[8],S=r[9],E=r[10],R=r[12],I=r[13],O=r[14],_=o*g+s*q+d*x,P=a*g+f*q+c*x,C=u*g+w*q+l*x,T=o*v+s*M+d*b,N=a*v+f*M+c*b,A=u*v+w*M+l*b,L=o*z+s*S+d*E,U=a*z+f*S+c*E,B=u*z+w*S+l*E,W=o*R+s*I+d*O+m,V=a*R+f*I+c*O+p,D=u*R+w*I+l*O+y;return i(t)?(t[0]=_,t[1]=P,t[2]=C,t[3]=0,t[4]=T,t[5]=N,t[6]=A,t[7]=0,t[8]=L,t[9]=U,t[10]=B,t[11]=0,t[12]=W,t[13]=V,t[14]=D,t[15]=1,t):new h(_,T,L,W,P,N,U,V,C,A,B,D,0,0,0,1)},h.multiplyByTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],f=o*e[1]+a*e[5]+u*e[9]+e[13],w=o*e[2]+a*e[6]+u*e[10]+e[14];return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=w,t[15]=e[15],t):new h(e[0],e[4],e[8],s,e[1],e[5],e[9],f,e[2],e[6],e[10],w,e[3],e[7],e[11],e[15])};var m=new e;return h.multiplyByUniformScale=function(e,r,t){if("number"!=typeof r)throw new n("scale is required");return m.x=r,m.y=r,m.z=r,h.multiplyByScale(e,m,t)},h.multiplyByScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("scale is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?h.clone(e,t):i(t)?(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t):new h(o*e[0],a*e[4],u*e[8],e[12],o*e[1],a*e[5],u*e[9],e[13],o*e[2],a*e[6],u*e[10],e[14],0,0,0,1)},h.multiplyByVector=function(e,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var a=t.x,u=t.y,s=t.z,h=t.w,f=e[0]*a+e[4]*u+e[8]*s+e[12]*h,w=e[1]*a+e[5]*u+e[9]*s+e[13]*h,d=e[2]*a+e[6]*u+e[10]*s+e[14]*h,c=e[3]*a+e[7]*u+e[11]*s+e[15]*h;return i(o)?(o.x=f,o.y=w,o.z=d,o.w=c,o):new r(f,w,d,c)},h.multiplyByPointAsVector=function(r,t,o){if(!i(r))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var a=t.x,u=t.y,s=t.z,h=r[0]*a+r[4]*u+r[8]*s,f=r[1]*a+r[5]*u+r[9]*s,w=r[2]*a+r[6]*u+r[10]*s;return i(o)?(o.x=h,o.y=f,o.z=w,o):new e(h,f,w)},h.multiplyByPoint=function(r,t,o){if(!i(r))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");var a=t.x,u=t.y,s=t.z,h=r[0]*a+r[4]*u+r[8]*s+r[12],f=r[1]*a+r[5]*u+r[9]*s+r[13],w=r[2]*a+r[6]*u+r[10]*s+r[14];return i(o)?(o.x=h,o.y=f,o.z=w,o):new e(h,f,w)},h.multiplyByScalar=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");return i(t)?(t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t):new h(e[0]*r,e[4]*r,e[8]*r,e[12]*r,e[1]*r,e[5]*r,e[9]*r,e[13]*r,e[2]*r,e[6]*r,e[10]*r,e[14]*r,e[3]*r,e[7]*r,e[11]*r,e[15]*r)},h.negate=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r):new h(-e[0],-e[4],-e[8],-e[12],-e[1],-e[5],-e[9],-e[13],-e[2],-e[6],-e[10],-e[14],-e[3],-e[7],-e[11],-e[15])},h.transpose=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))return new h(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=f,r[15]=e[15],r},h.abs=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r):new h(Math.abs(e[0]),Math.abs(e[4]),Math.abs(e[8]),Math.abs(e[12]),Math.abs(e[1]),Math.abs(e[5]),Math.abs(e[9]),Math.abs(e[13]),Math.abs(e[2]),Math.abs(e[6]),Math.abs(e[10]),Math.abs(e[14]),Math.abs(e[3]),Math.abs(e[7]),Math.abs(e[11]),Math.abs(e[15]))},h.equals=function(e,r){return e===r||i(e)&&i(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[11]===r[11]&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[15]===r[15]},h.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new n("epsilon must be a number");return e===r||i(e)&&i(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},h.getTranslation=function(r,t){if(!i(r))throw new n("matrix is required");return i(t)?(t.x=r[12],t.y=r[13],t.z=r[14],t):new e(r[12],r[13],r[14])},h.getRotation=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r):new u(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10])},h.inverse=function(e,r){if(!i(e))throw new n("matrix is required");var t=e[0],o=e[4],u=e[8],f=e[12],w=e[1],d=e[5],c=e[9],l=e[13],m=e[2],p=e[6],y=e[10],g=e[14],q=e[3],x=e[7],v=e[11],M=e[15],b=y*M,z=g*v,S=p*M,E=g*x,R=p*v,I=y*x,O=m*M,_=g*q,P=m*v,C=y*q,T=m*x,N=p*q,A=b*d+E*c+R*l-(z*d+S*c+I*l),L=z*w+O*c+C*l-(b*w+_*c+P*l),U=S*w+_*d+T*l-(E*w+O*d+N*l),B=I*w+P*d+N*c-(R*w+C*d+T*c),W=z*o+S*u+I*f-(b*o+E*u+R*f),V=b*t+_*u+P*f-(z*t+O*u+C*f),D=E*t+O*o+N*f-(S*t+_*o+T*f),k=R*t+C*o+T*u-(I*t+P*o+N*u);b=u*l,z=f*c,S=o*l,E=f*d,R=o*c,I=u*d,O=t*l,_=f*w,P=t*c,C=u*w,T=t*d,N=o*w;var j=b*x+E*v+R*M-(z*x+S*v+I*M),H=z*q+O*v+C*M-(b*q+_*v+P*M),F=S*q+_*x+T*M-(E*q+O*x+N*M),Z=I*q+P*x+N*v-(R*q+C*x+T*v),G=S*y+I*g+z*p-(R*g+b*p+E*y),X=P*g+b*m+_*y-(O*y+C*g+z*m),Y=O*p+N*g+E*m-(T*g+S*m+_*p),K=T*y+R*m+C*p-(P*p+N*y+I*m),J=t*A+o*L+u*U+f*B;if(Math.abs(J)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return J=1/J,i(r)?(r[0]=A*J,r[1]=L*J,r[2]=U*J,r[3]=B*J,r[4]=W*J,r[5]=V*J,r[6]=D*J,r[7]=k*J,r[8]=j*J,r[9]=H*J,r[10]=F*J,r[11]=Z*J,r[12]=G*J,r[13]=X*J,r[14]=Y*J,r[15]=K*J,r):new h(A*J,W*J,j*J,G*J,L*J,V*J,H*J,X*J,U*J,D*J,F*J,Y*J,B*J,k*J,Z*J,K*J)},h.inverseTransformation=function(e,r){if(!i(e))throw new n("matrix is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],f=e[6],w=e[8],d=e[9],c=e[10],l=e[12],m=e[13],p=e[14],y=-t*l-o*m-a*p,g=-u*l-s*m-f*p,q=-w*l-d*m-c*p;return i(r)?(r[0]=t,r[1]=u,r[2]=w,r[3]=0,r[4]=o,r[5]=s,r[6]=d,r[7]=0,r[8]=a,r[9]=f,r[10]=c,r[11]=0,r[12]=y,r[13]=g,r[14]=q,r[15]=1,r):new h(t,o,a,y,u,s,f,g,w,d,c,q,0,0,0,1)},h.IDENTITY=o(new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),h.COLUMN0ROW0=0,h.COLUMN0ROW1=1,h.COLUMN0ROW2=2,h.COLUMN0ROW3=3,h.COLUMN1ROW0=4,h.COLUMN1ROW1=5,h.COLUMN1ROW2=6,h.COLUMN1ROW3=7,h.COLUMN2ROW0=8,h.COLUMN2ROW1=9,h.COLUMN2ROW2=10,h.COLUMN2ROW3=11,h.COLUMN3ROW0=12,h.COLUMN3ROW1=13,h.COLUMN3ROW2=14,h.COLUMN3ROW3=15,h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.equalsEpsilon=function(e,r){return h.equalsEpsilon(this,e,r)},h.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n"+"("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n"+"("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n"+"("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},h}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,o,a){"use strict";var u=function(e,t,i,n){this.west=r(e,0),this.south=r(t,0),this.east=r(i,0),this.north=r(n,0)};u.fromDegrees=function(e,i,n,o,s){return e=a.toRadians(r(e,0)),i=a.toRadians(r(i,0)),n=a.toRadians(r(n,0)),o=a.toRadians(r(o,0)),t(s)?(s.west=e,s.south=i,s.east=n,s.north=o,s):new u(e,i,n,o)},u.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE,h=0,f=e.length;f>h;h++){var w=e[h];n=Math.min(n,w.longitude),o=Math.max(o,w.longitude),a=Math.min(a,w.latitude),s=Math.max(s,w.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=s,r):new u(n,a,o,s)},u.packedLength=4,u.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},u.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new u),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-a.PI_OVER_TWO||r>a.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-a.PI_OVER_TWO||n>a.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var u=e.east;if("number"!=typeof u)throw new i("east is required to be a number.");if(u<-Math.PI||u>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},u.getSouthwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},u.getNorthwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},u.getNortheast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},u.getSoutheast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},u.getCenter=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=.5*(r.west+r.east),n.latitude=.5*(r.south+r.north),n.height=0,n):new e(.5*(r.west+r.east),.5*(r.south+r.north))},u.intersectWith=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),s=Math.min(e.east,r.east),h=Math.min(e.north,r.north);return t(n)?(n.west=o,n.south=a,n.east=s,n.north=h,n):new u(o,a,s,h)},u.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");return r.longitude>=e.west&&r.longitude<=e.east&&r.latitude>=e.south&&r.latitude<=e.north},u.isEmpty=function(e){if(!t(e))throw new i("rectangle is required");return e.west>=e.east||e.south>=e.north};var s=new e;return u.subsample=function(e,o,u,h){if(!t(e))throw new i("rectangle is required");o=r(o,n.WGS84),u=r(u,0),t(h)||(h=[]);var f=0,w=e.north,d=e.south,c=e.east,l=e.west,m=s;m.height=u,m.longitude=l,m.latitude=w,h[f]=o.cartographicToCartesian(m,h[f]),f++,m.longitude=c,h[f]=o.cartographicToCartesian(m,h[f]),f++,m.latitude=d,h[f]=o.cartographicToCartesian(m,h[f]),f++,m.longitude=l,h[f]=o.cartographicToCartesian(m,h[f]),f++,m.latitude=0>w?w:d>0?d:0;for(var p=1;8>p;++p){var y=-Math.PI+p*a.PI_OVER_TWO;y>l&&c>y&&(m.longitude=y,h[f]=o.cartographicToCartesian(m,h[f]),f++)}return 0===m.latitude&&(m.longitude=l,h[f]=o.cartographicToCartesian(m,h[f]),f++,m.longitude=c,h[f]=o.cartographicToCartesian(m,h[f]),f++),h.length=f,h},u.MAX_VALUE=o(new u(-Math.PI,-a.PI_OVER_TWO,Math.PI,a.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Rectangle"],function(e,r,t,i,n,o,a,u,s,h,f){"use strict";var w=function(r,i){this.center=e.clone(t(r,e.ZERO)),this.radius=t(i,0)},d=new e,c=new e,l=new e,m=new e,p=new e,y=new e,g=new e,q=new e,x=new e,v=new e,M=new e,b=new e;w.fromPoints=function(r,t){if(i(t)||(t=new w),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var n=e.clone(r[0],g),o=e.clone(n,d),a=e.clone(n,c),u=e.clone(n,l),s=e.clone(n,m),h=e.clone(n,p),f=e.clone(n,y),z=r.length,S=1;z>S;S++){e.clone(r[S],n);var E=n.x,R=n.y,I=n.z;E<o.x&&e.clone(n,o),E>s.x&&e.clone(n,s),R<a.y&&e.clone(n,a),R>h.y&&e.clone(n,h),I<u.z&&e.clone(n,u),I>f.z&&e.clone(n,f)}var O=e.magnitudeSquared(e.subtract(s,o,q)),_=e.magnitudeSquared(e.subtract(h,a,q)),P=e.magnitudeSquared(e.subtract(f,u,q)),C=o,T=s,N=O;_>N&&(N=_,C=a,T=h),P>N&&(N=P,C=u,T=f);var A=x;A.x=.5*(C.x+T.x),A.y=.5*(C.y+T.y),A.z=.5*(C.z+T.z);var L=e.magnitudeSquared(e.subtract(T,A,q)),U=Math.sqrt(L),B=v;B.x=o.x,B.y=a.y,B.z=u.z;var W=M;W.x=s.x,W.y=h.y,W.z=f.z;var V=e.multiplyByScalar(e.add(B,W,q),.5,b),D=0;for(S=0;z>S;S++){e.clone(r[S],n);var k=e.magnitude(e.subtract(n,V,q));k>D&&(D=k);var j=e.magnitudeSquared(e.subtract(n,A,q));if(j>L){var H=Math.sqrt(j);U=.5*(U+H),L=U*U;var F=H-U;A.x=(U*A.x+F*n.x)/H,A.y=(U*A.y+F*n.y)/H,A.z=(U*A.z+F*n.z)/H}}return D>U?(e.clone(A,t.center),t.radius=U):(e.clone(V,t.center),t.radius=D),t};var z=new a,S=new e,E=new e,R=new r,I=new r;w.fromRectangle2D=function(e,r,t){return w.fromRectangleWithHeights2D(e,r,0,0,t)},w.fromRectangleWithHeights2D=function(r,n,o,a,u){if(i(u)||(u=new w),!i(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=t(n,z),f.getSouthwest(r,R),R.height=o,f.getNortheast(r,I),I.height=a;var s=n.project(R,S),h=n.project(I,E),d=h.x-s.x,c=h.y-s.y,l=h.z-s.z;u.radius=.5*Math.sqrt(d*d+c*c+l*l);var m=u.center;return m.x=s.x+.5*d,m.y=s.y+.5*c,m.z=s.z+.5*l,u};var O=[];w.fromRectangle3D=function(e,r,n,a){r=t(r,o.WGS84),n=t(n,0);var u;return i(e)&&(u=f.subsample(e,r,n,O)),w.fromPoints(u,a)},w.fromVertices=function(r,o,a,u){if(i(u)||(u=new w),!i(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(o=t(o,e.ZERO),a=t(a,3),3>a)throw new n("stride must be 3 or greater.");var s=g;s.x=r[0]+o.x,s.y=r[1]+o.y,s.z=r[2]+o.z;for(var h=e.clone(s,d),f=e.clone(s,c),z=e.clone(s,l),S=e.clone(s,m),E=e.clone(s,p),R=e.clone(s,y),I=r.length,O=0;I>O;O+=a){var _=r[O]+o.x,P=r[O+1]+o.y,C=r[O+2]+o.z;s.x=_,s.y=P,s.z=C,_<h.x&&e.clone(s,h),_>S.x&&e.clone(s,S),P<f.y&&e.clone(s,f),P>E.y&&e.clone(s,E),C<z.z&&e.clone(s,z),C>R.z&&e.clone(s,R)}var T=e.magnitudeSquared(e.subtract(S,h,q)),N=e.magnitudeSquared(e.subtract(E,f,q)),A=e.magnitudeSquared(e.subtract(R,z,q)),L=h,U=S,B=T;N>B&&(B=N,L=f,U=E),A>B&&(B=A,L=z,U=R);var W=x;W.x=.5*(L.x+U.x),W.y=.5*(L.y+U.y),W.z=.5*(L.z+U.z);var V=e.magnitudeSquared(e.subtract(U,W,q)),D=Math.sqrt(V),k=v;k.x=h.x,k.y=f.y,k.z=z.z;var j=M;j.x=S.x,j.y=E.y,j.z=R.z;var H=e.multiplyByScalar(e.add(k,j,q),.5,b),F=0;for(O=0;I>O;O+=a){s.x=r[O]+o.x,s.y=r[O+1]+o.y,s.z=r[O+2]+o.z;var Z=e.magnitude(e.subtract(s,H,q));Z>F&&(F=Z);var G=e.magnitudeSquared(e.subtract(s,W,q));if(G>V){var X=Math.sqrt(G);D=.5*(D+X),V=D*D;var Y=X-D;W.x=(D*W.x+Y*s.x)/X,W.y=(D*W.y+Y*s.y)/X,W.z=(D*W.z+Y*s.z)/X}}return F>D?(e.clone(W,u.center),u.radius=D):(e.clone(H,u.center),u.radius=F),u},w.fromCornerPoints=function(r,t,o){if(!i(r)||!i(t))throw new n("corner and oppositeCorner are required.");i(o)||(o=new w);var a=o.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),o.radius=e.distance(a,t),o},w.fromEllipsoid=function(r,t){if(!i(r))throw new n("ellipsoid is required.");return i(t)||(t=new w),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t},w.clone=function(r,t){return i(r)?i(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new w(r.center,r.radius):void 0},w.packedLength=4,w.pack=function(e,r,o){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");o=t(o,0);var a=e.center;r[o++]=a.x,r[o++]=a.y,r[o++]=a.z,r[o]=e.radius},w.unpack=function(e,r,o){if(!i(e))throw new n("array is required");r=t(r,0),i(o)||(o=new w);var a=o.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],o.radius=e[r],o};var _=new e,P=new e;w.union=function(r,t,o){if(!i(r))throw new n("left is required.");if(!i(t))throw new n("right is required.");i(o)||(o=new w);var a=r.center,u=t.center;e.add(a,u,P);var s=e.multiplyByScalar(P,.5,P),h=e.magnitude(e.subtract(a,s,_))+r.radius,f=e.magnitude(e.subtract(u,s,_))+t.radius;return o.radius=Math.max(h,f),e.clone(s,o.center),o};var C=new e;w.expand=function(r,t,o){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("point is required.");o=w.clone(r,o);var a=e.magnitude(e.subtract(t,o.center,C));return a>o.radius&&(o.radius=a),o},w.intersect=function(r,t){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("plane is required.");var o=r.center,a=r.radius,s=e.dot(t,o)+t.w;return-a>s?u.OUTSIDE:a>s?u.INTERSECTING:u.INSIDE},w.transform=function(e,r,t){if(!i(e))throw new n("sphere is required.");if(!i(r))throw new n("transform is required.");return i(t)||(t=new w),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=h.getMaximumScale(r)*e.radius,t};var T=new e;w.distanceSquaredTo=function(r,t){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("cartesian is required.");var o=e.subtract(r.center,t,T);return e.magnitudeSquared(o)-r.radius*r.radius},w.transformWithoutScale=function(e,r,t){if(!i(e))throw new n("sphere is required.");if(!i(r))throw new n("transform is required.");return i(t)||(t=new w),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var N=new e;w.getPlaneDistances=function(r,t,o,a){if(!i(r))throw new n("sphere is required.");if(!i(t))throw new n("position is required.");if(!i(o))throw new n("direction is required.");i(a)||(a=new s);var u=e.subtract(r.center,t,N),h=e.multiplyByScalar(o,e.dot(o,u),N),f=e.magnitude(h);return a.start=f-r.radius,a.stop=f+r.radius,a};for(var A=new e,L=new e,U=new e,B=new e,W=new e,V=new r,D=new Array(8),k=0;8>k;++k)D[k]=new e;var j=new a;return w.projectTo2D=function(r,o,a){if(!i(r))throw new n("sphere is required.");o=t(o,j);var u=o.ellipsoid,s=r.center,h=r.radius,f=u.geodeticSurfaceNormal(s,A),d=e.cross(e.UNIT_Z,f,L);e.normalize(d,d);var c=e.cross(f,d,U);e.normalize(c,c),e.multiplyByScalar(f,h,f),e.multiplyByScalar(c,h,c),e.multiplyByScalar(d,h,d);var l=e.negate(c,W),m=e.negate(d,B),p=D,y=p[0];e.add(f,c,y),e.add(y,d,y),y=p[1],e.add(f,c,y),e.add(y,m,y),y=p[2],e.add(f,l,y),e.add(y,m,y),y=p[3],e.add(f,l,y),e.add(y,d,y),e.negate(f,f),y=p[4],e.add(f,c,y),e.add(y,d,y),y=p[5],e.add(f,c,y),e.add(y,m,y),y=p[6],e.add(f,l,y),e.add(y,m,y),y=p[7],e.add(f,l,y),e.add(y,d,y);for(var g=p.length,q=0;g>q;++q){var x=p[q];e.add(s,x,x);var v=u.cartesianToCartographic(x,V);o.project(v,x)}a=w.fromPoints(p,a),s=a.center;var M=s.x,b=s.y,z=s.z;return s.x=z,s.y=M,s.z=b,a},w.equals=function(r,t){return r===t||i(r)&&i(t)&&e.equals(r.center,t.center)&&r.radius===t.radius
},w.prototype.intersect=function(e){return w.intersect(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.clone=function(e){return w.clone(this,e)},w}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,r,t,i,n,o,a){"use strict";function u(e,t,i){var n=e.transformPositionToScaledSpace(t,l),o=r.magnitudeSquared(n),a=Math.sqrt(o),u=r.divideByScalar(n,a,m);o=Math.max(1,o),a=Math.max(1,a);var s=r.dot(u,i),h=r.magnitude(r.cross(u,i,u)),f=1/a,w=Math.sqrt(o-1)*f;return 1/(s*f-h*w)}function s(e,t,i){return 0>=t||t===1/0||t!==t?void 0:r.multiplyByScalar(e,t,i)}function h(e,t){return e.transformPositionToScaledSpace(t,p),r.normalize(p,p)}var f=function(e,t){if(!i(e))throw new o("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new r,this._cameraPositionInScaledSpace=new r,this._distanceToLimbInScaledSpaceSquared=0,i(t)&&(this.cameraPosition=t)};n(f.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid,i=t.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=r.magnitudeSquared(i)-1;r.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=i,this._distanceToLimbInScaledSpaceSquared=n}}});var w=new r;f.prototype.isPointVisible=function(e){var r=this._ellipsoid,t=r.transformPositionToScaledSpace(e,w);return this.isScaledSpacePointVisible(t)},f.prototype.isScaledSpacePointVisible=function(e){var t=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared,n=r.subtract(e,t,w),o=-r.dot(n,t),a=o>i&&o*o/r.magnitudeSquared(n)>i;return!a},f.prototype.computeHorizonCullingPoint=function(e,t,n){if(!i(e))throw new o("directionToPoint is required");if(!i(t))throw new o("positions is required");i(n)||(n=new r);for(var a=this._ellipsoid,f=h(a,e),w=0,d=0,c=t.length;c>d;++d){var l=t[d],m=u(a,l,f);w=Math.max(w,m)}return s(f,w,n)};var d=new r;f.prototype.computeHorizonCullingPointFromVertices=function(e,n,a,f,w){if(!i(e))throw new o("directionToPoint is required");if(!i(n))throw new o("vertices is required");if(!i(a))throw new o("stride is required");i(w)||(w=new r),f=t(f,r.ZERO);for(var c=this._ellipsoid,l=h(c,e),m=0,p=0,y=n.length;y>p;p+=a){d.x=n[p]+f.x,d.y=n[p+1]+f.y,d.z=n[p+2]+f.z;var g=u(c,d,l);m=Math.max(m,g)}return s(l,m,w)};var c=[];f.prototype.computeHorizonCullingPointFromRectangle=function(t,n,u){if(!i(t))throw new o("rectangle is required.");var s=a.subsample(t,n,0,c),h=e.fromPoints(s);return r.magnitude(h.center)<.1*n.minimumRadius?void 0:this.computeHorizonCullingPoint(h.center,s,u)};var l=new r,m=new r,p=new r;return f}),define("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var i={};return i.clipTriangleAtAxisAlignedThreshold=function(e,i,n,o,a,u){if(!r(e))throw new t("threshold is required.");if(!r(i))throw new t("keepAbove is required.");if(!r(n))throw new t("u0 is required.");if(!r(o))throw new t("u1 is required.");if(!r(a))throw new t("u2 is required.");r(u)?u.length=0:u=[];var s,h,f;i?(s=e>n,h=e>o,f=e>a):(s=n>e,h=o>e,f=a>e);var w,d,c,l,m,p,y=s+h+f;return 1===y?s?(w=(e-n)/(o-n),d=(e-n)/(a-n),u.push(1),u.push(2),1!==d&&(u.push(-1),u.push(0),u.push(2),u.push(d)),1!==w&&(u.push(-1),u.push(0),u.push(1),u.push(w))):h?(c=(e-o)/(a-o),l=(e-o)/(n-o),u.push(2),u.push(0),1!==l&&(u.push(-1),u.push(1),u.push(0),u.push(l)),1!==c&&(u.push(-1),u.push(1),u.push(2),u.push(c))):f&&(m=(e-a)/(n-a),p=(e-a)/(o-a),u.push(0),u.push(1),1!==p&&(u.push(-1),u.push(2),u.push(1),u.push(p)),1!==m&&(u.push(-1),u.push(2),u.push(0),u.push(m))):2===y?s||n===e?h||o===e?f||a===e||(d=(e-n)/(a-n),c=(e-o)/(a-o),u.push(2),u.push(-1),u.push(0),u.push(2),u.push(d),u.push(-1),u.push(1),u.push(2),u.push(c)):(p=(e-a)/(o-a),w=(e-n)/(o-n),u.push(1),u.push(-1),u.push(2),u.push(1),u.push(p),u.push(-1),u.push(0),u.push(1),u.push(w)):(l=(e-o)/(n-o),m=(e-a)/(n-a),u.push(0),u.push(-1),u.push(1),u.push(0),u.push(l),u.push(-1),u.push(2),u.push(0),u.push(m)):3===y||(u.push(0),u.push(1),u.push(2)),u},i.computeBarycentricCoordinates=function(i,n,o,a,u,s,h,f,w){if(!r(i))throw new t("x is required.");if(!r(n))throw new t("y is required.");if(!r(o))throw new t("x1 is required.");if(!r(a))throw new t("y1 is required.");if(!r(u))throw new t("x2 is required.");if(!r(s))throw new t("y2 is required.");if(!r(h))throw new t("x3 is required.");if(!r(f))throw new t("y3 is required.");var d=o-h,c=h-u,l=s-f,m=a-f,p=1/(l*d+c*m),y=n-f,g=i-h,q=(l*g+c*y)*p,x=(-m*g+d*y)*p,v=1-q-x;return r(w)?(w.x=q,w.y=x,w.z=v,w):new e(q,x,v)},i}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,i=r.name,n=r.message;t=e(i)&&e(n)?i+": "+n:r.toString();var o=r.stack;return e(o)&&(t+="\n"+o),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var i=function(i){var n,o=[],a={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;o.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=i(s.parameters,o)}catch(h){a.error=h instanceof Error?{name:h.name,message:h.message,stack:h.stack}:h}r(n)||(n=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(o.length=0);try{n(a,o)}catch(h){a.result=void 0,a.error="postMessage failed with error: "+t(h)+"\n  with responseMessage: "+JSON.stringify(a),n(a)}}};return i}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/Intersections2D","../Core/Math","./createTaskProcessorWorker"],function(e,r,t,i,n,o,a,u,s){"use strict";function h(t,i){var s=t.isEastChild,h=t.isNorthChild,z=s?.5:0,S=s?1:.5,E=h?.5:0,R=h?1:.5,I=g,O=q,_=x;I.length=0,O.length=0,_.length=0;var P=v;P.length=0;var C,T,N,A={},L=t.vertices,U=t.indices,B=L.length/3,W=L.subarray(0,B),V=L.subarray(B,2*B),D=L.subarray(2*B,3*B),k=0;for(C=0;B>C;++C)T=W[C]/d,N=V[C]/d,(s&&T>=.5||!s&&.5>=T)&&(h&&N>=.5||!h&&.5>=N)&&(A[C]=k,I.push(T),O.push(N),_.push(D[C]),++k);var j=[];j.push(new f),j.push(new f),j.push(new f);var H=[];H.push(new f),H.push(new f),H.push(new f);var F,Z;for(C=0;C<U.length;C+=3){var G=U[C],X=U[C+1],Y=U[C+2],K=W[G]/d,J=W[X]/d,Q=W[Y]/d;j[0].initializeIndexed(W,V,D,G),j[1].initializeIndexed(W,V,D,X),j[2].initializeIndexed(W,V,D,Y);var $=a.clipTriangleAtAxisAlignedThreshold(.5,s,K,J,Q,c);F=0,F>=$.length||(F=H[0].initializeFromClipResult($,F,j),F>=$.length||(F=H[1].initializeFromClipResult($,F,j),F>=$.length||(F=H[2].initializeFromClipResult($,F,j),Z=a.clipTriangleAtAxisAlignedThreshold(.5,h,H[0].getV(),H[1].getV(),H[2].getV(),l),w(I,O,_,P,A,Z,H),F<$.length&&(H[2].clone(H[1]),H[2].initializeFromClipResult($,F,j),Z=a.clipTriangleAtAxisAlignedThreshold(.5,h,H[0].getV(),H[1].getV(),H[2].getV(),l),w(I,O,_,P,A,Z,H)))))}var er=s?-1:0,rr=h?-1:0,tr=t.minimumHeight,ir=t.maximumHeight,nr=[],or=[],ar=[],ur=[],sr=Number.MAX_VALUE,hr=-sr,fr=m;fr.length=0;var wr=n.clone(t.ellipsoid),dr=t.childRectangle;for(C=0;C<I.length;++C){T=I[C],z>=T?(nr.push(C),T=0):T>=S?(ar.push(C),T=1):T=2*T+er,I[C]=T,N=O[C],E>=N?(or.push(C),N=0):N>=R?(ur.push(C),N=1):N=2*N+rr,O[C]=N;var cr=u.lerp(tr,ir,_[C]/d);sr>cr&&(sr=cr),cr>hr&&(hr=cr),_[C]=cr,p.longitude=u.lerp(dr.west,dr.east,T),p.latitude=u.lerp(dr.south,dr.north,N),p.height=cr,wr.cartographicToCartesian(p,y),fr.push(y.x),fr.push(y.y),fr.push(y.z)}var lr=e.fromVertices(fr,r.ZERO,3,b),mr=new o(wr),pr=mr.computeHorizonCullingPointFromVertices(lr.center,fr,3,lr.center,M),yr=hr-sr,gr=new Uint16Array(I.length+O.length+_.length);for(C=0;C<I.length;++C)gr[C]=I[C]*d;var qr=I.length;for(C=0;C<O.length;++C)gr[qr+C]=O[C]*d;for(qr+=O.length,C=0;C<_.length;++C)gr[qr+C]=d*(_[C]-sr)/yr;var xr=new Uint16Array(P);return i.push(gr.buffer,xr.buffer),{vertices:gr.buffer,indices:xr.buffer,minimumHeight:sr,maximumHeight:hr,westIndices:nr,southIndices:or,eastIndices:ar,northIndices:ur,boundingSphere:lr,horizonOcclusionPoint:pr}}function f(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function w(e,r,t,n,o,a,u){if(0!==a.length){for(var s=0,h=0;h<a.length;)h=z[s++].initializeFromClipResult(a,h,u);for(var f=0;s>f;++f){var w=z[f];if(w.isIndexed())w.newIndex=o[w.index],w.uBuffer=e,w.vBuffer=r,w.heightBuffer=t;else{var d=w.getKey();if(i(o[d]))w.newIndex=o[d];else{var c=e.length;e.push(w.getU()),r.push(w.getV()),t.push(w.getH()),w.newIndex=c,o[d]=c}}}3===s?(n.push(z[0].newIndex),n.push(z[1].newIndex),n.push(z[2].newIndex)):4===s&&(n.push(z[0].newIndex),n.push(z[1].newIndex),n.push(z[2].newIndex),n.push(z[0].newIndex),n.push(z[2].newIndex),n.push(z[3].newIndex))}}var d=32767,c=[],l=[],m=[],p=new t,y=new r,g=[],q=[],x=[],v=[],M=new r,b=new e;f.prototype.clone=function(e){return i(e)||(e=new f),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},f.prototype.initializeIndexed=function(e,r,t,i){this.uBuffer=e,this.vBuffer=r,this.heightBuffer=t,this.index=i,this.first=void 0,this.second=void 0,this.ratio=void 0},f.prototype.initializeInterpolated=function(e,r,t){this.vertexBuffer=void 0,this.index=void 0,this.newIndex=void 0,this.first=e,this.second=r,this.ratio=t},f.prototype.initializeFromClipResult=function(e,r,t){var i=r+1;return-1!==e[r]?t[e[r]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=t[e[i]],++i,this.second=t[e[i]],++i,this.ratio=e[i],++i),i},f.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},f.prototype.isIndexed=function(){return i(this.index)},f.prototype.getH=function(){return i(this.index)?this.heightBuffer[this.index]:u.lerp(this.first.getH(),this.second.getH(),this.ratio)},f.prototype.getU=function(){return i(this.index)?this.uBuffer[this.index]/d:u.lerp(this.first.getU(),this.second.getU(),this.ratio)},f.prototype.getV=function(){return i(this.index)?this.vBuffer[this.index]/d:u.lerp(this.first.getV(),this.second.getV(),this.ratio)};var z=[];return z.push(new f),z.push(new f),z.push(new f),z.push(new f),s(h)})}();